/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringTypeImpl
extends JSEvaluableType {
    @NotNull
    private final Segment mySegment;

    public JSDestructuringTypeImpl(@NotNull Segment segment, @NotNull JSTypeSource source) {
        if (segment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segment", "com/intellij/lang/javascript/psi/types/JSDestructuringTypeImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSDestructuringTypeImpl", "<init>"));
        }
        super(source);
        this.mySegment = segment;
    }

    @Override
    protected JSType processElement(@Nullable Set<PsiElement> expandedElements, @NotNull JSType defaultType, @NotNull PsiElement psiElement) {
        JSType realType;
        if (defaultType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultType", "com/intellij/lang/javascript/psi/types/JSDestructuringTypeImpl", "processElement"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/psi/types/JSDestructuringTypeImpl", "processElement"));
        }
        if (!(psiElement instanceof JSVariable)) {
            return null;
        }
        JSTypeEvaluationResult type = JSTypeEvaluator.getElementType(psiElement);
        JSType result = defaultType;
        if (type != null && (realType = type.getType()) != null) {
            result = realType;
        }
        return result;
    }

    @Override
    @NotNull
    public JSType evaluateType() {
        JSTypeSource source = this.getSource();
        PsiElement element = source.getSourceElement();
        JSAnyType anyType = JSAnyType.get(source.getSourceElement(), source.isExplicitlyDeclared());
        if (element instanceof JSVariable) {
            JSType type = this.processElement(null, anyType, element);
            JSAnyType jSAnyType = type == null ? anyType : type;
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSDestructuringTypeImpl", "evaluateType"));
            }
            return jSAnyType;
        }
        JSType jSType = this.evaluateTypeInRange(ContainerUtil.newHashSet(), this.getSegment());
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSDestructuringTypeImpl", "evaluateType"));
        }
        return jSType;
    }

    @Override
    protected String getPrefix() {
        return "#destr";
    }

    @Override
    @NotNull
    public Segment getSegment() {
        Segment segment = this.mySegment;
        if (segment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSDestructuringTypeImpl", "getSegment"));
        }
        return segment;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSDestructuringTypeImpl", "copyWithNewSource"));
        }
        assert (JSDestructuringTypeImpl.isEmptySource(source) || source.getSourceElement() == this.getSource().getSourceElement());
        JSDestructuringTypeImpl jSDestructuringTypeImpl = new JSDestructuringTypeImpl(this.mySegment, source);
        if (jSDestructuringTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSDestructuringTypeImpl", "copyWithNewSource"));
        }
        return jSDestructuringTypeImpl;
    }

    private static boolean isEmptySource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSDestructuringTypeImpl", "isEmptySource"));
        }
        return source == JSTypeSource.EMPTY || source == JSTypeSource.EMPTY_TS;
    }
}

