/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeofTypeImpl
extends JSEvaluableType {
    private static final Key<ParameterizedCachedValue<JSType, JSTypeofTypeImpl>> CACHED_VALUE_KEY = Key.create((String)"js.typeoftype.evaluated");
    private static final ParameterizedCachedValueProvider<JSType, JSTypeofTypeImpl> CACHED_VALUE_PROVIDER = new ParameterizedCachedValueProvider<JSType, JSTypeofTypeImpl>(){

        @Nullable
        public CachedValueProvider.Result<JSType> compute(JSTypeofTypeImpl param) {
            return CachedValueProvider.Result.create((Object)JSTypeUtils.getApparentType(param.evaluateTypeInRange((Set<PsiElement>)new THashSet(), param.myRange.getRange())), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }
    };
    @NotNull
    private final SmartPsiFileRange myRange;

    public JSTypeofTypeImpl(@NotNull JSExpression expression, @NotNull JSTypeSource source) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "<init>"));
        }
        this(expression.getTextRange(), expression.getContainingFile(), source);
    }

    public JSTypeofTypeImpl(@NotNull TextRange range, @NotNull PsiFile file, @NotNull JSTypeSource source) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "<init>"));
        }
        super(source);
        this.myRange = SmartPointerManager.getInstance((Project)file.getProject()).createSmartPsiFileRangePointer(file, range);
    }

    private JSTypeofTypeImpl(@NotNull SmartPsiFileRange range, JSTypeSource source) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "<init>"));
        }
        super(source);
        this.myRange = range;
    }

    @Override
    public Segment getSegment() {
        return this.myRange.getRange();
    }

    @Override
    protected final String getPrefix() {
        return "#typeof";
    }

    @Override
    @NotNull
    public JSType evaluateType() {
        PsiElement element = this.getSource().getSourceElement();
        if (element != null) {
            JSType jSType = (JSType)CachedValuesManager.getManager((Project)element.getProject()).getParameterizedCachedValue((UserDataHolder)this, CACHED_VALUE_KEY, CACHED_VALUE_PROVIDER, false, (Object)this);
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "evaluateType"));
            }
            return jSType;
        }
        JSType jSType = JSTypeUtils.getApparentType(this.evaluateTypeInRange((Set<PsiElement>)new THashSet(), this.myRange.getRange()));
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "evaluateType"));
        }
        return jSType;
    }

    @Override
    @Nullable
    protected JSType processElement(@Nullable Set<PsiElement> expandedElements, @NotNull JSType defaultType, @NotNull PsiElement psiElement) {
        if (defaultType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultType", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "processElement"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "processElement"));
        }
        if (!(psiElement instanceof JSExpression)) {
            return null;
        }
        JSExpression element = (JSExpression)psiElement;
        if (expandedElements != null) {
            if (expandedElements.contains(element)) {
                return defaultType;
            }
            expandedElements.add((PsiElement)element);
        }
        Ref exprTypeRef = Ref.create(null);
        JSTypeEvaluator.processWithEvaluationGuard(element, JSEvaluateContext.JSEvaluationPlace.TYPEOF_TYPE, e -> exprTypeRef.set((Object)JSResolveUtil.getExpressionJSType(e)));
        JSType exprType = (JSType)exprTypeRef.get();
        if (exprType != null) {
            JSTypeSource exprTypeSource = exprType.getSource();
            boolean isExplicitlyDeclared = this.getSource().isExplicitlyDeclared() && exprTypeSource.isExplicitlyDeclared();
            exprType = JSTypeUtils.copyWithExplicitlyDeclared(exprType, isExplicitlyDeclared);
            exprType = exprType.transformTypeHierarchy(type -> {
                if (type instanceof JSTypeofTypeImpl) {
                    JSTypeofTypeImpl typeofType = (JSTypeofTypeImpl)((Object)type);
                    return typeofType.evaluateTypeInRange(expandedElements, typeofType.getRange().getRange());
                }
                return type;
            });
        }
        return exprType != null ? exprType : defaultType;
    }

    @NotNull
    public SmartPsiFileRange getRange() {
        SmartPsiFileRange smartPsiFileRange = this.myRange;
        if (smartPsiFileRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "getRange"));
        }
        return smartPsiFileRange;
    }

    @Override
    @NotNull
    protected JSTypeofTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "copyWithNewSource"));
        }
        JSTypeofTypeImpl jSTypeofTypeImpl = new JSTypeofTypeImpl(this.myRange, source);
        if (jSTypeofTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/JSTypeofTypeImpl", "copyWithNewSource"));
        }
        return jSTypeofTypeImpl;
    }

    @Override
    protected boolean isEquivalentCommon(@Nullable JSType rOperand, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        return false;
    }
}

