/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeMemberParser {
    @Nullable
    public static JSRecordType.TypeMember buildTypeMember(@NotNull TypeScriptTypeMember member, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser", "buildTypeMember"));
        }
        if (TypeScriptTypeMemberParser.isEmptySubstitutor(typeSubstitutor)) {
            if (TypeScriptTypeMemberParser.isPropertyNameEmpty((PsiElement)member)) {
                return null;
            }
            return member;
        }
        JSRecordType.TypeMember typeMember = null;
        if (member instanceof TypeScriptPropertySignature) {
            typeMember = TypeScriptTypeMemberParser.copyPropertySignature((TypeScriptPropertySignature)member, typeSubstitutor);
        } else if (member instanceof TypeScriptFunctionSignature) {
            typeMember = TypeScriptTypeMemberParser.copyFunctionSignature((TypeScriptFunctionSignature)member, typeSubstitutor);
        } else if (member instanceof TypeScriptCallSignature) {
            typeMember = TypeScriptTypeMemberParser.copyCallSignature((TypeScriptCallSignature)member, typeSubstitutor);
        } else if (member instanceof TypeScriptIndexSignature) {
            typeMember = TypeScriptTypeMemberParser.copyIndexSignature((TypeScriptIndexSignature)member, typeSubstitutor);
        }
        return typeMember;
    }

    static boolean isEmptySubstitutor(@Nullable JSTypeSubstitutor typeSubstitutor) {
        return typeSubstitutor == null || typeSubstitutor == JSTypeSubstitutor.EMPTY || typeSubstitutor.isEmpty();
    }

    @NotNull
    private static JSRecordType.TypeMember copyIndexSignature(@NotNull TypeScriptIndexSignature indexSignature, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (indexSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexSignature", "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser", "copyIndexSignature"));
        }
        JSType signatureType = indexSignature.getMemberType();
        JSType parameterType = indexSignature.getMemberParameterType();
        JSRecordTypeImpl.IndexSignatureImpl indexSignatureImpl = new JSRecordTypeImpl.IndexSignatureImpl(JSTypeUtils.applyGenericArguments(parameterType, (Map<String, JSType>)typeSubstitutor), JSTypeUtils.applyGenericArguments(signatureType, (Map<String, JSType>)typeSubstitutor), (PsiElement)indexSignature);
        if (indexSignatureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser", "copyIndexSignature"));
        }
        return indexSignatureImpl;
    }

    @NotNull
    private static JSRecordType.TypeMember copyCallSignature(@NotNull TypeScriptCallSignature member, @Nullable JSTypeSubstitutor typeSubstitutor) {
        JSRecordTypeImpl.CallSignatureImpl typeMember;
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser", "copyCallSignature"));
        }
        JSFunctionTypeImpl functionType = (JSFunctionTypeImpl)JSTypeUtils.applyGenericArguments(member.getFunctionType(), (Map<String, JSType>)typeSubstitutor);
        JSRecordTypeImpl.CallSignatureImpl callSignatureImpl = typeMember = new JSRecordTypeImpl.CallSignatureImpl(member.isConstructor(), functionType);
        if (callSignatureImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser", "copyCallSignature"));
        }
        return callSignatureImpl;
    }

    @Nullable
    private static JSRecordType.TypeMember copyFunctionSignature(@NotNull TypeScriptFunctionSignature functionSignature, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (functionSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionSignature", "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser", "copyFunctionSignature"));
        }
        String name = functionSignature.getMemberName();
        if (!StringUtil.isEmpty((String)name)) {
            JSType type = JSTypeUtils.applyGenericArguments(functionSignature.getType(), (Map<String, JSType>)typeSubstitutor);
            return new JSRecordTypeImpl.PropertySignatureImpl(name, type, functionSignature.isOptional(), (PsiElement)functionSignature);
        }
        return null;
    }

    @Nullable
    private static JSRecordType.TypeMember copyPropertySignature(@NotNull TypeScriptPropertySignature propertySignature, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (propertySignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertySignature", "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser", "copyPropertySignature"));
        }
        JSType type = propertySignature.getType();
        String name = propertySignature.getMemberName();
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        return new JSRecordTypeImpl.PropertySignatureImpl(name, JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)typeSubstitutor), propertySignature.isOptional(), (PsiElement)propertySignature);
    }

    static boolean isPropertyNameEmpty(@NotNull PsiElement member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser", "isPropertyNameEmpty"));
        }
        return member instanceof JSRecordType.PropertySignature && StringUtil.isEmpty((String)((JSRecordType.PropertySignature)member).getMemberName());
    }

    public static JSRecordType.TypeMember buildTypeMember(@NotNull TypeScriptTypeMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser", "buildTypeMember"));
        }
        return TypeScriptTypeMemberParser.buildTypeMember(member, JSTypeSubstitutor.EMPTY);
    }

    @Nullable
    public static JSRecordType.TypeMember buildTypeMemberFromClassMember(@NotNull JSClass ownerClass, @NotNull JSElement member, boolean isStatic, @NotNull JSTypeSource source, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser", "buildTypeMemberFromClassMember"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser", "buildTypeMemberFromClassMember"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser", "buildTypeMemberFromClassMember"));
        }
        if (member instanceof JSFunction && ((JSFunction)member).isConstructor()) {
            if (isStatic) {
                JSType constructorReturnType = TypeScriptTypeParser.createConstructorReturnType(ownerClass, source);
                TypeScriptJSFunctionTypeImpl functionType = TypeScriptTypeParser.buildTypeScriptFunctionTypeImpl((JSFunction)member, constructorReturnType);
                TypeScriptJSFunctionTypeImpl type = (TypeScriptJSFunctionTypeImpl)JSTypeUtils.applyGenericArguments(functionType, (Map<String, JSType>)typeSubstitutor);
                return new JSRecordTypeImpl.CallSignatureImpl(true, type);
            }
            return null;
        }
        if (!TypeScriptTypeMemberParser.checkStatics((PsiElement)member, isStatic)) {
            return null;
        }
        if (member instanceof TypeScriptTypeMember) {
            return TypeScriptTypeMemberParser.buildTypeMember((TypeScriptTypeMember)member, typeSubstitutor);
        }
        if (TypeScriptTypeMemberParser.isEmptySubstitutor(typeSubstitutor) && member instanceof JSRecordType.TypeMember) {
            if (TypeScriptTypeMemberParser.isPropertyNameEmpty((PsiElement)member)) {
                return null;
            }
            return (JSRecordType.TypeMember)member;
        }
        String name = member.getName();
        if (name == null && member instanceof JSComputedPropertyNameOwner) {
            name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)member);
        }
        if (name == null) {
            return null;
        }
        JSType typeForProperty = TypeScriptTypeParser.buildTypeFromClassMember((PsiElement)member);
        JSType type = JSTypeUtils.applyGenericArguments(typeForProperty, (Map<String, JSType>)typeSubstitutor);
        boolean optional = member instanceof TypeScriptFunction && ((TypeScriptFunction)member).isOptional();
        return new JSRecordTypeImpl.PropertySignatureImpl(name, type, optional, (PsiElement)member);
    }

    private static boolean checkStatics(@NotNull PsiElement member, boolean isStatic) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser", "checkStatics"));
        }
        if (!(member instanceof JSElementBase)) {
            return true;
        }
        JSContext context = ((JSElementBase)member).getJSContext();
        boolean isContextStatic = context == JSContext.STATIC;
        return isStatic == isContextStatic;
    }
}

