/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSClassUtils {
    private JSClassUtils() {
    }

    public static boolean canHaveClasses(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/util/JSClassUtils", "canHaveClasses"));
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
        return holder != null && holder.hasFeature(JSLanguageFeature.CLASSES);
    }

    @NotNull
    public static String createClassFunctionName(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/util/JSClassUtils", "createClassFunctionName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/util/JSClassUtils", "createClassFunctionName"));
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        assert (holder != null);
        if (holder.isTypeScript || holder.isECMA6) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSClassUtils", "createClassFunctionName"));
            }
            return string;
        }
        String string = "function " + name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSClassUtils", "createClassFunctionName"));
        }
        return string;
    }

    @Nullable
    public static String getDefaultFieldQualifier(@NotNull PsiElement context, boolean withDot) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/util/JSClassUtils", "getDefaultFieldQualifier"));
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        if (holder != null && (holder.isTypeScript || holder.isECMA6)) {
            return "this" + (withDot ? "." : "");
        }
        return null;
    }

    @Nullable
    public static String getAnyTypeString(@NotNull PsiElement context, boolean strict) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/util/JSClassUtils", "getAnyTypeString"));
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        if (holder != null && holder.isECMA4) {
            return "*";
        }
        if (holder != null && holder.isTypeScript && strict) {
            return "any";
        }
        return null;
    }

    public static String createConstructorSignatureForClass(JSClass jsClass, boolean isPublic) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)jsClass);
        assert (holder != null);
        if (holder.isECMA4) {
            return (isPublic ? "public " : "") + "function " + jsClass.getName();
        }
        return "constructor";
    }

    @NotNull
    public static String getCast(@NotNull String type, @NotNull String expr, @NotNull DialectOptionHolder holder) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/util/JSClassUtils", "getCast"));
        }
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/lang/javascript/psi/util/JSClassUtils", "getCast"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/psi/util/JSClassUtils", "getCast"));
        }
        if (holder.isTypeScript) {
            if (holder.isJSX) {
                String string = expr + " as " + type;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSClassUtils", "getCast"));
                }
                return string;
            }
            String string = "<" + type + ">" + expr;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSClassUtils", "getCast"));
            }
            return string;
        }
        String string = type + "(" + expr + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/util/JSClassUtils", "getCast"));
        }
        return string;
    }

    public static boolean isAllowImplementation(@NotNull JSClass jsClass, @Nullable PsiElement context) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/psi/util/JSClassUtils", "isAllowImplementation"));
        }
        return jsClass.isInterface() || context != null && DialectDetector.isTypeScript(context);
    }

    @Contract(value="null -> false")
    public static boolean isPossibleHierarchyMember(@Nullable PsiElement element) {
        return element instanceof JSFunction || element instanceof JSField && DialectDetector.isTypeScript(element);
    }
}

