/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringUtil {
    @Nullable
    public static PsiElement getParentSkippingDestructuring(@NotNull JSVariable var) {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "getParentSkippingDestructuring"));
        }
        PsiElement parent = var.getParent();
        while (JSDestructuringUtil.isDestructuring(parent)) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static boolean isDestructuring(@Nullable PsiElement parent) {
        return parent instanceof JSDestructuringContainer || parent instanceof JSDestructuringProperty;
    }

    @Nullable
    public static ASTNode getParentSkippingDestructuring(@NotNull ASTNode varNode) {
        if (varNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varNode", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "getParentSkippingDestructuring"));
        }
        ASTNode parent = varNode.getTreeParent();
        while (JSElementTypes.DESTRUCTURING_CONTAINERS.contains(parent.getElementType()) || JSStubElementTypes.DESTRUCTURING_PROPERTIES.contains(parent.getElementType())) {
            if ((parent = parent.getTreeParent()) != null) continue;
            return null;
        }
        return parent;
    }

    @Nullable
    public static JSExpression getNearestDestructuringInitializer(@NotNull JSVariable var) {
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "getNearestDestructuringInitializer"));
        }
        PsiElement parent = var.getParent();
        while (JSDestructuringUtil.isDestructuring(parent)) {
            JSExpression initializer;
            if (parent instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)parent).getInitializer()) != null) {
                return initializer;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Nullable
    public static JSExpression getNearestDestructuringInitializer(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "getNearestDestructuringInitializer"));
        }
        PsiElement parent = referenceExpression.getParent();
        while (parent instanceof JSProperty || parent instanceof JSObjectLiteralExpression || parent instanceof JSArrayLiteralExpression) {
            parent = parent.getParent();
        }
        return parent instanceof JSDefinitionExpression ? ((JSDefinitionExpression)parent).getInitializer() : null;
    }

    @Nullable
    public static JSInitializerOwner findDestructuringParent(@NotNull JSVariable jsVariable, @NotNull JSEvaluateContext context, @NotNull Condition<JSInitializerOwner> parentCondition) {
        if (jsVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsVariable", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "findDestructuringParent"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "findDestructuringParent"));
        }
        if (parentCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCondition", "com/intellij/lang/javascript/psi/util/JSDestructuringUtil", "findDestructuringParent"));
        }
        JSVariable element = jsVariable;
        while (element instanceof JSDestructuringContainer || element instanceof JSDestructuringProperty || element instanceof JSInitializerOwner) {
            if (element instanceof JSInitializerOwner && parentCondition.value((Object)((JSInitializerOwner)element))) {
                return (JSInitializerOwner)element;
            }
            if (element instanceof JSDestructuringArray || element instanceof JSDestructuringProperty) {
                context.pushJSElementToApply((JSElement)element);
            }
            element = element.getParent();
        }
        return null;
    }
}

