/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator;

import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureInfo;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class JSFunctionSignatureGenerator {
    public StringBuilder getSignature(@NotNull JSFunctionSignatureInfo info, PsiElement context) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureGenerator", "getSignature"));
        }
        StringBuilder result = new StringBuilder();
        this.appendFunctionNameWithModifiers(info, result, context);
        this.appendFunctionParameters(info, result);
        this.appendFunctionEnding(info, result);
        return result;
    }

    protected boolean isAvailableFunctionExpressionInClass() {
        return false;
    }

    protected void appendFunctionNameWithModifiers(JSFunctionSignatureInfo info, StringBuilder result, PsiElement context) {
        if (!(info.getScope() != JSFunctionSignatureInfo.Scope.CLASS || info.isFunctionExpression() && this.isAvailableFunctionExpressionInClass())) {
            result.append(info.getFunctionName());
            return;
        }
        if (info.isFunctionExpression()) {
            this.appendFunctionExpression(info, result);
        } else {
            if (info.getScope() != JSFunctionSignatureInfo.Scope.CLASS) {
                result.append("function ");
            }
            result.append(info.getFunctionName());
        }
    }

    private void appendFunctionExpression(JSFunctionSignatureInfo info, StringBuilder result) {
        boolean isObjectScope;
        boolean bl = isObjectScope = info.getScope() == JSFunctionSignatureInfo.Scope.JS_OBJECT;
        if (!isObjectScope) {
            if (info.getFunctionAnchor() != null) {
                result.append(info.getFunctionAnchor()).append(".");
            } else {
                result.append("var ");
            }
        }
        result.append(info.getFunctionName()).append(isObjectScope ? ":" : " = ").append("function ");
    }

    protected void appendFunctionParameters(JSFunctionSignatureInfo info, StringBuilder result) {
        result.append("(");
        result.append(StringUtil.join(info.getParameters(), couple -> this.getFunctionParameter((Couple<String>)couple), (String)","));
        result.append(")");
    }

    @NotNull
    protected String getFunctionParameter(Couple<String> parameterWithType) {
        String string = (String)parameterWithType.first;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureGenerator", "getFunctionParameter"));
        }
        return string;
    }

    protected void appendFunctionEnding(JSFunctionSignatureInfo info, StringBuilder result) {
    }
}

