/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.ui;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.ui.JSConsoleViewPanel;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.EmptyIcon;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceToolWindowManager
implements Disposable {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");
    public static final String WARNING = "warning";
    public static final String FIRST_PROJECT_RUN = "typescript.language.service.tool.window.force.activate";
    @NotNull
    protected final Project myProject;
    @Nullable
    private volatile NewErrorTreeViewPanel myCurrentErrorTreeViewPanel;
    private volatile NewErrorTreeViewPanel myProjectErrorTreeViewPanel;
    private volatile boolean myInitialized;
    @Nullable
    private ConsoleView myConsoleView;
    @Nullable
    private ContentImpl myConsoleContent;
    @Nullable
    private volatile ToolWindow myToolWindow;
    private String myHelpId;
    @Nullable
    private final LayeredIcon myIcon;
    @Nullable
    private final Icon myErrorIcon;
    @Nullable
    private AnAction[] myActions;
    @NotNull
    private final String myToolWindowName;
    @Nullable
    private volatile List<JSLanguageServiceAnnotationResult> myLastResult;

    public JSLanguageServiceToolWindowManager(@NotNull Project project, @NotNull String toolWindowName, @NotNull String helpId, @Nullable Icon icon, AnAction ... actions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "<init>"));
        }
        if (toolWindowName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowName", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "<init>"));
        }
        if (helpId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpId", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "<init>"));
        }
        this.myProject = project;
        this.myToolWindowName = toolWindowName;
        this.myHelpId = helpId;
        this.myActions = actions;
        this.myIcon = JSLanguageServiceToolWindowManager.createIcon(icon, false);
        this.myErrorIcon = JSLanguageServiceToolWindowManager.createIcon(icon, true);
    }

    private static LayeredIcon createIcon(@Nullable Icon rawIcon, boolean error) {
        if (rawIcon == null) {
            return null;
        }
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(rawIcon, 0);
        Icon errorMark = AllIcons.Nodes.ErrorMark;
        icon.setIcon(error ? errorMark : EmptyIcon.create((Icon)errorMark), 1, 5);
        return icon;
    }

    public synchronized void connectToProcessHandler(ProcessHandler handler) {
        this.cleanProjectErrorsPanel();
        this.init();
        NewErrorTreeViewPanel errorTreeViewPanel = this.myCurrentErrorTreeViewPanel;
        if (errorTreeViewPanel != null) {
            errorTreeViewPanel.getErrorViewStructure().clear();
        }
        LOGGER.debug("creating tool window");
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (this.myToolWindow != null);
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null) {
            this.myConsoleView = this.createConsole();
            this.myConsoleView.attachToProcess(handler);
            JSConsoleViewPanel panel = new JSConsoleViewPanel(this.myProject, this.myHelpId, null, this.myConsoleView, this.myActions);
            this.myConsoleContent = new ContentImpl((JComponent)panel, "Console", false);
            toolWindow.getContentManager().addContent((Content)this.myConsoleContent);
        }
    }

    @NotNull
    public String getToolWindowName() {
        String string = this.myToolWindowName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "getToolWindowName"));
        }
        return string;
    }

    @NotNull
    protected ConsoleViewImpl createConsole() {
        ConsoleViewImpl consoleViewImpl = new ConsoleViewImpl(this.myProject, GlobalSearchScope.allScope((Project)this.myProject), true, false);
        if (consoleViewImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "createConsole"));
        }
        return consoleViewImpl;
    }

    public synchronized void printToConsole(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "printToConsole"));
        }
        ConsoleView view = this.myConsoleView;
        if (view != null) {
            view.print(message, ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    public synchronized boolean isConnectedToProcessHandler() {
        return this.myConsoleView != null;
    }

    public void show() {
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null) {
            toolWindow.show(null);
        }
    }

    public synchronized void init() {
        if (!this.myInitialized || this.myToolWindow == null) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)this.myProject);
            ToolWindow toolWindow = manager.registerToolWindow(this.myToolWindowName, true, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject, true);
            toolWindow.setIcon((Icon)this.myIcon);
            this.myToolWindow = toolWindow;
            this.createProjectErrorsPanel();
            this.myInitialized = true;
            LOGGER.debug("initialized tool window");
        }
    }

    private ContentImpl createCurrentErrorContent(final ToolWindow toolWindow) {
        final Ref content = new Ref();
        JSLanguageServiceErrorTreeViewPanel errorTreeViewPanel = new JSLanguageServiceErrorTreeViewPanel(this.myProject, this.myHelpId, () -> {
            this.myLastResult = null;
        }, this.myActions){

            public void close() {
                toolWindow.hide(() -> {
                    JSLanguageServiceToolWindowManager.this.myLastResult = null;
                    toolWindow.setIcon((Icon)JSLanguageServiceToolWindowManager.this.myIcon);
                    ContentImpl contentImpl = (ContentImpl)content.get();
                    if (contentImpl != null) {
                        toolWindow.getContentManager().removeContent((Content)contentImpl, true);
                    }
                    ContentImpl newContentImpl = JSLanguageServiceToolWindowManager.this.createCurrentErrorContent(toolWindow);
                    toolWindow.getContentManager().setSelectedContent((Content)newContentImpl);
                });
            }
        };
        Disposer.register((Disposable)this.myProject, (Disposable)errorTreeViewPanel);
        content.set((Object)new ContentImpl((JComponent)((Object)errorTreeViewPanel), "Current Errors", false));
        toolWindow.getContentManager().addContent((Content)content.get(), 0);
        this.myCurrentErrorTreeViewPanel = errorTreeViewPanel;
        return (ContentImpl)content.get();
    }

    public void setName(String newName) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ToolWindow window = this.myToolWindow;
        if (window != null) {
            window.setStripeTitle(this.myToolWindowName + " " + newName);
        }
    }

    @Nullable
    private NewErrorTreeViewPanel createProjectErrorsPanel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel panel = this.myProjectErrorTreeViewPanel;
        if (panel != null) {
            return panel;
        }
        final ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            return null;
        }
        final Ref content = new Ref();
        JSLanguageServiceErrorTreeViewPanel errorTreeViewPanel = new JSLanguageServiceErrorTreeViewPanel(this.myProject, this.myHelpId, null, this.myActions){

            public void close() {
                NewErrorTreeViewPanel oldPanel = JSLanguageServiceToolWindowManager.this.myProjectErrorTreeViewPanel;
                JSLanguageServiceToolWindowManager.this.myProjectErrorTreeViewPanel = null;
                toolWindow.hide(() -> {
                    ContentImpl contentImpl = (ContentImpl)content.get();
                    if (contentImpl != null) {
                        toolWindow.getContentManager().removeContent((Content)contentImpl, true);
                    }
                    if (oldPanel != null) {
                        Disposer.dispose((Disposable)oldPanel);
                    }
                });
            }
        };
        Disposer.register((Disposable)this.myProject, (Disposable)errorTreeViewPanel);
        content.set((Object)new ContentImpl((JComponent)((Object)errorTreeViewPanel), "Project Errors", false));
        toolWindow.getContentManager().addContent((Content)content.get());
        this.myProjectErrorTreeViewPanel = errorTreeViewPanel;
        return errorTreeViewPanel;
    }

    public void disconnectFromProcessHandler() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ConsoleView console = this.myConsoleView;
        ContentImpl content = this.myConsoleContent;
        ToolWindow toolWindow = this.myToolWindow;
        if (console != null && content != null && toolWindow != null) {
            toolWindow.getContentManager().removeContent((Content)content, true);
            this.myConsoleView = null;
            this.myConsoleContent = null;
            Disposer.dispose((Disposable)console);
        }
    }

    public void logProjectErrors(@NotNull ImmutableList<JSLanguageServiceAnnotationResult> results, boolean setActive) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "logProjectErrors"));
        }
        NewErrorTreeViewPanel panel = this.createProjectErrorsPanel();
        if (panel == null) {
            return;
        }
        JSLanguageServiceToolWindowManager.logErrorsImpl(panel, results);
        ToolWindow window = this.myToolWindow;
        if (window == null) {
            return;
        }
        if (setActive) {
            this.setActivePanel(panel, window);
        }
    }

    private void setActivePanel(NewErrorTreeViewPanel panel, ToolWindow window) {
        for (Content content : window.getContentManager().getContents()) {
            if (content.getComponent() != panel) continue;
            window.getContentManager().setSelectedContent(content);
            break;
        }
        this.show();
    }

    public void logCurrentErrors(@NotNull List<JSLanguageServiceAnnotationResult> results, boolean setActive) {
        ArrayList list;
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager", "logCurrentErrors"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel errorTreeViewPanel = this.myCurrentErrorTreeViewPanel;
        ToolWindow toolWindow = this.myToolWindow;
        if (errorTreeViewPanel == null) {
            if (this.myInitialized && toolWindow != null) {
                ContentImpl content = this.createCurrentErrorContent(toolWindow);
                toolWindow.getContentManager().setSelectedContent((Content)content);
                if (!results.isEmpty()) {
                    this.show();
                }
                errorTreeViewPanel = this.myCurrentErrorTreeViewPanel;
            } else {
                return;
            }
        }
        if (this.myInitialized && errorTreeViewPanel != null && !(list = ContainerUtil.newArrayList(results)).equals(this.myLastResult)) {
            JSLanguageServiceToolWindowManager.logErrorsImpl(errorTreeViewPanel, list);
            this.myLastResult = list;
            if (toolWindow != null && this.myIcon != null) {
                Object newIcon;
                Icon oldIcon = toolWindow.getIcon();
                Object object = newIcon = list.isEmpty() ? this.myIcon : this.myErrorIcon;
                if (oldIcon != newIcon) {
                    toolWindow.setIcon((Icon)newIcon);
                }
            }
        }
        if (setActive) {
            this.setActivePanel(errorTreeViewPanel, toolWindow);
        }
    }

    private static void logErrorsImpl(NewErrorTreeViewPanel errorTreeViewPanel, List<JSLanguageServiceAnnotationResult> list) {
        errorTreeViewPanel.getErrorViewStructure().clear();
        for (JSLanguageServiceAnnotationResult compilerResult : list) {
            String path = compilerResult.getFileAbsoluteSystemDependPath();
            VirtualFile file = null;
            if (path != null) {
                file = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
            }
            int category = WARNING.equalsIgnoreCase(compilerResult.getCategory()) ? 5 : 4;
            errorTreeViewPanel.addMessage(category, new String[]{compilerResult.getErrorText()}, file, compilerResult.getLine(), compilerResult.getColumn(), null);
        }
        errorTreeViewPanel.updateTree();
    }

    public void dispose() {
        this.cleanPanel();
    }

    public void cleanProjectErrorsPanel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel panel = this.myProjectErrorTreeViewPanel;
        if (panel != null) {
            panel.getErrorViewStructure().clear();
            panel.updateTree();
        }
    }

    public synchronized void cleanPanel() {
        NewErrorTreeViewPanel allErrorTreeViewPanel;
        ConsoleView view;
        NewErrorTreeViewPanel panel;
        if (this.myProject.isDefault()) {
            return;
        }
        if (!this.myProject.isDisposed()) {
            ToolWindowManager.getInstance((Project)this.myProject).unregisterToolWindow(this.myToolWindowName);
        }
        if ((panel = this.myCurrentErrorTreeViewPanel) != null) {
            Disposer.dispose((Disposable)panel);
        }
        if ((view = this.myConsoleView) != null) {
            Disposer.dispose((Disposable)view);
        }
        if ((allErrorTreeViewPanel = this.myProjectErrorTreeViewPanel) != null) {
            Disposer.dispose((Disposable)allErrorTreeViewPanel);
        }
        this.myConsoleView = null;
        this.myProjectErrorTreeViewPanel = null;
        this.myToolWindow = null;
        this.myConsoleContent = null;
        this.myCurrentErrorTreeViewPanel = null;
        this.myLastResult = null;
    }
}

