/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowSettings;
import com.intellij.lang.javascript.flow.FlowSettingsManager;
import com.intellij.lang.javascript.flow.protocol.FlowJSStandardOutputProtocol;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.javascript.settings.JSRootConfigurationPanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRootConfigurable
implements SearchableConfigurable {
    public static final String ID = "Settings.JavaScript";
    private JSRootConfigurationPanel myMainPanel;
    private final JSRootConfiguration myRootConfiguration;
    private final Project myProject;

    public JSRootConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/settings/JSRootConfigurable", "<init>"));
        }
        this.myRootConfiguration = JSRootConfiguration.getInstance(project);
        this.myProject = project;
    }

    @Nls
    public String getDisplayName() {
        return JSBundle.message((String)"settings.javascript.root.configurable.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return this.getId();
    }

    public JComponent createComponent() {
        return this.getMainPanel();
    }

    public boolean isModified() {
        JSLanguageLevel storedLanguageLevel = this.myRootConfiguration.getStoredLanguageLevel();
        JSLanguageLevel panelLanguageLevel = this.myMainPanel.getLanguageLevel();
        if (storedLanguageLevel != null && storedLanguageLevel == JSLanguageLevel.FLOW) {
            FlowSettings storedSettings;
            FlowSettings viewSettings = this.myMainPanel.getFlowSettings();
            return !viewSettings.equals(storedSettings = FlowSettingsManager.getInstance(this.myProject).getFlowSettings()) || !panelLanguageLevel.equals((Object)storedLanguageLevel) || this.myRootConfiguration.getPreferStrict() != this.myMainPanel.isPreferStrict() || this.myRootConfiguration.isOnlyTypeBasedCompletion() != this.myMainPanel.getOnlyTypeBasedCompletion();
        }
        return storedLanguageLevel == null && !panelLanguageLevel.equals((Object)JSLanguageLevel.DEFAULT) || storedLanguageLevel != null && !panelLanguageLevel.equals((Object)storedLanguageLevel) || this.myRootConfiguration.getPreferStrict() != this.myMainPanel.isPreferStrict() || this.myRootConfiguration.isOnlyTypeBasedCompletion() != this.myMainPanel.getOnlyTypeBasedCompletion();
    }

    public void apply() throws ConfigurationException {
        JSLanguageLevel newLanguageLevel = this.myMainPanel.getLanguageLevel();
        this.myRootConfiguration.storeLanguageLevelAndUpdateCaches(newLanguageLevel);
        this.myRootConfiguration.storePreferStrict(this.myMainPanel.isPreferStrict());
        this.myRootConfiguration.storeOnlyTypeBasedCompletion(this.myMainPanel.getOnlyTypeBasedCompletion());
        if (newLanguageLevel == JSLanguageLevel.FLOW) {
            FlowSettings settings = this.myMainPanel.getFlowSettings();
            if (!JSRootConfigurable.isFlowServerAvailable(settings.getFlowExecutablePath(), this.myProject)) {
                throw new ConfigurationException(JSBundle.message((String)"js.flow.enable.flow.service.error", (Object[])new Object[0]));
            }
            if (settings.getFlowExecutablePath().isEmpty() && settings.getFlowResolveEnable()) {
                throw new ConfigurationException(JSBundle.message((String)"js.flow.enable.flow.resolve.error.text", (Object[])new Object[0]));
            }
            FlowSettingsManager.getInstance(this.myProject).setFlowSettings(settings);
            FlowJSServerService service = FlowJSServerService.getService(this.myProject);
            if (service != null) {
                service.restartService();
            }
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    public static boolean isFlowServerAvailable(@NotNull String path, @NotNull Project project) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/settings/JSRootConfigurable", "isFlowServerAvailable"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/settings/JSRootConfigurable", "isFlowServerAvailable"));
        }
        if (path.isEmpty()) {
            return true;
        }
        GeneralCommandLine line = new GeneralCommandLine();
        line.setExePath(path);
        line.addParameter("version");
        line.addParameter("--json");
        line.setWorkDirectory(project.getBasePath());
        final Ref answer = new Ref();
        try {
            OSProcessHandler handler = new OSProcessHandler(line);
            final StringBuilder resultJson = new StringBuilder();
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        String text = event.getText();
                        resultJson.append(text);
                        if (FlowJSStandardOutputProtocol.verifyJson(resultJson.toString())) {
                            answer.set((Object)Boolean.TRUE);
                        } else {
                            answer.set((Object)Boolean.FALSE);
                        }
                    } else if (outputType == ProcessOutputTypes.STDERR) {
                        answer.set((Object)Boolean.FALSE);
                    }
                }
            });
            handler.startNotify();
            if (handler.waitFor()) {
                return (Boolean)answer.get();
            }
            return false;
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    public void reset() {
        JSLanguageLevel storedLanguageLevel = this.myRootConfiguration.getStoredLanguageLevel();
        if (storedLanguageLevel == null) {
            storedLanguageLevel = JSLanguageLevel.DEFAULT;
        }
        this.myMainPanel.setLanguageLevel(storedLanguageLevel);
        boolean preferStrict = this.myRootConfiguration.getPreferStrict();
        this.myMainPanel.setPreferStrict(preferStrict);
        boolean simplerCompletion = this.myRootConfiguration.isOnlyTypeBasedCompletion();
        this.myMainPanel.setOnlyTypeBasedCompletion(simplerCompletion);
        FlowSettings settings = FlowSettingsManager.getInstance(this.myProject).getFlowSettings();
        this.myMainPanel.setFlowSettings(settings);
    }

    public void disposeUIResources() {
        this.myMainPanel = null;
    }

    @NotNull
    public JPanel getMainPanel() {
        if (this.myMainPanel == null) {
            this.myMainPanel = new JSRootConfigurationPanel(this.myProject);
        }
        JPanel jPanel = this.myMainPanel.getPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/settings/JSRootConfigurable", "getMainPanel"));
        }
        return jPanel;
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/settings/JSRootConfigurable", "getId"));
        }
        return ID;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return () -> {
            if (option != null && option.toLowerCase().contains("flow") && this.myMainPanel.getPanel().isShowing()) {
                this.myMainPanel.myJSLanguageVersion.showPopup();
            }
        };
    }
}

