/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePanel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSClassChooserDialog
extends DialogWrapper {
    private final Project myProject;
    private final GlobalSearchScope mySearchScope;
    private Tree myTree;
    private JSClass myInitialClass;
    private ProjectTreeBuilder myBuilder;
    private ChooseByNamePanel myGotoByNamePanel;
    private TabbedPaneWrapper myTabbedPane;
    private JSClass mySelectedClass;
    private boolean myResult;
    private final Condition<JSClass> myClassFilter;

    public JSClassChooserDialog(@NotNull Project project, @NotNull String title, @NotNull GlobalSearchScope scope, @Nullable JSClass initialClass, @Nullable Condition<JSClass> classFilter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/ui/JSClassChooserDialog", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/lang/javascript/ui/JSClassChooserDialog", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/ui/JSClassChooserDialog", "<init>"));
        }
        super(project, true);
        this.myProject = project;
        this.mySearchScope = scope;
        this.myInitialClass = initialClass;
        this.myClassFilter = classFilter;
        this.setTitle(title);
        this.init();
        if (this.myInitialClass != null) {
            this.selectClass(this.myInitialClass);
        }
        this.handleSelectionChanged();
    }

    public void selectClass(@NotNull JSClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/ui/JSClassChooserDialog", "selectClass"));
        }
        this.selectElementInTree((PsiElement)clazz);
    }

    public void selectFile(@Nullable PsiFileSystemItem fileSystemItem) {
        if (fileSystemItem != null) {
            this.selectElementInTree((PsiElement)fileSystemItem);
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGotoByNamePanel.getPreferredFocusedComponent();
    }

    public JSClass getSelectedClass() {
        return this.mySelectedClass;
    }

    public boolean showDialog() {
        this.myResult = false;
        this.show();
        return this.myResult;
    }

    public void dispose() {
        if (this.myBuilder != null) {
            Disposer.dispose((Disposable)this.myBuilder);
            this.myBuilder = null;
        }
        super.dispose();
    }

    @Nullable
    private JSClass calcSelectedClass() {
        if (this.myTabbedPane.getSelectedIndex() == 0) {
            return (JSClass)this.myGotoByNamePanel.getChosenElement();
        }
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = node.getUserObject();
        if (userObject instanceof PsiFileNode) {
            PsiFile file = (PsiFile)((PsiFileNode)userObject).getValue();
            if (file instanceof JSFile) {
                return JSPsiImplUtils.findClass((JSFile)file);
            }
            if (file instanceof XmlFile) {
                return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)file);
            }
        }
        return null;
    }

    private JSClass getContext() {
        return this.myInitialClass;
    }

    private ModalityState getModalityState() {
        return ModalityState.stateForComponent((Component)this.getRootPane());
    }

    private void handleSelectionChanged() {
        JSClass selection = this.calcSelectedClass();
        this.setOKActionEnabled(selection != null && this.isAccepted(selection));
    }

    private boolean isAccepted(@NotNull JSClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/ui/JSClassChooserDialog", "isAccepted"));
        }
        return !ActionScriptResolveUtil.hasExcludeClassMetadata((JSAttributeListOwner)clazz) && PsiSearchScopeUtil.isInScope((GlobalSearchScope)this.mySearchScope, (PsiElement)clazz) && (this.myClassFilter == null || this.myClassFilter.value((Object)clazz));
    }

    private void selectElementInTree(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ui/JSClassChooserDialog", "selectElementInTree"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ui/JSClassChooserDialog", "lambda$selectElementInTree$0"));
            }
            if (this.myBuilder == null) {
                return;
            }
            VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            this.myBuilder.select((Object)element.getContainingFile(), vFile, false);
        }, this.getModalityState());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)model);
        AbstractProjectTreeStructure treeStructure = new AbstractProjectTreeStructure(this.myProject){

            public boolean isFlattenPackages() {
                return false;
            }

            public boolean isShowMembers() {
                return false;
            }

            public boolean isHideEmptyMiddlePackages() {
                return true;
            }

            public boolean isAbbreviatePackageNames() {
                return false;
            }

            public boolean isShowLibraryContents() {
                return false;
            }

            public boolean isShowModules() {
                return false;
            }
        };
        this.myBuilder = new ProjectTreeBuilder(this.myProject, (JTree)this.myTree, model, (Comparator)AlphaComparator.INSTANCE, (ProjectAbstractTreeStructureBase)treeStructure);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.expandRow(0);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)500, (int)300));
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    JSClassChooserDialog.this.doOKAction();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                JSClass jsClass;
                TreePath path = JSClassChooserDialog.this.myTree.getPathForLocation(e.getX(), e.getY());
                if (path != null && JSClassChooserDialog.this.myTree.isPathSelected(path) && (jsClass = JSClassChooserDialog.this.calcSelectedClass()) != null && JSClassChooserDialog.this.isAccepted(jsClass)) {
                    JSClassChooserDialog.this.doOKAction();
                    return true;
                }
                return false;
            }
        }.installOn((Component)this.myTree);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                JSClassChooserDialog.this.handleSelectionChanged();
            }
        });
        new TreeSpeedSearch((JTree)this.myTree);
        JPanel dummyPanel = new JPanel(new BorderLayout());
        String name = null;
        this.myGotoByNamePanel = new MyChooseByNamePanel(name, dummyPanel);
        this.myTabbedPane = new TabbedPaneWrapper(this.getDisposable());
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.search.by.name", (Object[])new Object[0]), (JComponent)dummyPanel);
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.project", (Object[])new Object[0]), (JComponent)scrollPane);
        this.myGotoByNamePanel.invoke((ChooseByNamePopupComponent.Callback)new MyCallback(), this.getModalityState(), false);
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSClassChooserDialog.this.handleSelectionChanged();
            }
        });
        return this.myTabbedPane.getComponent();
    }

    protected ChooseByNameModel createChooseByNameModel() {
        return new MyGotoClassModel(this.myProject);
    }

    protected void doOKAction() {
        this.myResult = true;
        this.mySelectedClass = this.calcSelectedClass();
        if (this.mySelectedClass == null) {
            return;
        }
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.util.TreeClassChooserDialog";
    }

    private class MyGotoClassModel
    extends GotoClassModel2 {
        public MyGotoClassModel(Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/ui/JSClassChooserDialog$MyGotoClassModel", "<init>"));
            }
            super(project);
        }

        @NotNull
        public Object[] getElementsByName(String name, FindSymbolParameters parameters, @NotNull ProgressIndicator canceled) {
            if (canceled == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canceled", "com/intellij/lang/javascript/ui/JSClassChooserDialog$MyGotoClassModel", "getElementsByName"));
            }
            Collection<JSQualifiedNamedElement> elements = JSResolveUtil.findElementsByName(name, this.myProject, parameters.getSearchScope(), false);
            ArrayList<JSClass> list = new ArrayList<JSClass>();
            for (JSQualifiedNamedElement element : elements) {
                if (!(element instanceof JSClass) || !JSClassChooserDialog.this.isAccepted((JSClass)element)) continue;
                list.add((JSClass)element);
            }
            Object[] objectArray = list.toArray(new JSClass[list.size()]);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/JSClassChooserDialog$MyGotoClassModel", "getElementsByName"));
            }
            return objectArray;
        }

        @Nullable
        public String getPromptText() {
            return null;
        }
    }

    private class MyChooseByNamePanel
    extends ChooseByNamePanel {
        private final JPanel dummyPanel;

        public MyChooseByNamePanel(String name, JPanel dummyPanel) {
            super(JSClassChooserDialog.this.myProject, JSClassChooserDialog.this.createChooseByNameModel(), name, JSClassChooserDialog.this.mySearchScope.isSearchInLibraries(), (PsiElement)JSClassChooserDialog.this.getContext());
            this.dummyPanel = dummyPanel;
        }

        protected void showTextFieldPanel() {
        }

        protected void close(boolean isOk) {
            super.close(isOk);
            if (isOk) {
                JSClassChooserDialog.this.doOKAction();
            } else {
                JSClassChooserDialog.this.doCancelAction();
            }
        }

        protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
            super.initUI(callback, modalityState, allowMultipleSelection);
            this.dummyPanel.add((Component)JSClassChooserDialog.this.myGotoByNamePanel.getPanel(), "Center");
            IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)JSClassChooserDialog.this.myGotoByNamePanel.getPanel()).requestFocus();
        }

        protected void showList() {
            super.showList();
            if (JSClassChooserDialog.this.myInitialClass != null && this.myList.getModel().getSize() > 0) {
                this.myList.setSelectedValue(JSClassChooserDialog.this.myInitialClass, true);
                JSClassChooserDialog.this.myInitialClass = null;
            }
        }

        protected void chosenElementMightChange() {
            JSClassChooserDialog.this.handleSelectionChanged();
        }
    }

    private class MyCallback
    extends ChooseByNamePopupComponent.Callback {
        private MyCallback() {
        }

        public void elementChosen(Object element) {
            JSClassChooserDialog.this.mySelectedClass = (JSClass)element;
            JSClassChooserDialog.this.close(0);
        }
    }
}

