/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6NamespaceImportExport;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStringLiteralLexer;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSAccessibilityCheckInspection;
import com.intellij.lang.javascript.inspections.JSCheckFunctionSignaturesInspection;
import com.intellij.lang.javascript.inspections.JSFileReferencesInspection;
import com.intellij.lang.javascript.inspections.JSUnresolvedFunctionInspection;
import com.intellij.lang.javascript.inspections.JSUnresolvedVariableInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayComprehension;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSGeneratorExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLetStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSStatementWithLabelReference;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.AnalysisUtils;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.ui.JSFormatUtil;
import com.intellij.lang.javascript.validation.DuplicatesCheckUtil;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.javascript.validation.fixes.ChangeLanguageLevelFix;
import com.intellij.lang.javascript.validation.fixes.ReplacePsiElementFix;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSAnnotatingVisitor
extends JSElementVisitor {
    private static final String OCTAL_SEQUENCE_START = "\\0";
    private static final String EVAL_FUNCTION_NAME = "eval";
    public static final String VOID_TYPE_NAME = "void";
    @NotNull
    protected final AnnotationHolder myHolder;
    @NotNull
    protected final JSAnnotatorProblemReporter myProblemReporter;
    @NotNull
    protected final JSHighlighter myHighlighter;
    @NotNull
    protected final JSTypeChecker<Annotation> myTypeChecker;
    @NotNull
    protected final JSFunctionSignatureChecker myFunctionSignatureChecker;
    public static final Condition<PsiElement> NOT_TYPESCRIPT_EXPORT_CONDITION = element -> !(element instanceof TypeScriptExportAssignment);

    public JSAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "<init>"));
        }
        this.myHolder = holder;
        this.myHighlighter = this.getHighlighter(psiElement);
        assert (this.myHighlighter != null);
        this.myProblemReporter = this.createProblemReporter(psiElement);
        this.myTypeChecker = this.createTypeChecker(psiElement);
        this.myFunctionSignatureChecker = this.createFunctionSignatureChecker(psiElement);
    }

    protected JSHighlighter getHighlighter(PsiElement psiElement) {
        Language dialect = DialectDetector.languageOfElement(psiElement);
        return dialect instanceof JSLanguageDialect ? (JSHighlighter)SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, null, null) : new JSHighlighter(JavascriptLanguage.DIALECT_OPTION_HOLDER);
    }

    @NotNull
    protected JSAnnotatorProblemReporter createProblemReporter(PsiElement context) {
        JSAnnotatorProblemReporter jSAnnotatorProblemReporter = new JSAnnotatorProblemReporter(this.myHolder);
        if (jSAnnotatorProblemReporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "createProblemReporter"));
        }
        return jSAnnotatorProblemReporter;
    }

    @NotNull
    protected JSTypeChecker<Annotation> createTypeChecker(PsiElement context) {
        JSTypeChecker<Annotation> jSTypeChecker = new JSTypeChecker<Annotation>(){

            @Override
            public Annotation registerProblem(PsiElement place, String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
                return JSAnnotatingVisitor.this.myProblemReporter.registerProblem(place, message, highlightType, this.getValidateTypesInspectionId(), fixes);
            }
        };
        if (jSTypeChecker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "createTypeChecker"));
        }
        return jSTypeChecker;
    }

    @NotNull
    protected JSFunctionSignatureChecker createFunctionSignatureChecker(PsiElement context) {
        JSFunctionSignatureChecker jSFunctionSignatureChecker = new JSFunctionSignatureChecker(this.myTypeChecker){

            @Override
            protected void registerProblem(JSCallExpression callExpression, String message, LocalQuickFix ... fixes) {
                PsiElement place = ValidateTypesUtil.getPlaceForSignatureProblem(callExpression, callExpression.getArgumentList());
                JSAnnotatingVisitor.this.myProblemReporter.registerProblem(place, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, JSCheckFunctionSignaturesInspection.SHORT_NAME, fixes);
            }
        };
        if (jSFunctionSignatureChecker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "createFunctionSignatureChecker"));
        }
        return jSFunctionSignatureChecker;
    }

    public void visitElement(PsiElement element) {
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(element.getNode().getElementType())) {
            JSNamedElement namedElement = JSPsiImplUtils.findElementFromNameIdentifier(element);
            if (namedElement instanceof JSParameter) {
                JSSemanticHighlightingUtil.highlight((JSVariable)((JSParameter)namedElement), this.myHighlighter, this.myHolder);
            } else if (namedElement instanceof JSVariable) {
                JSSemanticHighlightingUtil.highlight((JSVariable)namedElement, this.myHighlighter, this.myHolder);
            } else if (namedElement instanceof JSProperty) {
                JSSemanticHighlightingUtil.highlight((JSProperty)namedElement, this.myHighlighter, this.myHolder);
            } else if (namedElement instanceof JSFunction) {
                IElementType elementType = namedElement.getNode().getElementType();
                if (JSElementTypes.FUNCTION_DECLARATIONS.contains(elementType)) {
                    this.checkFunctionDeclaration((JSFunction)namedElement);
                }
            } else if (namedElement instanceof TypeScriptModule) {
                JSSemanticHighlightingUtil.highlight((TypeScriptModule)namedElement, this.myHighlighter, this.myHolder);
            }
        }
        super.visitElement(element);
    }

    public void visitJSLiteralExpression(JSLiteralExpression node) {
        block11: {
            block9: {
                block12: {
                    block10: {
                        this.checkReferences((PsiElement)node);
                        if (!node.isOctalLiteral()) break block9;
                        if (!DialectDetector.isES6((PsiElement)node)) break block10;
                        String nodeText = node.getText();
                        if (!StringUtil.isEmpty((String)nodeText) && !JSLiteralExpressionImpl.textHasOctalES6Prefix(nodeText)) {
                            this.myProblemReporter.registerGenericError((PsiElement)node, JSBundle.message((String)"javascript.octal.literals.are.not.allowed.es6.message", (Object[])new Object[0]), new IntentionAction[0]);
                        }
                        break block11;
                    }
                    if (!DialectDetector.isJavaScript((PsiElement)node)) break block11;
                    String nodeText = node.getText();
                    if (StringUtil.isEmpty((String)nodeText) || !JSLiteralExpressionImpl.textHasOctalES6Prefix(nodeText)) break block12;
                    this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.BINARY_AND_OCTAL_LITERALS);
                    break block11;
                }
                if (!JSResolveUtil.isEcmaScript5((PsiElement)node)) break block11;
                this.myProblemReporter.registerGenericError((PsiElement)node, JSBundle.message((String)"javascript.octal.literals.are.not.allowed.in.strict.mode", (Object[])new Object[0]), new IntentionAction[0]);
                break block11;
            }
            if (node.isBinaryLiteral()) {
                this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.BINARY_AND_OCTAL_LITERALS);
            } else if (node.isQuotedLiteral()) {
                IElementType tokenType;
                boolean checkUnicodeEscapesWithBraces;
                boolean checkOctalLiteral = node.textContains('0') && JSResolveUtil.isEcmaScript5((PsiElement)node);
                boolean allowsUnicodeEscapesWithBraces = DialectDetector.isJavaScript((PsiElement)node);
                boolean bl = checkUnicodeEscapesWithBraces = allowsUnicodeEscapesWithBraces && node.textContains('{');
                if (!checkOctalLiteral && !checkUnicodeEscapesWithBraces) {
                    return;
                }
                String text = node.getText();
                if (!(checkOctalLiteral &= text.contains(OCTAL_SEQUENCE_START)) && !(checkUnicodeEscapesWithBraces &= text.contains("\\u{"))) {
                    return;
                }
                JSStringLiteralLexer literalLexer = new JSStringLiteralLexer(text.charAt(0), node.getNode().getFirstChildNode().getElementType(), "/v", true, allowsUnicodeEscapesWithBraces);
                literalLexer.start(text);
                int literalStart = node.getTextOffset();
                while ((tokenType = literalLexer.getTokenType()) != null) {
                    int end;
                    int start;
                    if (checkUnicodeEscapesWithBraces && tokenType == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN && literalLexer.getTokenText().startsWith("\\u{")) {
                        TextRange errorRange = new TextRange(literalStart + literalLexer.getTokenStart(), literalStart + literalLexer.getTokenEnd());
                        this.checkElementInCurrentLanguageLevel((PsiElement)node, errorRange, JSLanguageFeature.UNICODE_ESCAPES_WITH_BRACES);
                    }
                    if (checkOctalLiteral && (tokenType == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN || tokenType == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN) && CharArrayUtil.indexOf((CharSequence)text, (CharSequence)OCTAL_SEQUENCE_START, (int)(start = literalLexer.getTokenStart()), (int)(end = literalLexer.getTokenEnd())) == start && end - start > 2) {
                        TextRange errorRange = new TextRange(literalStart + start, literalStart + end);
                        this.myProblemReporter.registerProblem(null, errorRange, JSBundle.message((String)"javascript.octal.sequences.are.not.allowed.message", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR, null, null, IntentionAction.EMPTY_ARRAY);
                    }
                    literalLexer.advance();
                }
            }
        }
    }

    @Nullable
    public ProblemHighlightType getUnresolvedReferenceHighlightType(@NotNull JSReferenceExpression node) {
        JSType type;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "getUnresolvedReferenceHighlightType"));
        }
        JSExpression qualifier = node.getQualifier();
        if (qualifier == null && node.getParent() instanceof JSDefinitionExpression && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
            return ProblemHighlightType.ERROR;
        }
        if (qualifier != null && (type = JSResolveUtil.getExpressionJSType(qualifier)) != null && JSTypeUtils.isMapType(type)) {
            return null;
        }
        return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
    }

    protected ProblemHighlightType getHighlightTypeForTypeOrSignatureProblem(@NotNull PsiElement node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "getHighlightTypeForTypeOrSignatureProblem"));
        }
        return ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem(node);
    }

    protected boolean checkReferences(PsiElement element) {
        return this.checkReferences(element, null, null);
    }

    protected boolean checkReferences(PsiElement element, @Nullable String inspectionId, @Nullable ProblemHighlightType problemHighlightType) {
        if (element instanceof JSXmlLiteralExpressionImpl) {
            return true;
        }
        boolean ok = true;
        for (PsiReference ref : element.getReferences()) {
            if (ref.isSoft() || ref instanceof FileReference && JSFileReferencesInspection.acceptsReference((FileReference)ref)) continue;
            if (ref instanceof PsiPolyVariantReference) {
                ResolveResult result;
                ResolveResult[] results = ((PsiPolyVariantReference)ref).multiResolve(false);
                if (results.length == 0) {
                    ok = false;
                    this.registerProblemForReference(ref, inspectionId, null, problemHighlightType);
                } else if (results.length == 1 && !(result = results[0]).isValidResult()) {
                    String key;
                    ok = false;
                    String message = null;
                    if (result instanceof JSResolveResult && (key = ((JSResolveResult)result).getResolveProblemKey()) != null) {
                        message = JSBundle.message((String)key, (Object[])new Object[0]);
                    }
                    this.registerProblemForReference(ref, inspectionId, message, problemHighlightType);
                }
            } else if (ref.resolve() == null) {
                ok = false;
                this.registerProblemForReference(ref, inspectionId, null, problemHighlightType);
            }
            if (DialectDetector.isTypeScript(element) && !ok) break;
        }
        return ok;
    }

    protected void registerProblemForReference(@NotNull PsiReference ref, @Nullable String inspectionId, @Nullable String unresolvedMessage, @Nullable ProblemHighlightType problemHighlightType) {
        String message;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "registerProblemForReference"));
        }
        TextRange range = JSAnnotatingVisitor.calcRangeForReferences(ref);
        String string = message = unresolvedMessage != null ? unresolvedMessage : XmlHighlightVisitor.getErrorDescription((PsiReference)ref);
        if (problemHighlightType == null && ref instanceof HighlightSeverityHolder) {
            problemHighlightType = HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)((HighlightSeverityHolder)ref).getUnresolvedReferenceSeverity());
        }
        if (inspectionId != null) {
            LocalQuickFix[] fixes = this.getQuickFixesForReferenceProblem(ref, message);
            this.myProblemReporter.registerProblem(ref.getElement(), range, message, problemHighlightType, inspectionId, fixes, IntentionAction.EMPTY_ARRAY);
            return;
        }
        if (problemHighlightType == null) {
            problemHighlightType = ProblemHighlightType.ERROR;
        }
        LocalQuickFix[] fixes = this.getQuickFixesForReferenceProblem(ref, message);
        this.myProblemReporter.registerProblem(ref.getElement(), range, message, problemHighlightType, null, fixes, IntentionAction.EMPTY_ARRAY);
    }

    @Nullable
    protected LocalQuickFix[] getQuickFixesForReferenceProblem(@NotNull PsiReference ref, String message) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "getQuickFixesForReferenceProblem"));
        }
        if (ref instanceof LocalQuickFixProvider) {
            return ((LocalQuickFixProvider)ref).getQuickFixes();
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    protected static TextRange calcRangeForReferences(PsiReference ref) {
        TextRange elementRange = ref.getElement().getTextRange();
        TextRange textRange = ref.getRangeInElement();
        return new TextRange(elementRange.getStartOffset() + textRange.getStartOffset(), elementRange.getStartOffset() + textRange.getEndOffset());
    }

    public void visitJSCallExpression(JSCallExpression node) {
        PsiElement arrayInitializingType;
        JSExpression methodExpression = node.getMethodExpression();
        boolean inNewExpression = node instanceof JSNewExpression;
        if (methodExpression instanceof JSParenthesizedExpression) {
            methodExpression = JSUtils.unparenthesize(methodExpression);
        }
        if (methodExpression instanceof JSLiteralExpression && !(methodExpression instanceof JSStringTemplateExpression)) {
            this.myProblemReporter.registerGenericError((PsiElement)methodExpression, JSBundle.message((String)"javascript.parser.message.expected.function.name", (Object[])new Object[0]), new IntentionAction[0]);
        } else if (methodExpression instanceof JSReferenceExpression) {
            PsiElement element;
            this.checkCallReferences(node, (JSReferenceExpression)methodExpression);
            JSReferenceExpression referenceExpression = (JSReferenceExpression)methodExpression;
            ResolveResult[] resolveResults = referenceExpression.multiResolve(false);
            boolean hasValidResolveResult = false;
            boolean hasCallableElement = false;
            for (ResolveResult r : resolveResults) {
                JSType jsType;
                if (!r.isValidResult()) continue;
                hasValidResolveResult = true;
                PsiElement element2 = r.getElement();
                if (!this.processMethodExpressionResolveResult(node, referenceExpression, element2, jsType = JSTypeUtils.getTypeOfElement(element2))) {
                    return;
                }
                if (jsType != null && jsType.getSource().isExplicitlyDeclared() && !this.myFunctionSignatureChecker.isCallableType(inNewExpression, jsType) && (element2 == null || JSPsiImplUtils.calculatePossibleFunction(element2) == null)) continue;
                hasCallableElement = true;
                break;
            }
            if (hasValidResolveResult && !hasCallableElement) {
                PsiElement function;
                boolean isProperty;
                LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                JSArgumentList argumentList = node.getArgumentList();
                boolean bl = isProperty = resolveResults.length == 1 && (function = resolveResults[0].getElement()) instanceof JSFunction && ((JSFunction)function).isGetProperty();
                if (argumentList != null && isProperty) {
                    fixes = new LocalQuickFix[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.term.does.not.evaluate.to.function2.fix", argumentList.getNode())};
                }
                this.myTypeChecker.registerProblem(referenceExpression.getReferenceNameElement(), JSBundle.message((String)(isProperty ? "javascript.term.does.not.evaluate.to.function2" : "javascript.term.does.not.evaluate.to.function"), (Object[])new Object[0]), this.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node), fixes);
                return;
            }
            if (resolveResults.length == 1 && hasValidResolveResult && (element = resolveResults[0].getElement()) != null) {
                this.myFunctionSignatureChecker.checkFunction(node, element);
            }
        } else if (methodExpression instanceof JSNewExpression) {
            this.checkNewExpressionInsideCallReferences(methodExpression);
        } else if (methodExpression instanceof JSSuperExpression) {
            PsiElement element;
            JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class);
            if (fun == null || !fun.isConstructor()) {
                String message = JSBundle.message((String)"javascript.validation.message.super.constructor.call.should.be.in.constructor", (Object[])new Object[0]);
                this.myProblemReporter.registerGenericError((PsiElement)node, message, new IntentionAction[0]);
                return;
            }
            PsiReference psiReference = methodExpression.getReference();
            PsiElement psiElement = element = psiReference != null ? psiReference.resolve() : null;
            if (element != null) {
                this.myFunctionSignatureChecker.checkFunction(node, element);
            }
        } else if (methodExpression instanceof JSFunctionExpression) {
            this.myFunctionSignatureChecker.checkFunction(node, (PsiElement)methodExpression);
        } else if (methodExpression instanceof JSArrayLiteralExpression && inNewExpression && (arrayInitializingType = ((JSNewExpression)node).getArrayInitializingType()) != null) {
            String typeName = JSImportHandlingUtil.resolveTypeName(arrayInitializingType.getText(), (PsiElement)node);
            for (JSExpression expr : ((JSArrayLiteralExpression)methodExpression).getExpressions()) {
                if (expr == null) continue;
                this.myTypeChecker.checkExpressionIsAssignableToType(expr, typeName, "javascript.vector.literal.element.type.mismatch", null);
            }
        }
    }

    protected boolean processMethodExpressionResolveResult(JSCallExpression callExpression, JSReferenceExpression methodExpression, PsiElement resolveResult, JSType type) {
        return true;
    }

    private void checkNewExpressionInsideCallReferences(JSExpression methodExpression) {
        PsiElement elt;
        ResolveResult[] results;
        JSExpression methodExpr = ((JSNewExpression)methodExpression).getMethodExpression();
        if (methodExpr instanceof JSReferenceExpression && (results = ((JSReferenceExpression)methodExpr).multiResolve(false)).length > 0 && ((elt = results[0].getElement()) instanceof JSFunction && ((JSFunction)elt).isConstructor() || elt instanceof JSClass)) {
            this.reportUnresolvedFunctionError((PsiElement)methodExpression, this.getUnresolvedReferenceHighlightType((JSReferenceExpression)methodExpr), JSBundle.message((String)"javascript.term.does.not.evaluate.to.function", (Object[])new Object[0]), null);
        }
    }

    protected void checkCallReferences(JSCallExpression node, JSReferenceExpression referenceExpression) {
        ResolveResult[] resolveResults = referenceExpression.multiResolve(false);
        boolean noCompleteResolve = true;
        boolean inNewExpression = node instanceof JSNewExpression;
        for (ResolveResult r : resolveResults) {
            if (!r.isValidResult()) continue;
            noCompleteResolve = false;
            if (this.processExpressionResolveResult((JSExpression)referenceExpression, r.getElement())) break;
        }
        if (resolveResults.length == 0 || noCompleteResolve) {
            boolean canCreateFromUsage;
            JSExpression qualifier = referenceExpression.getQualifier();
            LinkedList<LocalQuickFix> quickFixes = new LinkedList<LocalQuickFix>();
            String refName = referenceExpression.getReferencedName();
            DialectOptionHolder dialect = DialectDetector.dialectOfFile(node.getContainingFile());
            boolean simpleJs = dialect != null && dialect.isJavaScript();
            ProblemHighlightType unresolvedRefHighlightType = this.getUnresolvedReferenceHighlightType(referenceExpression);
            boolean reportProblem = unresolvedRefHighlightType != null && (dialect == null || !dialect.isECMA4 || unresolvedRefHighlightType != ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            boolean bl = canCreateFromUsage = JSAnnotatingVisitor.canHaveCreateFromUsage(qualifier) && (simpleJs || JSAnnotatingVisitor.findInsufficientVisibilityResult(resolveResults) == null);
            if (reportProblem && canCreateFromUsage && referenceExpression.getParent() instanceof JSCallExpression) {
                this.addCreateFromUsageFixesForCall(node, referenceExpression, resolveResults, quickFixes);
            }
            if (reportProblem) {
                Ref message = Ref.create((Object)JSBundle.message((String)(inNewExpression ? "javascript.unresolved.type.name.message" : "javascript.unresolved.function.name.message"), (Object[])new Object[]{refName}));
                this.reportUnresolvedReference(resolveResults, referenceExpression, quickFixes, (Ref<String>)message, this.getUnresolvedFunctionInspectionId());
            }
        } else if (resolveResults.length == 1 && resolveResults[0].getElement() instanceof JSVariable && referenceExpression.getQualifier() == null) {
            JSElement expression;
            List<JSElement> expressions = JSSymbolUtil.calcRefExprValues(referenceExpression);
            JSElement jSElement = expression = expressions.size() == 1 ? expressions.get(0) : null;
            if (expression instanceof JSObjectLiteralExpression || expression instanceof JSArrayLiteralExpression) {
                this.reportUnresolvedFunctionError(referenceExpression.getReferenceNameElement(), ProblemHighlightType.ERROR, JSBundle.message((String)"javascript.invalid.invokation.target", (Object[])new Object[0]), null);
            }
        }
    }

    private void reportUnresolvedReference(@NotNull ResolveResult[] resolveResults, @NotNull JSReferenceExpression referenceExpression, @NotNull List<LocalQuickFix> quickFixes, @NotNull Ref<String> message, @NotNull String inspectionId) {
        if (resolveResults == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResults", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "reportUnresolvedReference"));
        }
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "reportUnresolvedReference"));
        }
        if (quickFixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "reportUnresolvedReference"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "reportUnresolvedReference"));
        }
        if (inspectionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionId", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "reportUnresolvedReference"));
        }
        PsiElement place = referenceExpression.getReferenceNameElement();
        if (place == null) {
            return;
        }
        boolean jsSymbolNotAccessible = false;
        boolean forcedErrorReporting = false;
        if (resolveResults.length > 0 && resolveResults[0] instanceof JSResolveResult) {
            JSAnnotatingVisitor.addEscalateVisibilityFix(resolveResults, referenceExpression, quickFixes);
            String resolveProblemKey = ((JSResolveResult)resolveResults[0]).getResolveProblemKey();
            jsSymbolNotAccessible = resolveProblemKey == "javascript.jsdoc.private.member.is.not.accessible.message" || resolveProblemKey == "javascript.jsdoc.protected.member.is.not.accessible.message";
            boolean bl = forcedErrorReporting = resolveProblemKey == "javascript.property.is.read.only.message" || resolveProblemKey == "javascript.property.is.write.only.message";
            if (resolveProblemKey != null) {
                message.set((Object)JSBundle.message((String)resolveProblemKey, (Object[])new Object[0]));
            }
            PsiElement element = resolveResults[0].getElement();
            if (jsSymbolNotAccessible && element instanceof JSQualifiedNamedElement) {
                JSAttributeList.AccessType newVisibility = JSVisibilityUtil.getEscalatedJSDocVisibility((JSQualifiedNamedElement)element, (PsiElement)referenceExpression);
                quickFixes.add((LocalQuickFix)new JSAccessibilityCheckInspection.SetJSDocElementVisibilityFix(element, newVisibility));
            }
            this.addFixesForDistinctResolveProblem(referenceExpression, quickFixes, resolveProblemKey, element);
        }
        if (jsSymbolNotAccessible) {
            this.reportAccessibilityError(place, null, (String)message.get(), quickFixes);
        } else {
            ProblemHighlightType type = forcedErrorReporting ? ProblemHighlightType.ERROR : this.getUnresolvedReferenceHighlightType(referenceExpression);
            this.reportUnresolvedRefProblem(type, quickFixes, place, (String)message.get(), inspectionId);
        }
    }

    protected void addCreateFromUsageFixesForCall(JSCallExpression node, JSReferenceExpression referenceExpression, ResolveResult[] resolveResults, List<LocalQuickFix> quickFixes) {
        boolean inNewExpression = node instanceof JSNewExpression;
        String refName = referenceExpression.getReferenceName();
        DialectOptionHolder dialect = DialectDetector.dialectOfFile(node.getContainingFile());
        boolean simpleJs = dialect == null || dialect.isJavaScript();
        JSExpression qualifier = referenceExpression.getQualifier();
        if (!inNewExpression || dialect != null && !dialect.isECMA4 && !dialect.isTypeScript) {
            quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, true));
        }
        if (qualifier == null) {
            if (simpleJs) {
                quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, false));
            } else if (inNewExpression) {
                quickFixes.add(this.createClassOrInterfaceFix(referenceExpression, false, node.getArgumentList(), JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)node)));
            }
        } else if (inNewExpression && AnalysisUtils.isLHSExpression(qualifier)) {
            quickFixes.add(this.createClassOrInterfaceFix(referenceExpression, false, node.getArgumentList(), JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)node)));
        }
        quickFixes.add(this.renameReferenceFix());
    }

    private LocalQuickFix createClassOrInterfaceFix(JSReferenceExpression referenceExpression, boolean isInterface, JSArgumentList argumentList, JSType expectedType) {
        return JSFixFactory.getInstance().createClassOrInterfaceFix(referenceExpression, isInterface, argumentList, expectedType);
    }

    private LocalQuickFix renameReferenceFix() {
        return JSFixFactory.getInstance().renameReferenceFix();
    }

    protected Annotation reportUnresolvedRefProblem(@Nullable ProblemHighlightType unresolveReferenceHighlightType, @Nullable List<LocalQuickFix> quickFixes, @NotNull PsiElement referenceNameElement, @NotNull String message, @Nullable String inspectionId) {
        if (referenceNameElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceNameElement", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "reportUnresolvedRefProblem"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "reportUnresolvedRefProblem"));
        }
        return this.myProblemReporter.registerProblem(referenceNameElement, message, unresolveReferenceHighlightType, inspectionId, quickFixes != null && !quickFixes.isEmpty() ? quickFixes.toArray(new LocalQuickFix[quickFixes.size()]) : null);
    }

    public void visitJSArrayComprehension(JSArrayComprehension arrayComprehension) {
        this.checkElementInCurrentLanguageLevel((PsiElement)arrayComprehension, JSLanguageFeature.ARRAY_COMPREHENSIONS);
    }

    public void visitJSYieldExpression(JSYieldExpression expression) {
        if (!(expression.getExpression() instanceof JSParenthesizedExpression)) {
            this.checkElementInCurrentLanguageLevel((PsiElement)expression, JSLanguageFeature.YIELD_GENERATORS);
        }
    }

    public void visitJSBindExpression(JSExpression bindExpression) {
        this.checkElementInCurrentLanguageLevel((PsiElement)bindExpression, JSLanguageFeature.BIND_EXPRESSIONS);
    }

    protected boolean checkElementInCurrentLanguageLevel(@NotNull PsiElement elementToHighlight, @NotNull JSLanguageFeature languageFeature) {
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "checkElementInCurrentLanguageLevel"));
        }
        if (languageFeature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageFeature", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "checkElementInCurrentLanguageLevel"));
        }
        return this.checkElementInCurrentLanguageLevel(elementToHighlight, null, languageFeature);
    }

    private boolean checkElementInCurrentLanguageLevel(@NotNull PsiElement elementToHighlight, @Nullable TextRange range, @NotNull JSLanguageFeature languageFeature) {
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "checkElementInCurrentLanguageLevel"));
        }
        if (languageFeature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageFeature", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "checkElementInCurrentLanguageLevel"));
        }
        JSLanguageLevel currentLevel = JSLanguageLevel.ofElement(elementToHighlight);
        if (currentLevel != null && !currentLevel.getDialect().getOptionHolder().hasFeature(languageFeature)) {
            String message = JSBundle.message((String)"javascript.parser.message.are.not.supported.by.dialect", (Object[])new Object[]{languageFeature});
            ArrayList<ChangeLanguageLevelFix> fixes = new ArrayList<ChangeLanguageLevelFix>(2);
            JSLanguageLevel proposedLevel = ChangeLanguageLevelFix.defineMinimalLanguageLevel(languageFeature, currentLevel);
            if (proposedLevel != null) {
                fixes.add(new ChangeLanguageLevelFix(proposedLevel));
            }
            if (DialectOptionHolder.ECMA_6.hasFeature(languageFeature) && proposedLevel != JSLanguageLevel.ES6) {
                fixes.add(new ChangeLanguageLevelFix(JSLanguageLevel.ES6));
            }
            if (range == null) {
                this.myProblemReporter.registerProblem(elementToHighlight, message, ProblemHighlightType.GENERIC_ERROR, (IntentionAction[])ContainerUtil.toArray(fixes, (Object[])new IntentionAction[fixes.size()]));
            } else {
                this.myProblemReporter.registerProblem(elementToHighlight, range, message, ProblemHighlightType.GENERIC_ERROR, null, null, (IntentionAction[])ContainerUtil.toArray(fixes, (Object[])new IntentionAction[fixes.size()]));
            }
            return false;
        }
        return true;
    }

    public void visitJSLetStatement(JSLetStatement statement) {
        this.checkElementInCurrentLanguageLevel((PsiElement)statement, JSLanguageFeature.LET_SCOPE);
    }

    public void visitComment(PsiComment comment) {
        super.visitComment(comment);
        String text = comment.getText();
        if (text.startsWith("/*") && !text.endsWith("*/")) {
            TextRange r = comment.getTextRange();
            TextRange errorRange = TextRange.create((int)Math.max(r.getStartOffset(), r.getEndOffset() - 1), (int)r.getEndOffset());
            this.myHolder.createErrorAnnotation(errorRange, JSBundle.message((String)"javascript.parser.message.unclosed.comment", (Object[])new Object[0]));
        }
    }

    public void visitJSVarStatement(JSVarStatement node) {
        ASTNode let = node.getNode().findChildByType(JSTokenTypes.LET_KEYWORD);
        if (let != null) {
            this.checkElementInCurrentLanguageLevel(let.getPsi(), JSLanguageFeature.LET_DEFINITIONS);
        }
    }

    public void visitJSDestructuringContainer(JSDestructuringContainer destructuringContainer) {
        this.checkElementInCurrentLanguageLevel((PsiElement)destructuringContainer, JSLanguageFeature.DESTRUCTURING_ASSIGNMENT);
    }

    public void visitJSExpressionStatement(JSExpressionStatement node) {
        PsiElement prevSibling = node.getPrevSibling();
        if (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        if (prevSibling instanceof JSSourceElement) {
            JSFunction function;
            PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)node);
            if (prev instanceof PsiWhiteSpace) {
                prev = PsiTreeUtil.prevLeaf((PsiElement)prev);
            }
            if (prev instanceof PsiErrorElement && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)prev, JSFunction.class)) != null && function.getBody().length == 0) {
                this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.EXPRESSION_CLOSURES);
            }
        }
        super.visitJSExpressionStatement(node);
    }

    public void visitJSGeneratorExpression(JSGeneratorExpression generatorExpression) {
        ASTNode eachKeyword = generatorExpression.getNode().findChildByType(JSTokenTypes.EACH_KEYWORD);
        if (eachKeyword != null) {
            JSSemanticHighlightingUtil.highlightKeyword(eachKeyword, this.myHolder);
        }
        this.checkElementInCurrentLanguageLevel((PsiElement)generatorExpression, JSLanguageFeature.GENERATOR_EXPRESSIONS);
    }

    public void visitJSReferenceExpression(JSReferenceExpression node) {
        JSSemanticHighlightingUtil.highlight((JSPsiReferenceElement)node, this.myHighlighter, this.myHolder);
        PsiElement parent = node.getParent();
        boolean doCheckForReferencingUnallowedMembers = false;
        if (parent instanceof JSNamedElement) {
            JSNamedElement namedElement = (JSNamedElement)parent;
            PsiElement nameIdentifier = namedElement.getNameIdentifier();
            if (nameIdentifier == node) {
                if (parent instanceof JSVariable) {
                    DuplicatesCheckUtil.checkDuplicatesForVariable((JSVariable)parent, this.myProblemReporter);
                }
            } else if (parent instanceof JSDefinitionExpression) {
                doCheckForReferencingUnallowedMembers = true;
            }
        } else {
            doCheckForReferencingUnallowedMembers = true;
        }
        if (doCheckForReferencingUnallowedMembers) {
            String referencedName = node.getReferenceName();
            PsiElement referenceNameElement = node.getReferenceNameElement();
            assert (referencedName == null || referenceNameElement != null) : referencedName;
            if (("caller".equals(referencedName) || "callee".equals(referencedName)) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                PsiElement resolve;
                JSExpression qualifier = node.getQualifier();
                if (qualifier instanceof JSReferenceExpression && ((resolve = ((JSReferenceExpression)qualifier).resolve()) instanceof ImplicitJSVariableImpl || resolve instanceof JSFunction)) {
                    this.myProblemReporter.registerGenericError(referenceNameElement, JSBundle.message((String)"javascript.validation.message.referencing.arguments.caller.callee.is.not.allowed", (Object[])new Object[0]), new IntentionAction[0]);
                }
            } else if ("arguments".equals(referencedName) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                if (node.getQualifier() != null) {
                    JSType type = JSResolveUtil.getExpressionJSType(node.getQualifier());
                    if (type != null && !(type instanceof JSAnyType) && JSTypeUtils.hasFunctionType(type)) {
                        this.myProblemReporter.registerProblem(referenceNameElement, JSBundle.message((String)"javascript.validation.message.referencing.function.arguments.property.is.not.allowed", (Object[])new Object[0]));
                    } else if (type != null && !type.getSource().isExplicitlyDeclared()) {
                        this.myProblemReporter.registerProblem(referenceNameElement, JSBundle.message((String)"javascript.validation.message.referencing.function.arguments.property.is.not.allowed", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new IntentionAction[0]);
                    }
                } else if (parent instanceof JSDefinitionExpression) {
                    this.myProblemReporter.registerGenericError((PsiElement)node, JSBundle.message((String)"javascript.validation.message.arguments.is.readonly", (Object[])new Object[0]), new IntentionAction[0]);
                }
            } else if (EVAL_FUNCTION_NAME.equals(referencedName) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                if (!JSAnnotatingVisitor.isEvalAllowed(node)) {
                    this.myProblemReporter.registerGenericError(referenceNameElement, JSBundle.message((String)"javascript.validation.message.referencing.eval.outside.call.is.not.allowed", (Object[])new Object[0]), new IntentionAction[0]);
                }
            } else if (referenceNameElement != null && JSKeywordSets.JS_STRICT_KEYWORDS.contains(referenceNameElement.getNode().getElementType()) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                this.myProblemReporter.registerGenericError(referenceNameElement, JSBundle.message((String)"javascript.validation.message.identifier.not.allowed.in.strict.mode", (Object[])new Object[]{node.getReferenceName()}), new IntentionAction[0]);
            }
        }
        boolean checkRefExpr = true;
        if (JSSymbolUtil.isAccurateReferenceExpressionName(node, "arguments") && PsiTreeUtil.getParentOfType((PsiElement)node, XmlAttributeValue.class) != null) {
            checkRefExpr = false;
        }
        if (checkRefExpr) {
            this.checkRefExpression(node);
        }
    }

    protected void checkSetterReturnType(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "checkSetterReturnType"));
        }
        JSType type = function.getReturnType();
        if (type != null && !(type instanceof JSVoidType)) {
            PsiElement returnTypeElement = function.getReturnTypeElement();
            this.myProblemReporter.registerGenericError(returnTypeElement != null ? returnTypeElement : JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)function), JSBundle.message((String)"javascript.validation.message.set.method.should.be.void.or.without.type", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    protected void checkGetterAndSetterTypeMatch(JSFunction setter, JSFunction getter, JSParameterListElement param, JSType setterType, JSType retType) {
        if (!(setterType instanceof JSAnyType || retType instanceof JSAnyType || JSTypeUtils.areTypesCompatible(setterType, retType, null, (PsiElement)setter))) {
            PsiElement typeElement = param.getTypeElement();
            this.myProblemReporter.registerGenericError((PsiElement)(typeElement != null ? typeElement : param), JSBundle.message((String)"javascript.validation.message.set.method.type.is.different.from.getter", (Object[])new Object[]{retType != null ? retType.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : "empty"}), new IntentionAction[0]);
        }
        this.checkAccessorAccessTypeMatch(setter, getter, "javascript.validation.message.set.method.access.type.is.different.from.getter");
    }

    protected void validateGetPropertyReturnType(JSFunction function, JSType type) {
    }

    private static boolean isEvalAllowed(JSReferenceExpression node) {
        JSDefinitionExpression definitionExpression = (JSDefinitionExpression)PsiTreeUtil.getParentOfType((PsiElement)node, JSDefinitionExpression.class);
        if (definitionExpression != null && node.getQualifier() != null) {
            return true;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSCallExpression.class, JSStatement.class}) instanceof JSCallExpression;
    }

    protected static boolean isBindable(JSClass clazz) {
        if (clazz instanceof XmlBackedJSClass) {
            return true;
        }
        JSAttributeList attributeList = clazz.getAttributeList();
        return attributeList != null && attributeList.getAttributesByName("Bindable").length > 0;
    }

    protected void checkAccessorAccessTypeMatch(@NotNull JSFunction function, @NotNull JSFunction getter, String s) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "checkAccessorAccessTypeMatch"));
        }
        if (getter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "checkAccessorAccessTypeMatch"));
        }
        JSAttributeList getterAttrList = getter.getAttributeList();
        JSAttributeList attributeList = function.getAttributeList();
        if (JSAnnotatingVisitor.differentAccessType(attributeList, getterAttrList)) {
            PsiElement typeElement = attributeList != null ? attributeList.findAccessTypeElement() : null;
            JSAttributeList.AccessType getterAccessType = getterAttrList != null ? getterAttrList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
            JSAttributeList.AccessType attributeListAccessType = attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
            this.myProblemReporter.registerGenericError(typeElement != null ? typeElement : function.getNameIdentifier(), JSBundle.message((String)s, (Object[])new Object[]{JSFormatUtil.formatVisibility(getterAccessType)}), new IntentionAction[]{JSFixFactory.getInstance().createChangeVisibilityFix((JSAttributeListOwner)function, getterAccessType, null), JSFixFactory.getInstance().createChangeVisibilityFix((JSAttributeListOwner)getter, attributeListAccessType, null)});
        }
    }

    private static boolean differentAccessType(@Nullable JSAttributeList attributeList, @Nullable JSAttributeList setterAttrList) {
        if (attributeList != null && setterAttrList != null) {
            JSAttributeList.AccessType setterAccessType;
            JSAttributeList.AccessType accessType = attributeList.getAccessType();
            if (accessType != (setterAccessType = setterAttrList.getAccessType())) {
                return (accessType != JSAttributeList.AccessType.PACKAGE_LOCAL || attributeList.getNamespaceElement() == null) && (setterAccessType != JSAttributeList.AccessType.PACKAGE_LOCAL || setterAttrList.getNamespaceElement() == null);
            }
            return false;
        }
        return attributeList != setterAttrList;
    }

    protected void checkRefExpression(@NotNull JSReferenceExpression node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "checkRefExpression"));
        }
        if (!node.shouldCheckReferences() || node.getParent() instanceof JSCallExpression) {
            return;
        }
        ResolveResult[] resolveResults = node.multiResolve(false);
        boolean emptyResolve = resolveResults.length == 0;
        boolean noCompleteResolve = true;
        for (ResolveResult r : resolveResults) {
            if (!r.isValidResult()) continue;
            noCompleteResolve = false;
            if (this.processExpressionResolveResult((JSExpression)node, r.getElement())) break;
        }
        if (emptyResolve || noCompleteResolve) {
            this.registerQuickFixesForUnresolvedRef(node, resolveResults);
        } else if (!JSResolveUtil.isSelfReference((PsiElement)node)) {
            ReadWriteAccessDetector.Access expressionAccess = JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node);
            boolean hasConstProblem = false;
            if (expressionAccess != ReadWriteAccessDetector.Access.Read) {
                hasConstProblem = this.checkAssignmentToConst(node);
            }
            if (!hasConstProblem && expressionAccess == ReadWriteAccessDetector.Access.ReadWrite) {
                boolean seenRead = false;
                boolean seenWrite = false;
                for (ResolveResult r : resolveResults) {
                    PsiElement element = r.getElement();
                    if (element instanceof JSFunction && ((JSFunction)element).isGetProperty() || element instanceof JSProperty && ((JSProperty)element).isGetProperty()) {
                        seenRead = true;
                        continue;
                    }
                    if (element instanceof JSFunction && ((JSFunction)element).isSetProperty() || element instanceof JSProperty && ((JSProperty)element).isSetProperty()) {
                        seenWrite = true;
                        continue;
                    }
                    if (!(element instanceof JSProperty) && !(element instanceof JSVariable) && !(element instanceof JSDefinitionExpression)) continue;
                    seenWrite = true;
                    seenRead = true;
                    break;
                }
                if (seenRead || seenWrite) {
                    if (!seenRead) {
                        this.reportUnresolvedFunctionError(node.getReferenceNameElement(), null, JSBundle.message((String)"javascript.missing.read.property", (Object[])new Object[0]), null);
                    }
                    if (!seenWrite) {
                        this.reportUnresolvedFunctionError(node.getReferenceNameElement(), null, JSBundle.message((String)"javascript.missing.write.property", (Object[])new Object[0]), null);
                    }
                }
            }
        }
    }

    protected boolean processExpressionResolveResult(@Nullable JSExpression expression, @Nullable PsiElement resolved) {
        return true;
    }

    private void registerQuickFixesForUnresolvedRef(JSReferenceExpression node, ResolveResult[] resolveResults) {
        boolean canHaveCreateFromUsage;
        PsiElement nameIdentifier = node.getReferenceNameElement();
        if (nameIdentifier == null) {
            return;
        }
        LinkedList<LocalQuickFix> fixes = new LinkedList<LocalQuickFix>();
        boolean inTypeContext = JSResolveUtil.isExprInTypeContext(node);
        JSExpression qualifier = node.getQualifier();
        boolean bl = canHaveCreateFromUsage = JSAnnotatingVisitor.findInsufficientVisibilityResult(resolveResults) == null && JSAnnotatingVisitor.canHaveCreateFromUsage(qualifier);
        if (canHaveCreateFromUsage) {
            ContainerUtil.addIfNotNull(fixes, (Object)this.getPreferredQuickFixForUnresolvedRef(nameIdentifier));
            if (fixes.isEmpty()) {
                boolean reportProblem;
                PsiFile containingFile = node.getContainingFile();
                boolean ecma = containingFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                ProblemHighlightType highlightType = this.getUnresolvedReferenceHighlightType(node);
                boolean bl2 = reportProblem = (!ecma || highlightType != ProblemHighlightType.LIKE_UNKNOWN_SYMBOL) && highlightType != null;
                if (!reportProblem) {
                    return;
                }
                inTypeContext = this.addCreateFromUsageFixes(node, resolveResults, fixes, inTypeContext, ecma);
            }
        }
        JSAnnotatingVisitor.addEscalateVisibilityFix(resolveResults, node, fixes);
        fixes.add(this.renameReferenceFix());
        Ref message = Ref.create((Object)JSBundle.message((String)(node.getQualifier() == null ? (inTypeContext ? "javascript.unresolved.type.name.message" : "javascript.unresolved.variable.or.type.name.message") : "javascript.unresolved.variable.name.message"), (Object[])new Object[]{node.getReferenceName()}));
        this.reportUnresolvedReference(resolveResults, node, fixes, (Ref<String>)message, this.getUnresolvedVariableInspectionId());
    }

    protected void addFixesForDistinctResolveProblem(JSReferenceExpression node, List<LocalQuickFix> fixes, String resolveProblemKey, PsiElement element) {
    }

    protected boolean addCreateFromUsageFixes(JSReferenceExpression node, ResolveResult[] resolveResults, List<LocalQuickFix> fixes, boolean inTypeContext, boolean ecma) {
        boolean isField;
        JSExpression qualifier = node.getQualifier();
        String referencedName = node.getReferenceName();
        PsiElement parent = node.getParent();
        PsiFile containingFile = node.getContainingFile();
        DialectOptionHolder dialect = DialectDetector.dialectOfFile(containingFile);
        boolean bl = isField = qualifier != null || (ecma || JSClassUtils.canHaveClasses((PsiElement)containingFile)) && JSResolveUtil.getClassOfContext((PsiElement)node) != null;
        if (!inTypeContext) {
            if (parent instanceof JSArgumentList && (dialect == null || !dialect.isTypeScript)) {
                fixes.add(JSFixFactory.getInstance().createJSFunctionFromArgumentIntentionAction(referencedName, qualifier, ecma));
            }
            if (parent instanceof ES6Decorator) {
                fixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(referencedName, false));
            } else if (this.suggestCreateVarFromUsage(node)) {
                fixes.add(this.createJSVariableIntentionAction(referencedName, isField, false));
                if (isField && qualifier == null) {
                    fixes.add(this.createJSVariableIntentionAction(referencedName, false, false));
                }
                if (qualifier == null) {
                    JSAnnotatingVisitor.addCreateParameterFix(parent, fixes, referencedName);
                }
                if (ecma && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node) == ReadWriteAccessDetector.Access.Read) {
                    fixes.add(this.createJSVariableIntentionAction(referencedName, isField, true));
                }
            }
        }
        if (qualifier != null && dialect != null && dialect.isJavaScript()) {
            fixes.add(JSFixFactory.getInstance().createJSNamespaceIntentionAction(referencedName));
        }
        return inTypeContext;
    }

    protected LocalQuickFix createJSVariableIntentionAction(String referencedName, boolean isField, boolean isConstant) {
        return JSFixFactory.getInstance().createJSVariableIntentionAction(referencedName, isField, isConstant);
    }

    protected boolean suggestCreateVarFromUsage(JSReferenceExpression node) {
        return true;
    }

    @Nullable
    protected LocalQuickFix getPreferredQuickFixForUnresolvedRef(PsiElement nameIdentifier) {
        return null;
    }

    private static JSResolveResult findInsufficientVisibilityResult(ResolveResult[] results) {
        for (ResolveResult r : results) {
            String problemKey;
            if (r.isValidResult() || !(r instanceof JSResolveResult) || !ArrayUtil.contains((String)(problemKey = ((JSResolveResult)r).getResolveProblemKey()), (String[])JSResolveResult.INSUFFICIENT_VISIBILITY_PROBLEM_KEYS)) continue;
            return (JSResolveResult)r;
        }
        return null;
    }

    private static void addEscalateVisibilityFix(ResolveResult[] resolveResults, JSReferenceExpression refExpr, List<LocalQuickFix> fixes) {
        JSResolveResult result = JSAnnotatingVisitor.findInsufficientVisibilityResult(resolveResults);
        if (result == null || !(result.getElement() instanceof JSAttributeListOwner)) {
            return;
        }
        JSAttributeListOwner element = (JSAttributeListOwner)result.getElement();
        JSAttributeList attributeList = element.getAttributeList();
        if (attributeList == null) {
            return;
        }
        if (JSProjectUtil.isInLibrary((PsiElement)element)) {
            return;
        }
        JSVisibilityUtil.Options options = new JSVisibilityUtil.Options();
        options.ignoreClassInheritance = result.getResolveProblemKey() == "javascript.protected.member.is.not.accessible.message";
        JSAttributeList.AccessType visibility = JSVisibilityUtil.getEscalatedVisibility(element, (PsiElement)refExpr, attributeList.getAccessType(), options);
        fixes.add((LocalQuickFix)JSFixFactory.getInstance().createChangeVisibilityFix(element, visibility, null));
    }

    private static boolean canHaveCreateFromUsage(JSExpression qualifier) {
        JSExpression innerExpression;
        if (qualifier instanceof JSParenthesizedExpression && (innerExpression = ((JSParenthesizedExpression)qualifier).getInnerExpression()) instanceof JSBinaryExpression && JSTokenTypes.AS_KEYWORD == ((JSBinaryExpression)innerExpression).getOperationSign()) {
            return true;
        }
        return qualifier == null || qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression || qualifier instanceof JSNewExpression || AnalysisUtils.isLHSExpression(qualifier);
    }

    protected static void addCreateParameterFix(PsiElement parentElement, List<LocalQuickFix> fixes, String referencedName) {
        if (PsiTreeUtil.getParentOfType((PsiElement)parentElement, JSFunction.class) != null) {
            fixes.add(JSFixFactory.getInstance().createJSParameterIntentionAction(referencedName));
        }
    }

    protected void checkMissedSuperCall(@Nullable JSFunction constructor, @NotNull JSClass jsClass) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "checkMissedSuperCall"));
        }
        if (jsClass.isInterface()) {
            return;
        }
        JSFunction nontrivialSuperClassConstructor = JSAnnotatingVisitor.getNontrivialSuperClassConstructor(jsClass);
        if (nontrivialSuperClassConstructor != null) {
            Annotation annotation = null;
            if (!JSAnnotatingVisitor.hasSuperConstructorCall(constructor)) {
                PsiElement place = JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)(constructor != null ? constructor : jsClass));
                annotation = this.myProblemReporter.registerGenericError(place, JSBundle.message((String)"javascript.validation.message.missed.super.constructor.call", (Object[])new Object[0]), new IntentionAction[0]);
            }
            if (annotation != null) {
                if (constructor == null) {
                    annotation.registerFix(JSFixFactory.getInstance().addConstructorAndSuperInvocationFix(jsClass, nontrivialSuperClassConstructor));
                } else {
                    annotation.registerFix(JSFixFactory.getInstance().addSuperInvocationFix(constructor, nontrivialSuperClassConstructor));
                }
            }
        }
    }

    @Contract(value="null -> false")
    private static boolean hasSuperConstructorCall(@Nullable JSFunction jsFunction) {
        if (jsFunction == null) {
            return false;
        }
        JSSourceElement[] body = jsFunction.getBody();
        return body.length > 0 && JSAnnotatingVisitor.containsSuperCall((JSBlockStatement)body[0]);
    }

    private static boolean containsSuperCall(JSBlockStatement blockStatement) {
        for (JSStatement statement : blockStatement.getStatements()) {
            JSStatement then;
            JSExpression expr;
            if (statement instanceof JSExpressionStatement && (expr = ((JSExpressionStatement)statement).getExpression()) instanceof JSCallExpression && ((JSCallExpression)expr).getMethodExpression() instanceof JSSuperExpression) {
                return true;
            }
            if (!(statement instanceof JSIfStatement) || !((then = ((JSIfStatement)statement).getThen()) instanceof JSBlockStatement) || !JSAnnotatingVisitor.containsSuperCall((JSBlockStatement)then)) continue;
            return true;
        }
        return false;
    }

    public static JSFunction getNontrivialSuperClassConstructor(JSClass clazz) {
        JSFunction constructor;
        JSClass[] classes;
        if (clazz instanceof TypeScriptClass) {
            for (JSFunction function : ((TypeScriptClass)clazz).getIndirectSuperConstructors()) {
                if (!ValidateTypesUtil.hasRequiredParameters(function)) continue;
                return function;
            }
        }
        if ((classes = clazz.getSuperClasses()).length > 0 && (constructor = classes[0].getConstructor()) != null) {
            return ValidateTypesUtil.hasRequiredParameters(constructor) ? constructor : null;
        }
        return null;
    }

    public void visitJSSwitchStatement(JSSwitchStatement node) {
        boolean encounteredDefault = false;
        for (JSCaseClause clause : node.getCaseClauses()) {
            if (!clause.isDefault()) continue;
            if (encounteredDefault) {
                this.myProblemReporter.registerGenericError((PsiElement)clause, JSBundle.message((String)"javascript.validation.message.only.one.default.is.allowed", (Object[])new Object[0]), new IntentionAction[0]).registerFix((IntentionAction)JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.default", clause.getNode()));
            }
            encounteredDefault = true;
        }
    }

    public void visitJSParameterList(JSParameterList node) {
        boolean foundRest = false;
        boolean initializerPresent = false;
        for (JSParameterListElement parameter : node.getParameters()) {
            boolean hasInitializer;
            JSExpression initializer = parameter.getInitializer();
            boolean bl = hasInitializer = initializer != null;
            if (hasInitializer && !initializerPresent) {
                initializerPresent = true;
            }
            if (!hasInitializer && initializerPresent && this.needsInitializer(parameter)) {
                Annotation errorAnnotation = this.myProblemReporter.registerGenericError((PsiElement)parameter, JSBundle.message((String)"javascript.validation.message.parameter.should.be.initialized", (Object[])new Object[0]), new IntentionAction[0]);
                Function targetGenerator = aVoid -> {
                    if (!parameter.isValid()) {
                        return parameter;
                    }
                    String newText = parameter.getText() + "=" + JSTypeUtils.defaultValueOfType(parameter.getType());
                    ASTNode tree = JSChangeUtil.createJSTreeFromText(parameter.getProject(), "function foo(" + newText + "){}", JSUtils.getDialect(parameter.getContainingFile()));
                    assert (tree != null);
                    PsiElement newElement = tree.getPsi();
                    return ((JSFunction)newElement).getParameters()[0];
                };
                errorAnnotation.registerFix((IntentionAction)new ReplacePsiElementFix((PsiElement)parameter, (Function<Void, PsiElement>)targetGenerator, "javascript.fix.initialize.parameter"));
                errorAnnotation.registerFix((IntentionAction)JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.parameter", parameter.getNode()));
            } else if (hasInitializer && parameter.isRest()) {
                Pair<ASTNode, ASTNode> nodesBefore = JSAnnotatingVisitor.getNodesBefore((PsiElement)initializer, JSTokenTypes.EQ);
                this.myProblemReporter.registerGenericError((PsiElement)parameter, JSBundle.message((String)"javascript.validation.message.rest.parameter.should.not.be.initialized", (Object[])new Object[0]), new IntentionAction[0]).registerFix((IntentionAction)JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.initializer", false, (ASTNode)nodesBefore.first, (ASTNode)nodesBefore.second));
            }
            if (parameter.isRest() && !foundRest) {
                foundRest = true;
                this.validateRestParameterType((JSParameter)parameter);
                continue;
            }
            if (!foundRest) continue;
            this.myProblemReporter.registerGenericError((PsiElement)parameter, JSBundle.message((String)"javascript.validation.message.parameter.is.not.allowed.after.rest.parameter", (Object[])new Object[0]), new IntentionAction[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.parameter", parameter.getNode())});
        }
    }

    public void visitJSClass(JSClass aClass) {
        this.checkElementInCurrentLanguageLevel(JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)aClass), JSLanguageFeature.CLASSES);
    }

    protected boolean needsInitializer(JSParameterListElement parameter) {
        return !parameter.isRest();
    }

    protected void validateRestParameterType(JSParameter parameter) {
    }

    protected static Pair<ASTNode, ASTNode> getNodesBefore(PsiElement initializer, IElementType eq) {
        ASTNode end;
        ASTNode start = end = initializer.getNode();
        PsiElement element = initializer.getPrevSibling();
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (element != null && element.getNode().getElementType() == eq) {
            start = element.getNode();
        }
        return Pair.create((Object)start, (Object)end);
    }

    public void visitJSAssignmentExpression(JSAssignmentExpression expression) {
        JSExpression lExpr = expression.getLOperand();
        if (lExpr == null) {
            return;
        }
        if (lExpr instanceof JSDefinitionExpression) {
            lExpr = ((JSDefinitionExpression)lExpr).getExpression();
        }
        if (lExpr == null) {
            return;
        }
        this.checkLhs(lExpr);
        this.checkTypeInAssignment(expression);
    }

    public void checkTypeInAssignment(JSAssignmentExpression expression) {
        ValidateTypesUtil.checkTypesInAssignment(expression, this.myTypeChecker);
    }

    private void checkLhs(JSExpression lExpr) {
        if (!AnalysisUtils.isLHSExpression(lExpr)) {
            this.myProblemReporter.registerGenericError((PsiElement)lExpr, JSBundle.message((String)"javascript.validation.message.must.be.lvalue", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    protected boolean checkAssignmentToConst(@NotNull JSReferenceExpression lExpr) {
        if (lExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lExpr", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "checkAssignmentToConst"));
        }
        PsiElement resolved = lExpr.resolve();
        if (JSAnnotatingVisitor.isConst(lExpr, resolved)) {
            if (this.isConstAssignable(lExpr, resolved)) {
                return false;
            }
            PsiElement place = lExpr.getReferenceNameElement();
            if (place == null) {
                place = lExpr;
            }
            String message = JSBundle.message((String)"javascript.validation.message.assignment.to.const", (Object[])new Object[0]);
            this.myProblemReporter.registerProblem(place, message);
            return true;
        }
        return false;
    }

    private static boolean isConst(@NotNull JSReferenceExpression lExpr, PsiElement resolved) {
        if (lExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lExpr", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "isConst"));
        }
        if (resolved instanceof JSVariable) {
            return ((JSVariable)resolved).isConst();
        }
        if (resolved instanceof JSImplicitElement) {
            return ((JSImplicitElement)resolved).isConst();
        }
        if (resolved instanceof JSFunction) {
            return !(resolved instanceof JSFunctionExpression) && !((JSFunction)resolved).isSetProperty() && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)lExpr) == ReadWriteAccessDetector.Access.ReadWrite;
        }
        if ((resolved instanceof JSDefinitionExpression || resolved instanceof JSProperty) && DialectDetector.isJavaScript(resolved)) {
            JSDocComment comment = JSStubBasedPsiTreeUtil.findDocComment(resolved);
            return comment != null && comment.hasConstTag();
        }
        return false;
    }

    protected boolean isConstAssignable(@NotNull JSReferenceExpression lExpr, PsiElement resolved) {
        JSExecutionScope contextParent;
        if (lExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lExpr", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "isConstAssignable"));
        }
        if (JSResolveUtil.isSameReference(lExpr, resolved)) {
            return true;
        }
        return lExpr.getQualifier() instanceof JSThisExpression && (contextParent = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)lExpr, JSExecutionScope.class)) instanceof JSFunction && ((JSFunction)contextParent).isConstructor();
    }

    public void visitJSTryStatement(JSTryStatement node) {
        JSCatchBlock[] blocks = node.getAllCatchBlocks();
        if (blocks.length > 1) {
            THashSet typeToCatch = new THashSet();
            for (JSCatchBlock block : blocks) {
                String typeText;
                JSParameter p = block.getParameter();
                if (p == null) continue;
                JSType parameterType = p.getType();
                String string = typeText = parameterType == null ? "" : parameterType.getTypeText(JSType.TypeTextFormat.SERIALIZED);
                if (typeToCatch.contains(typeText)) {
                    Annotation annotation = this.myProblemReporter.registerGenericError((PsiElement)block, JSBundle.message((String)"javascript.validation.message.duplicate.catch.block", (Object[])new Object[0]), new IntentionAction[0]);
                    annotation.registerFix((IntentionAction)JSFixFactory.getInstance().removeASTNodeFix("javascript.validation.message.duplicate.catch.block.fix", true, block.getNode(), block.getNode()));
                    continue;
                }
                typeToCatch.add(typeText);
            }
        }
    }

    public void visitJSVariable(JSVariable var) {
        String name;
        JSAttributeList attributeList;
        PsiElement nameIdentifier;
        if (var.getNode() != null && var.getNode().findChildByType(JSKeywordSets.JS_STRICT_KEYWORDS) != null && JSResolveUtil.isEcmaScript5((PsiElement)var) && (nameIdentifier = var.getNameIdentifier()) != null) {
            String message = JSBundle.message((String)"javascript.validation.message.identifier.not.allowed.in.strict.mode", (Object[])new Object[]{var.getName()});
            this.myProblemReporter.registerGenericError(nameIdentifier, message, new IntentionAction[0]);
        }
        if (var.isConst() && !var.hasInitializer() && this.isConstNeedInitializer(var) && ((attributeList = var.getAttributeList()) == null || attributeList.getAttributesByName("Embed").length == 0)) {
            if (DialectDetector.isES6((PsiElement)var)) {
                this.myProblemReporter.registerGenericError((PsiElement)var, JSBundle.message((String)"es6.validation.message.const.variable.without.initializer", (Object[])new Object[0]), new IntentionAction[0]);
            } else if (!DialectDetector.isTypeScript((PsiElement)var) || !TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)var)) {
                this.myProblemReporter.registerProblem((PsiElement)var, JSBundle.message((String)"javascript.validation.message.const.variable.without.initializer", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new IntentionAction[0]);
            }
        }
        if (("arguments".equals(name = var.getName()) || EVAL_FUNCTION_NAME.equals(name)) && JSResolveUtil.isEcmaScript5((PsiElement)var)) {
            PsiElement nameIdentifier2 = var.getNameIdentifier();
            assert (nameIdentifier2 != null) : "name is not null, name identifier is null";
            this.myProblemReporter.registerGenericError(nameIdentifier2, JSBundle.message((String)"javascript.validation.message.redefining.is.not.allowed", (Object[])new Object[]{name}), new IntentionAction[0]);
        }
        this.checkTypesInVariable(var);
        DuplicatesCheckUtil.checkDuplicatesForVariable(var, this.myProblemReporter);
    }

    protected boolean isConstNeedInitializer(JSVariable var) {
        return !JSUtils.isMember((PsiElement)var);
    }

    private void checkTypesInVariable(JSVariable node) {
        if (node.getType() instanceof JSVoidType && !DialectDetector.isTypeScript((PsiElement)node)) {
            PsiElement typeElement = node.getTypeElement();
            this.myTypeChecker.registerProblem((PsiElement)(typeElement != null ? typeElement : node), JSBundle.message((String)"javascript.illegal.variable.type.void", (Object[])new Object[0]), this.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node), new LocalQuickFix[0]);
            return;
        }
        JSExpression initializer = node.getInitializer();
        if (initializer == null) {
            return;
        }
        this.myTypeChecker.checkExpressionIsAssignableToVariable(node, initializer, node.getContainingFile(), "javascript.initializer.type.mismatch", true);
    }

    public void visitJSConditionalExpression(JSConditionalExpression node) {
        ValidateTypesUtil.checkTypesInConditionalExpr(node, this.myTypeChecker);
    }

    public void visitJSContinueStatement(JSContinueStatement node) {
        super.visitJSContinueStatement(node);
        if (node.getStatementToContinue() == null) {
            this.myProblemReporter.registerGenericError((PsiElement)node, JSBundle.message((String)"javascript.validation.message.continue.without.target", (Object[])new Object[0]), new IntentionAction[0]);
        }
        if (!(PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSExecutionScope.class, JSLoopStatement.class}) instanceof JSLoopStatement)) {
            this.myProblemReporter.registerGenericError((PsiElement)node, JSBundle.message((String)"javascript.validation.message.continue.outside.loop", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitJSBreakStatement(JSBreakStatement node) {
        super.visitJSBreakStatement(node);
        if (node.getStatementToBreak() == null) {
            this.myProblemReporter.registerGenericError((PsiElement)node, JSBundle.message((String)"javascript.validation.message.break.without.target", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitJSStatementWithLabelReference(JSStatementWithLabelReference statementWithLabelReference) {
        JSSemanticHighlightingUtil.highlight(statementWithLabelReference, this.myHighlighter, this.myHolder);
    }

    protected void checkGetterAndSetter(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "checkGetterAndSetter"));
        }
        PsiElement nameIdentifier = function.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        ASTNode accessNode = function.getNode().findChildByType(JSTokenTypes.GET_SET);
        if (accessNode != null && accessNode != nameIdentifier.getNode() && !DialectDetector.isActionScript((PsiElement)function)) {
            JSSemanticHighlightingUtil.highlightKeyword(accessNode, this.myHolder);
        }
        if (function.isSetProperty()) {
            JSParameterListElement[] params;
            this.checkSetterReturnType(function);
            JSParameterList parameterList = function.getParameterList();
            JSParameterListElement[] jSParameterListElementArray = params = parameterList != null ? parameterList.getParameters() : JSParameterListElement.EMPTY_ARRAY;
            if (params.length != 1) {
                this.myProblemReporter.registerGenericError((PsiElement)(parameterList != null ? parameterList : nameIdentifier), JSBundle.message((String)"javascript.validation.message.set.method.should.have.one.parameter", (Object[])new Object[0]), new IntentionAction[0]);
            } else {
                JSFunction getter;
                PsiElement element = JSResolveUtil.findParent((PsiElement)function);
                if (element instanceof JSClass && !JSAnnotatingVisitor.isBindable((JSClass)element) && (getter = ((JSClass)element).findFunctionByNameAndKind(function.getName(), JSFunction.FunctionKind.GETTER)) != null) {
                    JSType retType = getter.getReturnType();
                    JSType setterType = params[0].getType();
                    this.checkGetterAndSetterTypeMatch(function, getter, params[0], setterType, retType);
                }
                if (params[0].hasInitializer()) {
                    ASTNode n = params[0].getInitializer().getNode();
                    ASTNode first = params[0].getNode().findChildByType(JSTokenTypes.EQ);
                    if (first != null) {
                        LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.setter.parameter.initializer", false, first, n);
                        this.myProblemReporter.registerGenericError(n, JSBundle.message((String)"javascript.validation.message.setter.parameter.cannot.have.initializer", (Object[])new Object[0]), new IntentionAction[]{fix});
                    }
                }
            }
        } else if (function.isGetProperty()) {
            JSParameterListElement[] parameters;
            JSType type = function.getReturnType();
            this.validateGetPropertyReturnType(function, type);
            JSParameterList parameterList = function.getParameterList();
            if (parameterList != null && (parameters = parameterList.getParameters()).length != 0) {
                String key = parameters.length > 1 ? "javascript.fix.remove.parameters" : "javascript.fix.remove.parameter";
                LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix(key, false, parameters[0].getNode(), parameters[parameters.length - 1].getNode());
                this.myProblemReporter.registerGenericError((PsiElement)parameterList, JSBundle.message((String)"javascript.validation.message.get.method.should.have.no.parameter", (Object[])new Object[0]), new IntentionAction[]{fix});
            }
        }
        if ((function.isGetProperty() || function.isSetProperty()) && !(function.getParent() instanceof JSProperty) && PsiTreeUtil.getParentOfType((PsiElement)function, JSFunction.class, (boolean)true, (Class[])new Class[]{JSClass.class}) != null) {
            this.myProblemReporter.registerGenericError(nameIdentifier, JSBundle.message((String)"javascript.validation.message.accessor.could.not.be.nested.under.other.function", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitJSProperty(JSProperty node) {
        this.checkReferences((PsiElement)node);
        DuplicatesCheckUtil.checkDuplicates((JSNamedElement)node, this.myProblemReporter);
        String type = JSDocumentationUtils.findType((PsiElement)node);
        JSExpression value = node.getValue();
        if (type != null && value != null) {
            JSType jsType = JSTypeUtils.createType(type, JSTypeSourceFactory.createTypeSource((PsiElement)node, true));
            this.myTypeChecker.checkExpressionIsAssignableToType(value, jsType, "javascript.initializer.type.mismatch", (PsiElement)node);
        }
        if (node instanceof ES6Property) {
            ES6ComputedName propertyName;
            if (((ES6Property)node).isShorthanded()) {
                this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.SHORTHAND_PROPERTY_NAMES);
            }
            if ((propertyName = ((ES6Property)node).getComputedPropertyName()) != null) {
                this.checkElementInCurrentLanguageLevel((PsiElement)propertyName, JSLanguageFeature.COMPUTED_PROPERTY_NAMES);
            }
            if (node instanceof ES6FunctionProperty) {
                this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.METHOD_DEFINITION_SHORTHANDS);
            }
        }
    }

    public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "visitJSReturnStatement"));
        }
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class, XmlTagChild.class, XmlAttributeValue.class, JSFile.class});
        if (element instanceof JSFile && !(element.getContext() instanceof PsiLanguageInjectionHost) && !((JSFile)element).isCommonJSModule() || element instanceof XmlTagChild && !(element.getParent() instanceof XmlAttributeValue)) {
            this.myProblemReporter.registerProblem((PsiElement)node, JSBundle.message((String)"javascript.validation.message.return.outside.function.definition", (Object[])new Object[0]));
        }
        if (element instanceof JSFunction) {
            JSType type = ((JSFunction)element).getReturnType();
            JSExpression returnedExpr = node.getExpression();
            if (!ValidateTypesUtil.emptyReturnIsAcceptable((JSFunction)element, type) && returnedExpr == null) {
                this.myTypeChecker.registerProblem((PsiElement)node, JSBundle.message((String)"javascript.validation.message.return.value.of.type.is.required", (Object[])new Object[]{type.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), this.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node), new LocalQuickFix[0]);
            }
        }
        this.myTypeChecker.checkTypesInReturnStatement(node);
    }

    public void visitJSLabeledStatement(JSLabeledStatement node) {
        String label = node.getLabel();
        if (label != null) {
            JSSemanticHighlightingUtil.highlight(node, this.myHighlighter, this.myHolder);
            for (PsiElement run = node.getParent(); run != null; run = run.getParent()) {
                if (run instanceof JSLabeledStatement && label.equals(((JSLabeledStatement)run).getLabel())) {
                    this.myProblemReporter.registerGenericError(node.getLabelIdentifier(), JSBundle.message((String)"javascript.validation.message.duplicate.label", (Object[])new Object[0]), new IntentionAction[0]);
                    break;
                }
                if (run instanceof JSFunction) break;
            }
        }
    }

    public void visitJSWithStatement(JSWithStatement node) {
        if (JSResolveUtil.isEcmaScript5((PsiElement)node)) {
            this.myProblemReporter.registerGenericError(node.getFirstChild(), JSBundle.message((String)"javascript.with.statement.is.not.allowed.in.strict.mode.message", (Object[])new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitJSPostfixExpression(JSPostfixExpression node) {
        this.checkLhs(node.getExpression());
        ValidateTypesUtil.checkNumericTypesInUnaryOperation(node.getOperationSign(), node.getExpression(), this.myTypeChecker);
    }

    public void visitJSPrefixExpression(JSPrefixExpression node) {
        PsiElement resolve;
        IElementType operationSign;
        JSExpression expression = node.getExpression();
        if (expression != null && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)expression) == ReadWriteAccessDetector.Access.ReadWrite) {
            this.checkLhs(expression);
        }
        if ((operationSign = node.getOperationSign()) == JSTokenTypes.DELETE_KEYWORD && expression instanceof JSReferenceExpression && ((resolve = ((JSReferenceExpression)expression).resolve()) instanceof JSParameter || resolve instanceof JSFunction || resolve instanceof JSVariable)) {
            String message = JSBundle.message((String)"javascript.invalid.delete.target.message", (Object[])new Object[0]);
            if (node.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4) || JSResolveUtil.isEcmaScript5((PsiElement)expression)) {
                this.myProblemReporter.registerProblem((PsiElement)expression, message, ProblemHighlightType.ERROR, new IntentionAction[0]);
            } else {
                this.myProblemReporter.registerProblem((PsiElement)expression, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new IntentionAction[0]);
            }
        }
        ValidateTypesUtil.checkNumericTypesInUnaryOperation(operationSign, expression, this.myTypeChecker);
    }

    public void visitJSForInStatement(JSForInStatement node) {
        ASTNode ofKeyword;
        ASTNode eachKeyword = node.getNode().findChildByType(JSTokenTypes.EACH_KEYWORD);
        if (eachKeyword != null) {
            JSSemanticHighlightingUtil.highlightKeyword(eachKeyword, this.myHolder);
        }
        if ((ofKeyword = node.getNode().findChildByType(JSTokenTypes.OF_KEYWORD)) != null) {
            this.checkElementInCurrentLanguageLevel(ofKeyword.getPsi(), JSLanguageFeature.FOR_OF);
        }
    }

    public void visitJSBinaryExpression(JSBinaryExpression node) {
        this.checkTypeInBinaryExpression(node);
    }

    public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
        this.checkElementInCurrentLanguageLevel((PsiElement)importDeclaration, JSLanguageFeature.IMPORT_DECLARATIONS);
        super.visitES6ImportDeclaration(importDeclaration);
    }

    public void visitES6ExportDeclaration(ES6ExportDeclaration exportDeclaration) {
        this.checkElementInCurrentLanguageLevel((PsiElement)exportDeclaration, JSLanguageFeature.EXPORT_DECLARATIONS);
        super.visitES6ExportDeclaration(exportDeclaration);
    }

    public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
        this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.EXPORT_DECLARATIONS);
        super.visitES6ExportDefaultAssignment(node);
    }

    public void visitJSAttributeList(JSAttributeList attributeList) {
        ASTNode exportKeyword = attributeList.getNode().findChildByType(JSTokenTypes.EXPORT_KEYWORD);
        if (exportKeyword != null) {
            this.checkElementInCurrentLanguageLevel(exportKeyword.getPsi(), JSLanguageFeature.EXPORT_DECLARATIONS);
        }
        super.visitJSAttributeList(attributeList);
    }

    @NotNull
    public static PsiElement getPlaceForNamedElementProblem(@NotNull PsiNameIdentifierOwner element) {
        IElementType type;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "getPlaceForNamedElementProblem"));
        }
        PsiElement nameIdentifier = element.getNameIdentifier();
        if (nameIdentifier != null) {
            PsiElement psiElement = nameIdentifier;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "getPlaceForNamedElementProblem"));
            }
            return psiElement;
        }
        PsiElement firstChild = element.getFirstChild();
        if (firstChild instanceof JSAttributeList) {
            firstChild = firstChild.getNextSibling();
        }
        if (firstChild != null && JSKeywordSets.IDENTIFIER_NAMES.contains(type = firstChild.getNode().getElementType())) {
            PsiElement psiElement = firstChild;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "getPlaceForNamedElementProblem"));
            }
            return psiElement;
        }
        PsiNameIdentifierOwner psiNameIdentifierOwner = element;
        if (psiNameIdentifierOwner == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "getPlaceForNamedElementProblem"));
        }
        return psiNameIdentifierOwner;
    }

    protected void checkTypeInBinaryExpression(JSBinaryExpression node) {
        ValidateTypesUtil.checkTypesInBinaryExpression(node, this.myProblemReporter, this.myTypeChecker);
    }

    @Nullable
    protected String getImportCheckInspectionId() {
        return JSUnresolvedVariableInspection.SHORT_NAME;
    }

    @Nullable
    protected ProblemHighlightType getImportCheckProblemHighlightType() {
        return null;
    }

    public static void highlightFromKeyword(ES6FromClause fromClause, AnnotationHolder holder) {
        ASTNode fromKeyword = fromClause.getNode().findChildByType(JSTokenTypes.FROM_KEYWORD);
        if (fromKeyword != null) {
            JSSemanticHighlightingUtil.highlightKeyword(fromKeyword, holder);
        }
    }

    public void visitES6FromClause(ES6FromClause fromClause) {
        JSAnnotatingVisitor.highlightFromKeyword(fromClause, this.myHolder);
    }

    public void visitImportSpecifier(ES6ImportSpecifier node) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)node);
        if (holder != null && holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS)) {
            JSSemanticHighlightingUtil.highlight((JSPsiReferenceElement)node, this.myHighlighter, this.myHolder);
            this.checkReferences((PsiElement)node, this.getImportCheckInspectionId(), this.getImportCheckProblemHighlightType());
        }
    }

    public void visitES6NamespaceImportExport(ES6NamespaceImportExport namespaceImportExport) {
        super.visitES6NamespaceImportExport(namespaceImportExport);
        ASTNode asKeyword = namespaceImportExport.getNode().findChildByType(JSTokenTypes.AS_KEYWORD);
        if (asKeyword != null) {
            JSSemanticHighlightingUtil.highlightKeyword(asKeyword, this.myHolder);
        }
    }

    public void visitES6ImportedBinding(ES6ImportedBinding importedBinding) {
        PsiElement parent;
        super.visitES6ImportedBinding(importedBinding);
        DuplicatesCheckUtil.checkDuplicates((JSNamedElement)importedBinding, this.myProblemReporter);
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)importedBinding);
        if (holder == null || !holder.hasFeature(JSLanguageFeature.IMPORT_DECLARATIONS)) {
            return;
        }
        if (!importedBinding.isNamespaceImport() && (parent = importedBinding.getParent()) instanceof ES6ImportDeclaration) {
            Collection elements;
            ES6FromClause fromClause;
            PsiElement resolveResult;
            Collection referencedElements = importedBinding.findReferencedElements();
            if (!importedBinding.isNamespaceImport() && !holder.isTypeScript) {
                referencedElements = ContainerUtil.filter((Collection)referencedElements, NOT_TYPESCRIPT_EXPORT_CONDITION);
            }
            if ((resolveResult = (PsiElement)ContainerUtil.getFirstItem((Collection)referencedElements)) != null) {
                resolveResult = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolveResult);
                JSSemanticHighlightingUtil.highlight((PsiElement)importedBinding, resolveResult, this.myHighlighter, this.myHolder);
            }
            if ((fromClause = ((ES6ImportDeclaration)parent).getFromClause()) != null && (elements = fromClause.resolveReferencedElements()).size() == 1 && referencedElements.isEmpty()) {
                this.myProblemReporter.registerProblem(importedBinding.getNameIdentifier(), JSBundle.message((String)"es6.default.export.not.declared", (Object[])new Object[0]), this.getImportCheckProblemHighlightType(), this.getImportCheckInspectionId(), new LocalQuickFix[0]);
            }
        }
    }

    public void visitES6ImportSpecifierAlias(ES6ImportSpecifierAlias specifierAlias) {
        DuplicatesCheckUtil.checkDuplicates((JSNamedElement)specifierAlias, this.myProblemReporter);
    }

    public void visitES6ExportSpecifier(ES6ExportSpecifier node) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)node);
        if (holder != null && holder.hasFeature(JSLanguageFeature.EXPORT_DECLARATIONS)) {
            JSSemanticHighlightingUtil.highlight((JSPsiReferenceElement)node, this.myHighlighter, this.myHolder);
            this.checkReferences((PsiElement)node, this.getImportCheckInspectionId(), this.getImportCheckProblemHighlightType());
        }
    }

    protected String getUnresolvedVariableInspectionId() {
        return JSUnresolvedVariableInspection.SHORT_NAME;
    }

    protected Annotation reportUnresolvedFunctionError(PsiElement referenceNameElement, ProblemHighlightType problemHighlightType, String message, List<LocalQuickFix> fixes) {
        return this.reportUnresolvedRefProblem(problemHighlightType, fixes, referenceNameElement, message, JSUnresolvedFunctionInspection.SHORT_NAME);
    }

    protected String getUnresolvedFunctionInspectionId() {
        return JSUnresolvedFunctionInspection.SHORT_NAME;
    }

    protected void reportAccessibilityError(PsiElement identifier, ProblemHighlightType problemHighlightType, String message, List<LocalQuickFix> fixes) {
        this.reportUnresolvedRefProblem(problemHighlightType, fixes, identifier, message, JSAccessibilityCheckInspection.SHORT_NAME);
    }

    protected void checkFunctionDeclaration(@NotNull JSFunction function) {
        PsiElement functionParent;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "checkFunctionDeclaration"));
        }
        if (function.isGenerator()) {
            this.checkElementInCurrentLanguageLevel(JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)function), JSLanguageFeature.YIELD_GENERATORS);
        }
        DuplicatesCheckUtil.checkDuplicates((JSNamedElement)function, this.myProblemReporter);
        JSSemanticHighlightingUtil.highlight((PsiElement)function, (PsiElement)function, this.myHighlighter, this.myHolder);
        String funName = function.getName();
        if ((EVAL_FUNCTION_NAME.equals(funName) || "arguments".equals(funName)) && JSResolveUtil.isEcmaScript5((PsiElement)function)) {
            this.myProblemReporter.registerGenericError(JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)function), JSBundle.message((String)"javascript.validation.message.redefining.is.not.allowed", (Object[])new Object[]{funName}), new IntentionAction[0]);
        }
        if (!((functionParent = JSResolveUtil.findParent((PsiElement)function)) instanceof JSFile || functionParent instanceof JSEmbeddedContent || functionParent instanceof JSClass || functionParent instanceof TypeScriptModule || functionParent instanceof JSBlockStatement && functionParent.getParent() instanceof JSFunction || !JSResolveUtil.isEcmaScript5((PsiElement)function))) {
            this.myProblemReporter.registerGenericError(JSAnnotatingVisitor.getPlaceForNamedElementProblem((PsiNameIdentifierOwner)function), JSBundle.message((String)"javascript.validation.message.es5.function.declarations.allowed.on.top.level.or.function", (Object[])new Object[0]), new IntentionAction[0]);
        }
        if (function.isConstructor() && functionParent instanceof JSClass) {
            JSClass clazz = (JSClass)functionParent;
            this.checkMissedSuperCall(function, clazz);
        }
        this.checkGetterAndSetter(function);
    }

    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor", "visitJSFunctionExpression"));
        }
        this.checkGetterAndSetter((JSFunction)node);
    }

    public void visitJSStringTemplateExpression(JSStringTemplateExpression stringTemplateExpression) {
        this.checkElementInCurrentLanguageLevel((PsiElement)stringTemplateExpression, JSLanguageFeature.STRING_TEMPLATES);
    }

    public class SimpleErrorReportingClient
    implements ErrorReportingClient {
        @Override
        public void reportError(ASTNode nameIdentifier, String s, ErrorReportingClient.ProblemKind kind, IntentionAction ... fixes) {
            if (fixes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/lang/javascript/validation/JSAnnotatingVisitor$SimpleErrorReportingClient", "reportError"));
            }
            Annotation annotation = kind == ErrorReportingClient.ProblemKind.ERROR ? JSAnnotatingVisitor.this.myProblemReporter.registerGenericError(nameIdentifier, s, new IntentionAction[0]) : JSAnnotatingVisitor.this.myProblemReporter.registerProblem(nameIdentifier.getPsi(), s, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new IntentionAction[0]);
            for (IntentionAction fix : fixes) {
                if (fix == null) continue;
                annotation.registerFix(fix);
            }
        }
    }

    protected static enum SignatureMatchResult {
        PARAMETERS_DIFFERS,
        RETURN_TYPE_DIFFERS,
        FUNCTION_KIND_DIFFERS,
        COMPATIBLE_SIGNATURE;

    }

    public static interface ErrorReportingClient {
        public void reportError(ASTNode var1, String var2, ProblemKind var3, IntentionAction ... var4);

        public static enum ProblemKind {
            ERROR,
            WARNING;

        }
    }
}

