/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class JSMinifiedFilesFilter
extends GeneratedSourcesFilter {
    public boolean isGeneratedSource(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/validation/JSMinifiedFilesFilter", "isGeneratedSource"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/JSMinifiedFilesFilter", "isGeneratedSource"));
        }
        if (file.isDirectory() || !DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType())) {
            return false;
        }
        if (project.isDefault()) {
            return false;
        }
        if (!file.isValid()) {
            return false;
        }
        return JSMinifiedFileUtil.isFileContentMinified(file);
    }
}

