/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.service.JSLanguageServiceImpl;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfoBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.compilerService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceEvents;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class TypeScriptCompilerStartupActivity
implements StartupActivity {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerStartupActivity", "runActivity"));
        }
        if (project.isDefault() || project.isDisposed()) {
            return;
        }
        final TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        if (settings.isCompilerEnabled()) {
            TypeScriptCompilerStartupActivity.initAndGetService(project);
        }
        project.getMessageBus().connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/lang/typescript/compiler/TypeScriptCompilerStartupActivity$1", "after"));
                }
                if (project.isDisposed()) {
                    return;
                }
                if (!settings.isCompilerEnabledAndNeedTrackChanges() && !settings.isUseService()) {
                    return;
                }
                ArrayList filesToRemoveFromCompilerCache = null;
                ArrayList filesToCompile = null;
                boolean cleanAllCache = false;
                Collection changedConfigs = null;
                boolean hasCreateEvent = false;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file;
                    if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || (file = vFileEvent.getFile()) == null) continue;
                    if (!file.isDirectory()) {
                        FileType type = file.getFileType();
                        if (TypeScriptCompilerSettings.acceptFileType(type)) {
                            hasCreateEvent |= vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileCopyEvent;
                            JSLanguageServiceImpl.LOGGER.debug("event " + vFileEvent.getClass() + " file " + file.toString() + vFileEvent.getRequestor());
                            if (filesToRemoveFromCompilerCache == null) {
                                filesToRemoveFromCompilerCache = ContainerUtil.newArrayList();
                            }
                            if (filesToCompile == null) {
                                filesToCompile = ContainerUtil.newArrayList();
                            }
                            TypeScriptCompilerStartupActivity.processDeleteFile(vFileEvent, filesToRemoveFromCompilerCache);
                            TypeScriptCompilerStartupActivity.processRenamedFiles(vFileEvent, filesToRemoveFromCompilerCache);
                            TypeScriptCompilerStartupActivity.processMovedFiles(vFileEvent, filesToRemoveFromCompilerCache, filesToCompile);
                            TypeScriptCompilerStartupActivity.processCreateAndChangeFiles(vFileEvent, filesToCompile);
                            continue;
                        }
                        if (!TypeScriptCompilerConfigUtil.isConfig(file, type)) continue;
                        if (changedConfigs == null) {
                            changedConfigs = ContainerUtil.newHashSet();
                        }
                        changedConfigs.add(file);
                        continue;
                    }
                    cleanAllCache = true;
                }
                if (cleanAllCache || hasCreateEvent && TypeScriptCompilerStartupActivity.hasConfigParameter(settings)) {
                    TypeScriptCompilerStartupActivity.initAndGetService(project).sendCleanCommandToCompiler(new TypeScriptServiceCommandClean(true));
                } else if (!ContainerUtil.isEmpty(filesToRemoveFromCompilerCache)) {
                    TypeScriptCompilerStartupActivity.initAndGetService(project).sendCleanCommandToCompiler(new TypeScriptServiceCommandClean(false));
                }
                if (changedConfigs != null) {
                    for (VirtualFile virtualFile : changedConfigs) {
                        TypeScriptCompilerStartupActivity.initAndGetService(project).sendCleanCommandToCompiler(new TypeScriptServiceCommandClean(TypeScriptCompilerConfigUtil.getConfigIdByConfig(virtualFile)));
                    }
                }
                if (!ContainerUtil.isEmpty(filesToCompile)) {
                    TypeScriptCompilerStartupActivity.initAndGetService(project).addFileToCompileQueue(filesToCompile);
                }
            }
        });
        project.getMessageBus().connect((Disposable)project).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){
            private final AtomicLong modificationCounter = new AtomicLong();

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/typescript/compiler/TypeScriptCompilerStartupActivity$2", "fileOpened"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompilerStartupActivity$2", "fileOpened"));
                }
                if (!TypeScriptLanguageServiceUtil.isServiceAcceptable(project, file)) {
                    return;
                }
                TypeScriptLanguageServiceEvents eventsProcessor = TypeScriptLanguageServiceEvents.getService(project);
                eventsProcessor.onOpenEditor(file);
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/typescript/compiler/TypeScriptCompilerStartupActivity$2", "fileClosed"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptCompilerStartupActivity$2", "fileClosed"));
                }
                if (!TypeScriptLanguageServiceUtil.isServiceAcceptable(project, file)) {
                    return;
                }
                TypeScriptLanguageServiceEvents eventsProcessor = TypeScriptLanguageServiceEvents.getService(project);
                if (source.getAllEditors(file).length == 0) {
                    eventsProcessor.onCloseEditor(file, settings);
                }
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/typescript/compiler/TypeScriptCompilerStartupActivity$2", "selectionChanged"));
                }
                if (settings.isUseService()) {
                    return;
                }
                if (!settings.isCompilerEnabledAndNeedTrackChanges() || project.isDisposed()) {
                    return;
                }
                VirtualFile file = event.getNewFile();
                if (TypeScriptLanguageServiceUtil.shouldSkipProcessingWithScopeChecking(project, file)) {
                    return;
                }
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerStartupActivity$2", "lambda$selectionChanged$1"));
                    }
                    DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
                        long globalValue;
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptCompilerStartupActivity$2", "lambda$null$0"));
                        }
                        if (project.isDisposed()) {
                            return;
                        }
                        long currentNumber = this.modificationCounter.get();
                        if (currentNumber != (globalValue = PsiManager.getInstance((Project)project).getModificationTracker().getModificationCount()) && this.modificationCounter.compareAndSet(currentNumber, globalValue) && file.isValid()) {
                            TypeScriptCompilerService.getService(project).resetCaches();
                            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                            if (psiFile != null) {
                                DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
                            }
                        } else {
                            FileDocumentManager manager = FileDocumentManager.getInstance();
                            Document document = manager.getCachedDocument(file);
                            long timestamp = document == null ? file.getModificationCount() : document.getModificationStamp();
                            TypeScriptCompileInfoBuilder.FileHighlightingInfo files = TypeScriptCompileInfoBuilder.createInfoWithUnSavedFiles(project, file, document, timestamp);
                            TypeScriptCompilerService.getService(project).updateFilesAndGetErrors(files, true);
                        }
                    });
                });
            }
        });
    }

    private static boolean hasConfigParameter(@NotNull TypeScriptCompilerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/typescript/compiler/TypeScriptCompilerStartupActivity", "hasConfigParameter"));
        }
        if (settings.isUseConfigForCompiler() || settings.isUseService()) {
            return true;
        }
        String params = settings.getTypeScriptCompilerParams();
        if (StringUtil.isEmpty((String)params)) {
            return false;
        }
        for (String s : ParametersListUtil.parse((String)params)) {
            if (StringUtil.isEmpty((String)s) || !ArrayUtil.contains((String)s, (String[])TypeScriptCompilerSettings.CONFIG_PARAMS)) continue;
            return true;
        }
        return false;
    }

    private static void processDeleteFile(VFileEvent event, List<String> filesToRemove) {
        if (event instanceof VFileDeleteEvent) {
            VirtualFile file = event.getFile();
            assert (file != null);
            filesToRemove.add(TypeScriptCompilerConfigUtil.normalizeNameAndPath(file));
        }
    }

    private static void processMovedFiles(VFileEvent event, List<String> filesToRemove, List<VirtualFile> filesToCompile) {
        if (event instanceof VFileMoveEvent) {
            VFileMoveEvent moveEvent = (VFileMoveEvent)event;
            filesToRemove.add(TypeScriptCompilerService.normalizeNameAndPath(moveEvent.getOldPath()));
            filesToCompile.add(moveEvent.getFile());
        }
    }

    private static void processRenamedFiles(VFileEvent event, List<String> filesToRemove) {
        if (event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).getPropertyName().equals("name")) {
            filesToRemove.add(((VFilePropertyChangeEvent)event).getOldPath());
        }
    }

    private static void processCreateAndChangeFiles(VFileEvent event, List<VirtualFile> filesToCompile) {
        if (event instanceof VFileCreateEvent || event instanceof VFileCopyEvent || event instanceof VFileContentChangeEvent) {
            filesToCompile.add(event.getFile());
        }
    }

    private static TypeScriptCompilerService initAndGetService(Project project) {
        return TypeScriptCompilerService.getService(project);
    }
}

