/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptServiceHighlightingPass;
import com.intellij.lang.typescript.compiler.TypeScriptServiceSharedHighlightingStateHolder;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServiceHighlightingPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    private final TypeScriptServiceSharedHighlightingStateHolder mySharedCalcHolder;

    protected TypeScriptServiceHighlightingPassFactory(Project project, @NotNull TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        if (highlightingPassRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightingPassRegistrar", "com/intellij/lang/typescript/compiler/TypeScriptServiceHighlightingPassFactory", "<init>"));
        }
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, true, -1);
        this.mySharedCalcHolder = new TypeScriptServiceSharedHighlightingStateHolder();
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptServiceHighlightingPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/typescript/compiler/TypeScriptServiceHighlightingPassFactory", "createHighlightingPass"));
        }
        if (TypeScriptServiceHighlightingPassFactory.useService(file)) {
            return new TypeScriptServiceHighlightingPass(this.myProject, file, this.mySharedCalcHolder, editor);
        }
        return null;
    }

    private static boolean useService(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptServiceHighlightingPassFactory", "useService"));
        }
        if (!(file instanceof JSFile)) {
            return false;
        }
        if (!DialectDetector.isTypeScript((PsiElement)file)) {
            return false;
        }
        if (!TypeScriptCompilerSettings.useNewTypeScriptService(file.getProject())) {
            return false;
        }
        return TypeScriptLanguageServiceUtil.isFileCorrect(file.getVirtualFile());
    }

    public void disposeComponent() {
        super.disposeComponent();
        this.mySharedCalcHolder.reset();
    }
}

