/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileAllAction;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileCurrentAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptToolWindowProvider {
    private final JSLanguageServiceToolWindowManager myToolWindow;
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");

    @Nullable
    public static JSLanguageServiceToolWindowManager getToolWindow(Project project) {
        TypeScriptToolWindowProvider provider = (TypeScriptToolWindowProvider)ServiceManager.getService((Project)project, TypeScriptToolWindowProvider.class);
        return provider == null ? null : provider.getToolWindow();
    }

    public TypeScriptToolWindowProvider(final Project project) {
        AnAction restartCompilerAction = new AnAction(JSBundle.message((String)"typescript.service.action.restart", (Object[])new Object[0]), JSBundle.message((String)"typescript.service.action.restart", (Object[])new Object[0]), AllIcons.Javaee.UpdateRunningApplication){

            public void actionPerformed(AnActionEvent e) {
                TypeScriptCompilerService service = TypeScriptCompilerService.getService(project);
                if (service != null) {
                    service.restartService(false);
                }
            }
        };
        TypeScriptCompileCurrentAction typeScriptCompileCurrentAction = new TypeScriptCompileCurrentAction(){

            @Override
            protected VirtualFile[] getFiles(Project project, DataContext dataContext) {
                return FileEditorManager.getInstance((Project)project).getSelectedFiles();
            }

            @Override
            protected void logErrors(JSLanguageServiceToolWindowManager manager, Collection<JSLanguageServiceAnnotationResult> infos) {
                manager.logCurrentErrors((List<JSLanguageServiceAnnotationResult>)ContainerUtil.immutableList((List)ContainerUtil.newArrayList(infos)), true);
            }
        };
        this.myToolWindow = new JSLanguageServiceToolWindowManager(project, "TypeScript", "reference.tool.windows.typescript", JavaScriptLanguageIcons.Typescript.TypeScript_Compiler, new AnAction[]{typeScriptCompileCurrentAction, new TypeScriptCompileAllAction(), restartCompilerAction}){

            @Override
            @NotNull
            protected ConsoleViewImpl createConsole() {
                ConsoleViewImpl consoleViewImpl = new ConsoleViewImpl(this.myProject, GlobalSearchScope.allScope((Project)this.myProject), true, false){

                    public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
                        if (s == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/lang/typescript/compiler/TypeScriptToolWindowProvider$3$1", "print"));
                        }
                        if (contentType == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/lang/typescript/compiler/TypeScriptToolWindowProvider$3$1", "print"));
                        }
                        if (contentType == ConsoleViewContentType.ERROR_OUTPUT) {
                            super.print(s, ConsoleViewContentType.NORMAL_OUTPUT);
                        } else if (contentType == ConsoleViewContentType.NORMAL_OUTPUT && JSLanguageServiceToolWindowManager.LOGGER.isDebugEnabled()) {
                            if (s.length() > 1000) {
                                s = s.substring(0, 1000) + "............(truncated)\n";
                            }
                            super.print(s, ConsoleViewContentType.NORMAL_OUTPUT);
                        }
                    }
                };
                if (consoleViewImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptToolWindowProvider$3", "createConsole"));
                }
                return consoleViewImpl;
            }
        };
        Disposer.register((Disposable)project, (Disposable)this.myToolWindow);
    }

    public JSLanguageServiceToolWindowManager getToolWindow() {
        return this.myToolWindow;
    }
}

