/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfoBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.compilerService.TypeScriptCompilerServiceImpl;
import com.intellij.lang.typescript.compiler.compilerService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileAllAction
extends AnAction {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");
    private TypeScriptServiceCommandClean myCommandClean = new TypeScriptServiceCommandClean(false);

    public TypeScriptCompileAllAction() {
        super(JSBundle.message((String)"typescript.compiler.action.compile.all", (Object[])new Object[0]), JSBundle.message((String)"typescript.compiler.action.compile.all.description", (Object[])new Object[0]), JavaScriptLanguageIcons.Typescript.CompileCurrentFile2);
    }

    public TypeScriptCompileAllAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    @Nullable
    protected VirtualFile[] getFiles(Project project, @Nullable DataContext context) {
        return null;
    }

    public synchronized void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        DataContext context = e.getDataContext();
        this.runCompile(project, context);
    }

    public void runCompile(final @NotNull Project project, @Nullable DataContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "runCompile"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        final VirtualFile[] files = this.getFiles(project, context);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Compiling TypeScript Files", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction$1", "run"));
                }
                try {
                    indicator.checkCanceled();
                    TypeScriptCompileAllAction.this.runCompile(indicator, project, files);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    TypeScriptCompileAllAction.this.release();
                }
            }
        });
    }

    protected void release() {
    }

    protected boolean canSkipIterateAll() {
        return true;
    }

    protected void runCompile(@NotNull ProgressIndicator indicator, Project project, @Nullable VirtualFile[] files) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "runCompile"));
        }
        LinkedHashSet infos = ContainerUtil.newLinkedHashSet();
        TypeScriptCompilerService compilerService = TypeScriptCompilerService.getService(project);
        GlobalSearchScope scope = TypeScriptCompilerConfigUtil.getCompileScope(project);
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        TypeScriptCompileAllAction.updateServerFiles(indicator, project, compilerService);
        if (this.canSkipIterateAll() && settings.isUseConfigForCompiler()) {
            this.processConfigs(project, indicator, compilerService, infos, scope);
            indicator.checkCanceled();
            this.logErrors(infos, compilerService);
            return;
        }
        boolean mainOnly = settings.isUseMainFile();
        HashSet processedFiles = ContainerUtil.newHashSet();
        this.iterateFilesForCompile(project, indicator, (Processor<VirtualFile>)((Processor)file -> {
            String path;
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "lambda$runCompile$0"));
            }
            indicator.checkCanceled();
            if (!TypeScriptCompilerSettings.acceptFileType(file.getFileType()) || !scope.accept(file) || JSLibraryUtil.isProbableLibraryFile(file)) {
                return true;
            }
            if (processedFiles.size() > 0 && (path = file.getCanonicalPath()) != null) {
                String independentName = FileUtil.toSystemIndependentName((String)path);
                if (processedFiles.contains(independentName)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Action Compile: skip compile for " + file.getName());
                    }
                    return true;
                }
                if (mainOnly) {
                    infos.add(new JSLanguageServiceAnnotationResult(JSBundle.message((String)"typescript.compiler.action.no.compile.message", (Object[])new Object[0]), path, "warning", 0, 0, 0, 0));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Action Compile: skip and warning no compile for " + file.getName());
                    }
                    return true;
                }
            }
            return this.compileFile(project, (VirtualFile)file, indicator, compilerService, infos, processedFiles);
        }), files);
        indicator.checkCanceled();
        this.logErrors(infos, compilerService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateServerFiles(ProgressIndicator indicator, Project project, TypeScriptCompilerService compilerService) {
        JSLanguageServiceUpdateContext context;
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            context = TypeScriptCompileInfoBuilder.createUpdateContext(project);
        }
        finally {
            token.finish();
        }
        indicator.checkCanceled();
        compilerService.update(context);
        indicator.checkCanceled();
    }

    protected void logErrors(Collection<JSLanguageServiceAnnotationResult> infos, TypeScriptCompilerService compilerService) {
        JSLanguageServiceToolWindowManager manager = compilerService.getToolWindowManager();
        if (manager != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                manager.init();
                this.logErrors(manager, infos);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processConfigs(Project project, ProgressIndicator indicator, TypeScriptCompilerService service, Collection<JSLanguageServiceAnnotationResult> infos, GlobalSearchScope scope) {
        Collection<TypeScriptConfig> configs;
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            configs = this.getConfigsForProcessing(project, service);
        }
        finally {
            token.finish();
        }
        for (TypeScriptConfig config : configs) {
            if (scope.contains(config.getConfigFile()) && !this.compileConfig(project, indicator, service, config, infos)) break;
        }
    }

    @NotNull
    protected Collection<TypeScriptConfig> getConfigsForProcessing(Project project, TypeScriptCompilerService service) {
        Collection<TypeScriptConfig> collection = TypeScriptConfigService.Provider.getConfigFiles(project);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "getConfigsForProcessing"));
        }
        return collection;
    }

    protected boolean compileConfig(Project project, ProgressIndicator indicator, TypeScriptCompilerService service, TypeScriptConfig config, Collection<JSLanguageServiceAnnotationResult> infos) {
        indicator.checkCanceled();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Action Compile: do compile for " + config.getConfigFile().getName());
        }
        try {
            JSLanguageServiceResultContainer container;
            this.cleanCompilerCache(indicator, service);
            indicator.setText2(JSBundle.message((String)"typescript.compiler.action.compile.all.compile.config", (Object[])new Object[]{config.getConfigFile().getPath()}));
            Future<JSLanguageServiceResultContainer> compile = service.compileConfigProjectAndGetErrors(config);
            if (compile != null && (container = compile.get(60L, TimeUnit.SECONDS)) != null) {
                infos.addAll((Collection<JSLanguageServiceAnnotationResult>)container.getCompiledResults());
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage(), (Throwable)e);
            indicator.cancel();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void iterateFilesForCompile(Project project, ProgressIndicator indicator, Processor<VirtualFile> processor, @Nullable VirtualFile[] files) {
        GlobalSearchScope scope = TypeScriptCompilerConfigUtil.getCompileScope(project);
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        ArrayList filesToIterate = ContainerUtil.newArrayList();
        try {
            for (FileType type : TypeScriptUtil.TYPESCRIPT_FILE_TYPES) {
                filesToIterate.addAll(FileTypeIndex.getFiles((FileType)type, (GlobalSearchScope)scope));
            }
        }
        finally {
            token.finish();
        }
        for (VirtualFile file : filesToIterate) {
            if (TypeScriptUtil.isUnderNodeModules(file, project) || processor.process((Object)file)) continue;
            return;
        }
    }

    protected void logErrors(JSLanguageServiceToolWindowManager manager, Collection<JSLanguageServiceAnnotationResult> infos) {
        manager.logProjectErrors((ImmutableList<JSLanguageServiceAnnotationResult>)ContainerUtil.immutableList((List)ContainerUtil.newArrayList(infos)), true);
    }

    private boolean compileFile(Project project, VirtualFile file, @NotNull ProgressIndicator indicator, TypeScriptCompilerService service, Collection<JSLanguageServiceAnnotationResult> infos, Collection<String> processedFiles) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "compileFile"));
        }
        indicator.checkCanceled();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Action Compile: do compile for " + file.getName());
        }
        this.cleanCompilerCache(indicator, service);
        indicator.setText2(JSBundle.message((String)"typescript.compiler.action.compile.all.compile", (Object[])new Object[]{file.getName()}));
        try {
            Future<JSLanguageServiceResultContainer> compile = service.compileFileAndGetErrors(file);
            if (compile != null) {
                JSLanguageServiceResultContainer container = compile.get(60L, TimeUnit.SECONDS);
                infos.addAll((Collection<JSLanguageServiceAnnotationResult>)container.getCompiledResults());
                List<String> compiledFiles = container.getCompiledFiles();
                if (compiledFiles != null) {
                    for (String s : compiledFiles) {
                        if (StringUtil.isEmpty((String)s)) continue;
                        processedFiles.add(FileUtil.toSystemIndependentName((String)s));
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage(), (Throwable)e);
            indicator.checkCanceled();
            return false;
        }
    }

    protected void cleanCompilerCache(@NotNull ProgressIndicator indicator, TypeScriptCompilerService service) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction", "cleanCompilerCache"));
        }
        indicator.setText2(JSBundle.message((String)"typescript.compiler.action.compile.all.clean", (Object[])new Object[0]));
        if (service instanceof TypeScriptCompilerServiceImpl) {
            service.sendCleanCommandToCompiler(this.myCommandClean);
        }
    }
}

