/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action.before;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileAllAction;
import com.intellij.lang.typescript.compiler.action.before.TypeScriptCompileBeforeRunTask;
import com.intellij.lang.typescript.compiler.action.before.TypeScriptCompileBeforeTaskDialog;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileBeforeRunTaskProvider
extends BeforeRunTaskProvider<TypeScriptCompileBeforeRunTask> {
    public static final Key<TypeScriptCompileBeforeRunTask> ID = Key.create((String)"TypeScript.Before.Run");

    public Key<TypeScriptCompileBeforeRunTask> getId() {
        return ID;
    }

    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.Typescript.CompileCurrentFile2;
    }

    public String getName() {
        return JSBundle.message((String)"typescript.compiler.before.run", (Object[])new Object[0]);
    }

    public String getDescription(TypeScriptCompileBeforeRunTask task) {
        return this.getName();
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public TypeScriptCompileBeforeRunTask createTask(RunConfiguration runConfiguration) {
        Project project = runConfiguration.getProject();
        if (project == null || project.isDefault()) {
            return null;
        }
        if (!TypeScriptCompilerSettings.getSettings(project).isCompilerEnabled()) {
            return null;
        }
        return new TypeScriptCompileBeforeRunTask();
    }

    public boolean configureTask(RunConfiguration runConfiguration, TypeScriptCompileBeforeRunTask task) {
        Project project = runConfiguration.getProject();
        TypeScriptCompileBeforeTaskDialog dialog = new TypeScriptCompileBeforeTaskDialog(project, task.isFailOnError());
        if (dialog.showAndGet()) {
            task.setFailOnError(dialog.isFailOnError());
            return true;
        }
        return false;
    }

    public boolean canExecuteTask(RunConfiguration configuration, TypeScriptCompileBeforeRunTask task) {
        return true;
    }

    public boolean executeTask(final DataContext context, RunConfiguration configuration, ExecutionEnvironment env, TypeScriptCompileBeforeRunTask task) {
        final Project project = configuration.getProject();
        if (!TypeScriptCompilerSettings.getSettings(project).isCompilerEnabled()) {
            return true;
        }
        final Ref hasErrors = Ref.create((Object)false);
        final Semaphore targetDone = new Semaphore();
        targetDone.down();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                new TypeScriptCompileAllAction(){

                    @Override
                    @NotNull
                    protected Collection<TypeScriptConfig> getConfigsForProcessing(Project project, TypeScriptCompilerService service) {
                        Collection<TypeScriptConfig> toProcess = super.getConfigsForProcessing(project, service);
                        GlobalSearchScope scope = TypeScriptCompilerConfigUtil.getCompileScope(project);
                        Collection collection = toProcess.stream().filter(config -> config.isCompileOnSave() && scope.accept(config.getConfigFile())).collect(Collectors.toList());
                        if (collection == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/action/before/TypeScriptCompileBeforeRunTaskProvider$1$1", "getConfigsForProcessing"));
                        }
                        return collection;
                    }

                    @Override
                    protected void release() {
                        targetDone.up();
                    }

                    @Override
                    protected void cleanCompilerCache(@NotNull ProgressIndicator indicator, TypeScriptCompilerService service) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/before/TypeScriptCompileBeforeRunTaskProvider$1$1", "cleanCompilerCache"));
                        }
                    }

                    @Override
                    protected void logErrors(JSLanguageServiceToolWindowManager manager, Collection<JSLanguageServiceAnnotationResult> infos) {
                        manager.logProjectErrors((ImmutableList<JSLanguageServiceAnnotationResult>)ContainerUtil.immutableList((List)ContainerUtil.newArrayList(infos)), (Boolean)hasErrors.get());
                    }

                    @Override
                    protected void logErrors(Collection<JSLanguageServiceAnnotationResult> infos, TypeScriptCompilerService compilerService) {
                        if (!infos.isEmpty()) {
                            for (JSLanguageServiceAnnotationResult info : infos) {
                                if (!"error".equals(info.getCategory())) continue;
                                hasErrors.set((Object)true);
                                break;
                            }
                        }
                        super.logErrors(infos, compilerService);
                    }
                }.runCompile(project, context);
            }
        }, ModalityState.NON_MODAL);
        targetDone.waitFor(TimeUnit.SECONDS.toMillis(40L));
        return !task.isFailOnError() || (Boolean)hasErrors.get() == false;
    }
}

