/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.compilerService;

import com.google.gson.JsonObject;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandResultProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfoBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.compilerService.TypeScriptLanguageServiceCompileResultProcessor;
import com.intellij.lang.typescript.compiler.compilerService.protocol.TypeScriptLanguageServiceCacheImpl;
import com.intellij.lang.typescript.compiler.compilerService.protocol.TypeScriptServiceSocketProtocol;
import com.intellij.lang.typescript.compiler.compilerService.protocol.commands.TypeScriptLanguageServiceUpdateFilesCommandOld;
import com.intellij.lang.typescript.compiler.compilerService.protocol.commands.TypeScriptServiceAddConfigCommand;
import com.intellij.lang.typescript.compiler.compilerService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class TypeScriptCompilerServiceImpl
extends TypeScriptCompilerService {
    @NotNull
    private final Alarm myCompilerQueueAlarm;
    private Set<VirtualFile> myQueueFiles;
    @NotNull
    private Set<String> myConfigStartedCompilerId;
    @NotNull
    private Set<String> myDiscoveredCompilerId;

    public TypeScriptCompilerServiceImpl(final @NotNull Project project, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl", "<init>"));
        }
        super(project, settings);
        this.myQueueFiles = ContainerUtil.newHashSet();
        this.myConfigStartedCompilerId = ContainerUtil.newConcurrentSet();
        this.myDiscoveredCompilerId = ContainerUtil.newConcurrentSet();
        this.myCompilerQueueAlarm = new Alarm(Alarm.ThreadToUse.OWN_THREAD, (Disposable)this);
        new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet toProcess;
                if (TypeScriptCompilerServiceImpl.this.myCompilerQueueAlarm.isDisposed() || TypeScriptCompilerServiceImpl.this.myProject.isDisposed()) {
                    return;
                }
                Object object = TypeScriptCompilerServiceImpl.this.myLock;
                synchronized (object) {
                    if (TypeScriptCompilerServiceImpl.this.myQueueFiles == null) {
                        return;
                    }
                    toProcess = ContainerUtil.newHashSet((Iterable)TypeScriptCompilerServiceImpl.this.myQueueFiles);
                    TypeScriptCompilerServiceImpl.this.myQueueFiles.clear();
                }
                if (!toProcess.isEmpty()) {
                    Ref compilerIdToFileRef = Ref.create();
                    DumbService.getInstance((Project)TypeScriptCompilerServiceImpl.this.myProject).runReadActionInSmartMode(() -> compilerIdToFileRef.set((Object)TypeScriptCompilerServiceImpl.this.splitByCompilerId(toProcess)));
                    MultiMap compilerIdToFile = (MultiMap)compilerIdToFileRef.get();
                    for (Map.Entry compilerIdToFiles : compilerIdToFile.entrySet()) {
                        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
                        Collection files = (Collection)compilerIdToFiles.getValue();
                        String compilerId = (String)compilerIdToFiles.getKey();
                        LinkedHashMap fileToTimeStampWithModule = ContainerUtil.newLinkedHashMap();
                        LinkedHashMap fileToTimeStampWithoutModule = ContainerUtil.newLinkedHashMap();
                        try {
                            for (VirtualFile virtualFile : files) {
                                if (!virtualFile.isInLocalFileSystem() || !virtualFile.isValid() || !TypeScriptCompilerServiceImpl.this.getScope().accept(virtualFile) || null != virtualFile.getUserData(JSLanguageService.GENERATED_FILE_MARKER)) continue;
                                Pair<String, String> moduleInfo = TypeScriptCompileInfoBuilder.getModuleInfoIfNeed(virtualFile, project);
                                Map mapToProcess = moduleInfo != null ? (Map)ContainerUtil.getOrCreate((Map)fileToTimeStampWithModule, moduleInfo, (Factory)new Factory<Map<String, Long>>(){

                                    public Map<String, Long> create() {
                                        return ContainerUtil.newLinkedHashMap();
                                    }
                                }) : fileToTimeStampWithoutModule;
                                mapToProcess.put(TypeScriptCompilerConfigUtil.normalizeNameAndPath(virtualFile), virtualFile.getModificationStamp());
                            }
                        }
                        finally {
                            token.finish();
                        }
                        for (Map.Entry entry : fileToTimeStampWithModule.entrySet()) {
                            Map value = (Map)entry.getValue();
                            if (value == null || value.size() <= 0) continue;
                            TypeScriptCompilerServiceImpl.this.compile(new TypeScriptLanguageServiceUpdateFilesCommandOld(value, null, false, true, (Pair<String, String>)((Pair)entry.getKey()), compilerId));
                        }
                        TypeScriptCompilerService.LOGGER.debug("Compile from queue");
                        if (fileToTimeStampWithoutModule.size() <= 0) continue;
                        TypeScriptCompilerServiceImpl.this.compile(new TypeScriptLanguageServiceUpdateFilesCommandOld(fileToTimeStampWithoutModule, null, false, true, null, compilerId));
                    }
                }
                if (TypeScriptCompilerServiceImpl.this.myCompilerQueueAlarm.isDisposed() || TypeScriptCompilerServiceImpl.this.myProject.isDisposed()) {
                    return;
                }
                TypeScriptCompilerServiceImpl.this.myCompilerQueueAlarm.addRequest((Runnable)this, 2000);
            }
        }.run();
    }

    @Override
    @NotNull
    protected JSLanguageServiceImpl createService() {
        JSLanguageServiceImpl jSLanguageServiceImpl = new JSLanguageServiceImpl(this.myProject, new TypeScriptServiceSocketProtocol(this.myProject, this.mySettings), this.myToolWindowManager, new TypeScriptLanguageServiceCacheImpl());
        if (jSLanguageServiceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl", "createService"));
        }
        return jSLanguageServiceImpl;
    }

    @NotNull
    private MultiMap<String, VirtualFile> splitByCompilerId(@NotNull Set<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl", "splitByCompilerId"));
        }
        MultiMap map = MultiMap.create();
        for (VirtualFile file : files) {
            map.putValue((Object)this.getCompilerId(file), (Object)file);
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl", "splitByCompilerId"));
        }
        return multiMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFileToCompileQueue(@NotNull List<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl", "addFileToCompileQueue"));
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myQueueFiles != null) {
                this.myQueueFiles.addAll(files);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Future<JSLanguageServiceResultContainer> compile(@NotNull JSLanguageServiceCacheableCommand info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl", "compile"));
        }
        JSLanguageService compiler = this.getProcess();
        if (compiler == null) {
            return null;
        }
        String id = ((TypeScriptLanguageServiceUpdateFilesCommandOld)info).getCompilerId();
        if (!id.equals("default")) {
            Object object = this.myLock;
            synchronized (object) {
                Set<String> ids = this.myConfigStartedCompilerId;
                if (!ids.contains(id)) {
                    this.startCompilerForConfig(id, compiler);
                }
            }
        }
        return compiler.executeWithCache(info, new TypeScriptLanguageServiceCompileResultProcessor(this.myProject, this.myToolWindowManager));
    }

    @Override
    @Nullable
    public Future<List<JSLanguageServiceAnnotationResult>> updateFilesAndGetErrors(@NotNull TypeScriptCompileInfoBuilder.FileHighlightingInfo info, boolean useCache) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl", "updateFilesAndGetErrors"));
        }
        VirtualFile file = info.file;
        String path = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        Map<String, Document> contents = info.updateContext.contents;
        TypeScriptLanguageServiceUpdateFilesCommandOld command = new TypeScriptLanguageServiceUpdateFilesCommandOld(ContainerUtil.newHashMap((Pair)Pair.create((Object)path, (Object)info.fileTimestamp), (Pair[])new Pair[0]), contents, true, useCache, info.moduleInfo, info.compilerId);
        final Future<JSLanguageServiceResultContainer> compile = this.compile(command);
        if (compile == null) {
            return null;
        }
        return new Future<List<JSLanguageServiceAnnotationResult>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return compile.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return compile.isCancelled();
            }

            @Override
            public boolean isDone() {
                return compile.isDone();
            }

            @Override
            public List<JSLanguageServiceAnnotationResult> get() throws InterruptedException, ExecutionException {
                JSLanguageServiceResultContainer container = (JSLanguageServiceResultContainer)compile.get();
                return container == null ? null : container.getCompiledResults();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public List<JSLanguageServiceAnnotationResult> get(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                void unit;
                if (timeUnit == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl$2", "get"));
                }
                JSLanguageServiceResultContainer container = (JSLanguageServiceResultContainer)compile.get(timeout, (TimeUnit)unit);
                return container == null ? null : container.getCompiledResults();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCompilerForConfig(final @NotNull String compilerId, final @NotNull JSLanguageService compiler) {
        if (compilerId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerId", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl", "startCompilerForConfig"));
        }
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl", "startCompilerForConfig"));
        }
        JSLanguageServiceCommandResultProcessor<Void> processor = new JSLanguageServiceCommandResultProcessor<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                String errorText;
                if (serviceObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl$3", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl$3", "process"));
                }
                JsonObject object = answer.getElement();
                String string = errorText = object.has("error") ? object.get("error").getAsString() : null;
                if (errorText != null) {
                    Object object2 = TypeScriptCompilerServiceImpl.this.myLock;
                    synchronized (object2) {
                        TypeScriptCompilerServiceImpl.this.myConfigStartedCompilerId.remove(compilerId);
                    }
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (compilerId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerId", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl$3", "lambda$process$0"));
                    }
                    if (errorText != null) {
                        JSLanguageServiceToolWindowManager manager = TypeScriptCompilerServiceImpl.this.myToolWindowManager;
                        if (manager != null) {
                            manager.logCurrentErrors((List<JSLanguageServiceAnnotationResult>)JSLanguageServiceAnnotationResult.buildError(errorText), false);
                        }
                    } else {
                        TypeScriptConfig config = TypeScriptCompilerConfigUtil.getConfigByCompilerId(TypeScriptCompilerServiceImpl.this.myProject, compilerId);
                        if (config != null) {
                            boolean shouldLogDiscovered;
                            Object object = TypeScriptCompilerServiceImpl.this.myLock;
                            synchronized (object) {
                                shouldLogDiscovered = TypeScriptCompilerServiceImpl.this.myDiscoveredCompilerId.add(compilerId);
                            }
                            if (shouldLogDiscovered) {
                                TypeScriptCompilerServiceImpl.this.logConfigDiscovered(config.getConfigFile());
                            }
                        }
                    }
                }, o -> {
                    if (compiler == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl$3", "lambda$process$1"));
                    }
                    return compiler.getState() == JSLanguageService.State.DISPOSED;
                });
                return null;
            }
        };
        Object object = this.myLock;
        synchronized (object) {
            this.myConfigStartedCompilerId.add(compilerId);
        }
        compiler.execute(new TypeScriptServiceAddConfigCommand(compilerId, TypeScriptCompilerConfigUtil.getConfigDirectoryByCompilerId(compilerId)), processor);
    }

    private void logConfigDiscovered(final VirtualFile file) {
        String path = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)this.myProject.getBaseDir());
        Notifications.Bus.notify((Notification)new Notification("TypeScript Compiler Info", "TypeScript Compiler", "Discovered tsconfig.json: <a href='PATH'>" + path + "</a>", NotificationType.INFORMATION, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl$4", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl$4", "hyperlinkUpdate"));
                }
                if (TypeScriptCompilerServiceImpl.this.myProject.isDisposed()) {
                    return;
                }
                if ("PATH".equals(event.getDescription()) && file.isValid()) {
                    new OpenFileDescriptor(TypeScriptCompilerServiceImpl.this.myProject, file, 0).navigate(true);
                }
            }
        }), (Project)this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        super.dispose();
        Object object = this.myLock;
        synchronized (object) {
            this.myQueueFiles = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendCleanCommandToCompiler(@NotNull TypeScriptServiceCommandClean command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl", "sendCleanCommandToCompiler"));
        }
        JSLanguageService compiler = this.getProcess();
        if (compiler == null) {
            return;
        }
        String id = command.getCompilerId();
        if (id == null && !command.isAll()) {
            compiler.execute(command, TypeScriptCompilerServiceImpl.getResetCachesProcessor(compiler));
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (command.isAll()) {
                this.myConfigStartedCompilerId.clear();
            } else {
                if (!this.myConfigStartedCompilerId.contains(id)) {
                    return;
                }
                this.myConfigStartedCompilerId.remove(id);
            }
            compiler.execute(command, TypeScriptCompilerServiceImpl.getResetCachesProcessor(compiler));
        }
    }

    @Override
    protected void cleanLocalState() {
        super.cleanLocalState();
        this.myConfigStartedCompilerId.clear();
        this.myDiscoveredCompilerId.clear();
    }

    @Override
    @Nullable
    public Future<Boolean> update(JSLanguageServiceUpdateContext context) {
        return null;
    }

    @Override
    @Nullable
    public Future<JSLanguageServiceResultContainer> compileFileAndGetErrors(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl", "compileFileAndGetErrors"));
        }
        JSLanguageServiceCacheableCommand info = (JSLanguageServiceCacheableCommand)ReadAction.compute(() -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl", "lambda$compileFileAndGetErrors$0"));
            }
            return TypeScriptCompileInfoBuilder.createSimpleCompilerInput(this.myProject, file);
        });
        return this.compile(info);
    }

    @Override
    @Nullable
    public Future<JSLanguageServiceResultContainer> compileConfigProjectAndGetErrors(@NotNull TypeScriptConfig config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/typescript/compiler/compilerService/TypeScriptCompilerServiceImpl", "compileConfigProjectAndGetErrors"));
        }
        TypeScriptLanguageServiceUpdateFilesCommandOld info = TypeScriptCompileInfoBuilder.createCompilerInputForConfig(this.myProject, config);
        return this.compile(info);
    }
}

