/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.compilerService.protocol;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.macro.Macro;
import com.intellij.lang.javascript.service.JSLanguageServiceImpl;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.protocol.TypeScriptServiceProtocolBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.json.JsonObjectDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.NettyKt;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;

@Deprecated
public class TypeScriptServiceSocketProtocol
extends TypeScriptServiceProtocolBase {
    @Nullable
    private Channel myChannel;
    private final ConcurrentMap<String, JSLanguageServiceAnswerConsumer> myCallbacks = ContainerUtil.newConcurrentMap();

    public TypeScriptServiceSocketProtocol(Project project, TypeScriptCompilerSettings settings) {
        super(project, settings);
    }

    @Override
    @NotNull
    protected String getEntryPointFile() {
        if ("bridge.js" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/compilerService/protocol/TypeScriptServiceSocketProtocol", "getEntryPointFile"));
        }
        return "bridge.js";
    }

    @Override
    public ProcessHandler connect() throws Exception {
        String localHostString;
        int socketPort = NetUtils.findAvailableSocketPort();
        GeneralCommandLine line = this.createCommandLine(socketPort, localHostString = NetUtils.getLocalHostString());
        OSProcessHandler processHandler = this.createProcessHandler(line);
        if (processHandler == null) {
            return null;
        }
        Bootstrap bootstrap = NettyKt.oioClientBootstrap();
        LOGGER.debug("Initialize Channel connection");
        final CountDownLatch latch = new CountDownLatch(1);
        bootstrap.handler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel ch) throws Exception {
                try {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new ChannelRegistrar(), new JsonObjectDecoder(0x3200000), new StringDecoder(CharsetUtil.UTF_8), new SimpleChannelInboundHandlerAdapter<String>(){

                        protected void messageReceived(ChannelHandlerContext context, String message) throws Exception {
                            String command;
                            long timeMillis = System.currentTimeMillis();
                            JSLanguageServiceAnswer compilerMessage = new JSLanguageServiceAnswer(message);
                            try {
                                command = compilerMessage.getCommand();
                            }
                            catch (RuntimeException e) {
                                JSLanguageServiceImpl.LOGGER.debug("Message: " + compilerMessage.toString(), (Throwable)e);
                                throw e;
                            }
                            JSLanguageServiceAnswerConsumer consumer = (JSLanguageServiceAnswerConsumer)TypeScriptServiceSocketProtocol.this.myCallbacks.remove(command);
                            if (consumer != null) {
                                consumer.consume(compilerMessage);
                                JSLanguageServiceImpl.LOGGER.debug("Consume end at " + (System.currentTimeMillis() - timeMillis));
                                return;
                            }
                            TypeScriptServiceSocketProtocol.this.myDefaultConsumer.consume(compilerMessage);
                        }
                    }, ChannelExceptionHandler.getInstance()});
                    pipeline.addLast(new ChannelHandler[]{new StringEncoder(StandardCharsets.UTF_8)});
                    JSLanguageServiceImpl.LOGGER.debug("INIT HANDLER");
                }
                finally {
                    latch.countDown();
                }
            }
        });
        try {
            InetSocketAddress address = new InetSocketAddress(localHostString, socketPort);
            JSLanguageServiceImpl.LOGGER.debug(address.toString());
            this.myChannel = NettyKt.connect((Bootstrap)bootstrap, (InetSocketAddress)address);
            if (this.myChannel == null) {
                throw new RuntimeException("Cannot establish connection to compiler server");
            }
            LOGGER.debug("Start waiting channel connection");
            latch.await(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            processHandler.destroyProcess();
            throw e;
        }
        LOGGER.debug("End waiting channel connection");
        return processHandler;
    }

    @Nullable
    private GeneralCommandLine createCommandLine(int socketPort, String localHostString) throws Exception {
        GeneralCommandLine commandLine = this.createCommandLine();
        if (commandLine == null) {
            return null;
        }
        commandLine.addParameter(this.getServicePathParam());
        commandLine.addParameters(new String[]{TypeScriptServiceSocketProtocol.getPortParam(socketPort), TypeScriptServiceSocketProtocol.getHostParam(localHostString)});
        if (this.mySettings.isUseConfigForCompiler()) {
            TypeScriptServiceSocketProtocol.setSkipForTSConfig(commandLine);
        } else {
            this.setManualOptions(commandLine);
        }
        return commandLine;
    }

    private static String getPortParam(int socketPort) {
        return "-port=" + socketPort;
    }

    private static String getHostParam(String host) {
        return "-host=" + host;
    }

    private void write(String data) {
        if (this.myChannel != null) {
            this.myChannel.write((Object)data);
            this.myChannel.flush();
        }
    }

    @Override
    public Object sendCommand(@NotNull JSLanguageServiceCommand commandObject, @NotNull String jsonData, @Nullable JSLanguageServiceAnswerConsumer resultConsumer) {
        if (commandObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandObject", "com/intellij/lang/typescript/compiler/compilerService/protocol/TypeScriptServiceSocketProtocol", "sendCommand"));
        }
        if (jsonData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonData", "com/intellij/lang/typescript/compiler/compilerService/protocol/TypeScriptServiceSocketProtocol", "sendCommand"));
        }
        String command = commandObject.getCommand();
        if (resultConsumer != null) {
            this.myCallbacks.put(command, resultConsumer);
        }
        this.write(jsonData + '\n' + this.toSystemCommand("end " + command) + '\n');
        return command;
    }

    @Override
    public void cancelCommand(Object cancellationToken) {
        if (cancellationToken == null) {
            return;
        }
        this.myCallbacks.remove(cancellationToken);
    }

    protected String getServicePathParam() {
        return "-servicePath=" + this.getServicePath();
    }

    public void dispose() {
        try {
            if (this.myChannel != null) {
                NettyKt.closeAndShutdownEventLoop((Channel)this.myChannel);
                this.myChannel = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setManualOptions(GeneralCommandLine commandLine) throws Macro.ExecutionCancelledException {
        boolean hasMainFile = this.hasMainFile();
        if (hasMainFile) {
            String mainFilePath = FileUtil.toSystemDependentName((String)this.mySettings.getMainFilePath());
            commandLine.addParameter("-mainFilePath=" + mainFilePath);
        }
        String outFile = null;
        if (this.hasOutputDirectory()) {
            commandLine.addParameter(this.getProjectPath());
            Pair<String, String> pair = this.getOutInformation(hasMainFile);
            outFile = (String)pair.first;
            if (pair.second != null) {
                commandLine.addParameter(TypeScriptServiceSocketProtocol.getOutPath((String)pair.second));
            }
        }
        if (this.mySettings.isGenerateSourceMap()) {
            commandLine.addParameter("--sourceMap");
        }
        boolean existsCommandLineOutParam = false;
        if (null != this.mySettings.getTypeScriptCompilerParams()) {
            String[] parse = ParametersList.parse((String)this.mySettings.getTypeScriptCompilerParams());
            existsCommandLineOutParam = this.checkExistsCommandLineOut(parse);
            commandLine.addParameters(parse);
        }
        if (!StringUtil.isEmpty((String)outFile) && !existsCommandLineOutParam) {
            commandLine.addParameter("-out");
            commandLine.addParameter(FileUtilRt.toSystemDependentName((String)outFile));
        }
    }

    private String getProjectPath() {
        return "-projectPath=" + this.getProjectPathString();
    }

    private static String getOutPath(String path) {
        return "-outPathTemplate=" + path;
    }
}

