/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceUtil {
    public static final String TYPESCRIPT_MODULE_NAME = "typescript";
    public static final String LIB_DIRECTORY = "lib";

    public static boolean isServiceAcceptable(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "isServiceAcceptable"));
        }
        return TypeScriptCompilerSettings.useNewTypeScriptService(project) && !project.isDisposed() && !TypeScriptLanguageServiceUtil.shouldSkipProcessing(project, file);
    }

    public static boolean useServiceCompletion(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "useServiceCompletion"));
        }
        return TypeScriptCompilerSettings.useNewTypeScriptService(project) && TypeScriptLanguageServiceUtil.isFileCorrect(file) && TypeScriptCompilerSettings.getSettings(project).isUseServiceCompletion();
    }

    public static boolean shouldSkipProcessing(@NotNull Project project, VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "shouldSkipProcessing"));
        }
        return !TypeScriptLanguageServiceUtil.isFileCorrect(file) || !TypeScriptCompilerSettings.acceptFileType(file.getFileType());
    }

    public static boolean isFileCorrect(VirtualFile file) {
        return file != null && file.isInLocalFileSystem() && file.isValid() && null == file.getUserData(JSLanguageService.GENERATED_FILE_MARKER);
    }

    @Contract(value="_,null -> true")
    public static boolean shouldSkipProcessingWithScopeChecking(@NotNull Project project, VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "shouldSkipProcessingWithScopeChecking"));
        }
        return TypeScriptLanguageServiceUtil.shouldSkipProcessing(project, file) || !TypeScriptCompilerConfigUtil.getCompileScope(project).accept(file);
    }

    @NotNull
    public static Map<VirtualFile, Document> getOpenedFiles(Project project) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashMap filesToOpen = ContainerUtil.newHashMap();
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            VirtualFile vFile;
            Project editorProject = editor.getProject();
            if (editorProject == null || editorProject != project || !(editor instanceof EditorEx) || editor.getProject() != editorProject || (vFile = ((EditorEx)editor).getVirtualFile()) == null || TypeScriptLanguageServiceUtil.shouldSkipProcessing(editorProject, vFile)) continue;
            filesToOpen.put(vFile, editor.getDocument());
        }
        HashMap hashMap = filesToOpen;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "getOpenedFiles"));
        }
        return hashMap;
    }

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future, long timeoutMills, long quotaMills, @Nullable ProgressIndicator indicator) {
        if (future == null) {
            return null;
        }
        try {
            if (future.isDone()) {
                return future.get();
            }
            for (long totalWait = timeoutMills; totalWait > 0L; totalWait -= quotaMills) {
                try {
                    return future.get(quotaMills, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    if (indicator == null) {
                        ProgressManager.checkCanceled();
                        continue;
                    }
                    indicator.checkCanceled();
                    continue;
                }
            }
            if (future.isDone()) {
                return future.get();
            }
            future.cancel(false);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static VirtualFile getMainFile(TypeScriptCompilerSettings settings) {
        if (TypeScriptLanguageServiceUtil.shouldUseMainFile(settings)) {
            String path = settings.getMainFilePath();
            return LocalFileSystem.getInstance().findFileByPath(path);
        }
        return null;
    }

    public static boolean shouldUseMainFile(TypeScriptCompilerSettings settings) {
        return !settings.isUseConfigForCompiler() && settings.isCompilerEnabled() && settings.isUseMainFile();
    }

    public static VirtualFile findTypeScriptLibDirectory(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "findTypeScriptLibDirectory"));
        }
        VirtualFile node_modules = project.getBaseDir().findChild("node_modules");
        VirtualFile lib = TypeScriptLanguageServiceUtil.getTypeScriptLibFromNodeModules(node_modules);
        if (lib != null) {
            return lib;
        }
        return (VirtualFile)ReadAction.compute(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil", "lambda$findTypeScriptLibDirectory$0"));
            }
            Collection<TypeScriptConfig> files = TypeScriptConfigService.Provider.getConfigFiles(project);
            if (files.isEmpty()) {
                return null;
            }
            ArrayList result = ContainerUtil.newArrayList();
            for (TypeScriptConfig file : files) {
                VirtualFile directory = file.getConfigDirectory();
                VirtualFile configNodeModules = directory.findChild("node_modules");
                result.add(TypeScriptLanguageServiceUtil.getTypeScriptLibFromNodeModules(configNodeModules));
            }
            if (result.size() == 1) {
                return (VirtualFile)ContainerUtil.getFirstItem((List)result);
            }
            return null;
        });
    }

    public static VirtualFile getTypeScriptLibFromNodeModules(@Nullable VirtualFile nodeModules) {
        if (nodeModules == null) {
            return null;
        }
        VirtualFile typescript = nodeModules.findChild(TYPESCRIPT_MODULE_NAME);
        if (typescript == null) {
            return null;
        }
        VirtualFile lib = typescript.findChild(LIB_DIRECTORY);
        if (lib == null) {
            return null;
        }
        VirtualFile[] children = lib.getChildren();
        if (children != null) {
            for (VirtualFile file : children) {
                if (!ArrayUtil.contains((String)file.getName(), (String[])TypeScriptCompilerSettings.TYPESCRIPT_SERVICE_FILES)) continue;
                return lib;
            }
        }
        return null;
    }

    @Nullable
    public static String getNormalizedVersionString(@Nullable String version) {
        if (version == null) {
            return null;
        }
        Version parseVersion = Version.parseVersion((String)version);
        if (parseVersion == null) {
            return null;
        }
        return parseVersion.toString();
    }
}

