/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.typescript.TypeScriptSettings;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TypeScriptDisableConfigFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    @Nls
    @NotNull
    public String getName() {
        if ("Disable tsconfig.json support" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptDisableConfigFix", "getName"));
        }
        return "Disable tsconfig.json support";
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptDisableConfigFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/intentions/TypeScriptDisableConfigFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptDisableConfigFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptDisableConfigFix", "invoke"));
        }
        TypeScriptDisableConfigFix.runFix(project);
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptDisableConfigFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/typescript/intentions/TypeScriptDisableConfigFix", "applyFix"));
        }
        TypeScriptDisableConfigFix.runFix(project);
    }

    private static void runFix(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/intentions/TypeScriptDisableConfigFix", "runFix"));
        }
        TypeScriptSettings settings = TypeScriptSettings.getSettings(project);
        if (settings != null) {
            settings.setUseConfig(false);
            ApplicationManager.getApplication().saveAll();
            TypeScriptCompilerService.getService(project).restartService();
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }
    }
}

