/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.utils;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ExpressionUtil {
    private ExpressionUtil() {
    }

    public static boolean isConstantExpression(JSExpression expression) {
        if (expression == null) {
            return false;
        }
        IsConstantExpressionVisitor visitor = new IsConstantExpressionVisitor();
        expression.accept((PsiElementVisitor)visitor);
        return visitor.isConstant;
    }

    @Nullable
    public static Object computeConstantExpression(JSExpression expression) {
        if (expression == null) {
            return null;
        }
        return null;
    }

    private static class IsConstantExpressionVisitor
    extends JSElementVisitor {
        private boolean isConstant = false;
        private final Map<JSVariable, Boolean> isVariableConstant = new HashMap<JSVariable, Boolean>();

        private IsConstantExpressionVisitor() {
        }

        public boolean isConstant() {
            return this.isConstant;
        }

        public void visitJSExpression(JSExpression expression) {
            this.isConstant = false;
        }

        public void visitJSLiteralExpression(JSLiteralExpression expression) {
            this.isConstant = true;
        }

        public void visitJSParenthesizedExpression(JSParenthesizedExpression expression) {
            JSExpression expr = expression.getInnerExpression();
            if (expr != null) {
                expr.accept((PsiElementVisitor)this);
            }
        }

        public void visitJSPrefixExpression(JSPrefixExpression expression) {
            JSExpression operand = expression.getExpression();
            if (operand == null) {
                this.isConstant = false;
                return;
            }
            operand.accept((PsiElementVisitor)this);
            if (!this.isConstant) {
                return;
            }
            IElementType opType = expression.getOperationSign();
            if (JSTokenTypes.PLUS.equals(opType) || JSTokenTypes.MINUS.equals(opType) || JSTokenTypes.TILDE.equals(opType) || JSTokenTypes.EXCL.equals(opType)) {
                return;
            }
            this.isConstant = false;
        }

        public void visitJSBinaryExpression(JSBinaryExpression expression) {
            JSExpression lOperand = expression.getLOperand();
            if (lOperand != null) {
                lOperand.accept((PsiElementVisitor)this);
            }
            if (!this.isConstant) {
                return;
            }
            JSExpression rOperand = expression.getROperand();
            if (rOperand != null) {
                rOperand.accept((PsiElementVisitor)this);
            }
        }

        public void visitJSConditionalExpression(JSConditionalExpression expression) {
            JSExpression thenExpr = expression.getThen();
            JSExpression elseExpr = expression.getElse();
            if (thenExpr == null || elseExpr == null) {
                this.isConstant = false;
                return;
            }
            expression.getCondition().accept((PsiElementVisitor)this);
            if (!this.isConstant) {
                return;
            }
            thenExpr.accept((PsiElementVisitor)this);
            if (!this.isConstant) {
                return;
            }
            elseExpr.accept((PsiElementVisitor)this);
        }

        public void visitJSReferenceExpression(JSReferenceExpression expression) {
            JSElement refElement = (JSElement)expression.resolve();
            if (!(refElement instanceof JSVariable)) {
                this.isConstant = false;
                return;
            }
            JSVariable variable = (JSVariable)refElement;
            Boolean isConst = this.isVariableConstant.get(variable);
            if (isConst != null) {
                this.isConstant &= isConst.booleanValue();
                return;
            }
            this.isVariableConstant.put(variable, Boolean.FALSE);
            if (!variable.hasInitializer()) {
                this.isConstant = false;
                return;
            }
            JSExpression initializer = variable.getInitializer();
            if (initializer != null) {
                initializer.accept((PsiElementVisitor)this);
            }
            this.isVariableConstant.put(variable, this.isConstant);
        }
    }
}

