/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.net.IdeHttpClientHelpers;
import com.intellij.util.net.ssl.CertificateManager;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.data.GithubErrorMessage;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubConfusingException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.exceptions.GithubRateLimitExceededException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.exceptions.GithubTwoFactorAuthenticationException;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubConnection {
    private static final Logger LOG = GithubUtil.LOG;
    @NotNull
    private final String myHost;
    @NotNull
    private final CloseableHttpClient myClient;
    private final boolean myReusable;
    private volatile HttpUriRequest myRequest;
    private volatile boolean myAborted;

    public GithubConnection(@NotNull GithubAuthData auth) {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/api/GithubConnection", "<init>"));
        }
        this(auth, false);
    }

    public GithubConnection(@NotNull GithubAuthData auth, boolean reusable) {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/api/GithubConnection", "<init>"));
        }
        this.myHost = auth.getHost();
        this.myClient = GithubConnection.createClient(auth);
        this.myReusable = reusable;
    }

    @Nullable
    public JsonElement getRequest(@NotNull String path, Header ... headers) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/github/api/GithubConnection", "getRequest"));
        }
        if (headers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headers", "org/jetbrains/plugins/github/api/GithubConnection", "getRequest"));
        }
        return this.request(path, null, Arrays.asList(headers), HttpVerb.GET).getJsonElement();
    }

    @Nullable
    public JsonElement postRequest(@NotNull String path, @Nullable String requestBody, Header ... headers) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/github/api/GithubConnection", "postRequest"));
        }
        if (headers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headers", "org/jetbrains/plugins/github/api/GithubConnection", "postRequest"));
        }
        return this.request(path, requestBody, Arrays.asList(headers), HttpVerb.POST).getJsonElement();
    }

    @Nullable
    public JsonElement patchRequest(@NotNull String path, @Nullable String requestBody, Header ... headers) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/github/api/GithubConnection", "patchRequest"));
        }
        if (headers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headers", "org/jetbrains/plugins/github/api/GithubConnection", "patchRequest"));
        }
        return this.request(path, requestBody, Arrays.asList(headers), HttpVerb.PATCH).getJsonElement();
    }

    @Nullable
    public JsonElement deleteRequest(@NotNull String path, Header ... headers) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/github/api/GithubConnection", "deleteRequest"));
        }
        if (headers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headers", "org/jetbrains/plugins/github/api/GithubConnection", "deleteRequest"));
        }
        return this.request(path, null, Arrays.asList(headers), HttpVerb.DELETE).getJsonElement();
    }

    @NotNull
    public Header[] headRequest(@NotNull String path, Header ... headers) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/github/api/GithubConnection", "headRequest"));
        }
        if (headers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headers", "org/jetbrains/plugins/github/api/GithubConnection", "headRequest"));
        }
        Header[] headerArray = this.request(path, null, Arrays.asList(headers), HttpVerb.HEAD).getHeaders();
        if (headerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "headRequest"));
        }
        return headerArray;
    }

    @NotNull
    public String getHost() {
        String string = this.myHost;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "getHost"));
        }
        return string;
    }

    public void abort() {
        if (this.myAborted) {
            return;
        }
        this.myAborted = true;
        HttpUriRequest request = this.myRequest;
        if (request != null) {
            request.abort();
        }
    }

    public void close() throws IOException {
        this.myClient.close();
    }

    @NotNull
    private static CloseableHttpClient createClient(@NotNull GithubAuthData auth) {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/api/GithubConnection", "createClient"));
        }
        HttpClientBuilder builder = HttpClients.custom();
        builder.setDefaultRequestConfig(GithubConnection.createRequestConfig(auth)).setDefaultConnectionConfig(GithubConnection.createConnectionConfig(auth)).setDefaultHeaders(GithubConnection.createHeaders(auth)).setSslcontext(CertificateManager.getInstance().getSslContext()).setHostnameVerifier((X509HostnameVerifier)CertificateManager.HOSTNAME_VERIFIER);
        GithubConnection.setupCredentialsProvider(builder, auth);
        CloseableHttpClient closeableHttpClient = builder.build();
        if (closeableHttpClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "createClient"));
        }
        return closeableHttpClient;
    }

    @NotNull
    private static RequestConfig createRequestConfig(@NotNull GithubAuthData auth) {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/api/GithubConnection", "createRequestConfig"));
        }
        RequestConfig.Builder builder = RequestConfig.custom();
        int timeout = GithubSettings.getInstance().getConnectionTimeout();
        builder.setConnectTimeout(timeout).setSocketTimeout(timeout);
        if (auth.isUseProxy()) {
            IdeHttpClientHelpers.ApacheHttpClient4.setProxyForUrlIfEnabled((RequestConfig.Builder)builder, (String)auth.getHost());
        }
        RequestConfig requestConfig = builder.build();
        if (requestConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "createRequestConfig"));
        }
        return requestConfig;
    }

    @NotNull
    private static ConnectionConfig createConnectionConfig(@NotNull GithubAuthData auth) {
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/api/GithubConnection", "createConnectionConfig"));
        }
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).build();
        if (connectionConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "createConnectionConfig"));
        }
        return connectionConfig;
    }

    @NotNull
    private static CredentialsProvider setupCredentialsProvider(@NotNull HttpClientBuilder builder, @NotNull GithubAuthData auth) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/github/api/GithubConnection", "setupCredentialsProvider"));
        }
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/api/GithubConnection", "setupCredentialsProvider"));
        }
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        GithubAuthData.BasicAuth basicAuth = auth.getBasicAuth();
        if (basicAuth != null) {
            AuthScope authScope = GithubConnection.getBasicAuthScope(auth);
            provider.setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(basicAuth.getLogin(), basicAuth.getPassword()));
            builder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveBasicAuthInterceptor(authScope));
        }
        builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        if (auth.isUseProxy()) {
            IdeHttpClientHelpers.ApacheHttpClient4.setProxyCredentialsForUrlIfEnabled((CredentialsProvider)provider, (String)auth.getHost());
        }
        BasicCredentialsProvider basicCredentialsProvider = provider;
        if (basicCredentialsProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "setupCredentialsProvider"));
        }
        return basicCredentialsProvider;
    }

    @NotNull
    private static AuthScope getBasicAuthScope(@NotNull GithubAuthData auth) {
        AuthScope authScope;
        block4: {
            if (auth == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/api/GithubConnection", "getBasicAuthScope"));
            }
            try {
                URIBuilder builder = new URIBuilder(auth.getHost());
                authScope = new AuthScope(builder.getHost(), builder.getPort(), AuthScope.ANY_REALM, "Basic");
                if (authScope != null) break block4;
            }
            catch (URISyntaxException e) {
                AuthScope authScope2 = AuthScope.ANY;
                if (authScope2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "getBasicAuthScope"));
                }
                return authScope2;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "getBasicAuthScope"));
        }
        return authScope;
    }

    @NotNull
    private static Collection<? extends Header> createHeaders(@NotNull GithubAuthData auth) {
        GithubAuthData.BasicAuth basicAuth;
        if (auth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/api/GithubConnection", "createHeaders"));
        }
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        GithubAuthData.TokenAuth tokenAuth = auth.getTokenAuth();
        if (tokenAuth != null) {
            headers.add(new BasicHeader("Authorization", "token " + tokenAuth.getToken()));
        }
        if ((basicAuth = auth.getBasicAuth()) != null && basicAuth.getCode() != null) {
            headers.add(new BasicHeader("X-GitHub-OTP", basicAuth.getCode()));
        }
        ArrayList<BasicHeader> arrayList = headers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "createHeaders"));
        }
        return arrayList;
    }

    @NotNull
    private static String getRequestUrl(@NotNull String host, @NotNull String path) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/plugins/github/api/GithubConnection", "getRequestUrl"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/github/api/GithubConnection", "getRequestUrl"));
        }
        String string = GithubUrlUtil.getApiUrl(host) + path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "getRequestUrl"));
        }
        return string;
    }

    @NotNull
    private ResponsePage request(@NotNull String path, @Nullable String requestBody, @NotNull Collection<Header> headers, @NotNull HttpVerb verb) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/github/api/GithubConnection", "request"));
        }
        if (headers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headers", "org/jetbrains/plugins/github/api/GithubConnection", "request"));
        }
        if (verb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "verb", "org/jetbrains/plugins/github/api/GithubConnection", "request"));
        }
        ResponsePage responsePage = this.doRequest(GithubConnection.getRequestUrl(this.myHost, path), requestBody, headers, verb);
        if (responsePage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "request"));
        }
        return responsePage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private ResponsePage doRequest(@NotNull String uri, @Nullable String requestBody, @NotNull Collection<Header> headers, @NotNull HttpVerb verb) throws IOException {
        ResponsePage responsePage;
        CloseableHttpResponse response;
        block28: {
            ResponsePage responsePage2;
            block27: {
                ResponsePage responsePage3;
                block26: {
                    if (uri == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "org/jetbrains/plugins/github/api/GithubConnection", "doRequest"));
                    }
                    if (headers == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headers", "org/jetbrains/plugins/github/api/GithubConnection", "doRequest"));
                    }
                    if (verb == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "verb", "org/jetbrains/plugins/github/api/GithubConnection", "doRequest"));
                    }
                    if (this.myAborted) {
                        throw new GithubOperationCanceledException();
                    }
                    if (EventQueue.isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
                        LOG.warn("Network operation in EDT");
                    }
                    response = null;
                    try {
                        response = this.doREST(uri, requestBody, headers, verb);
                        if (this.myAborted) {
                            throw new GithubOperationCanceledException();
                        }
                        GithubConnection.checkStatusCode(response, requestBody);
                        HttpEntity entity = response.getEntity();
                        if (entity == null) {
                            ResponsePage responsePage4 = this.createResponse(response);
                            responsePage3 = responsePage4;
                            break block26;
                        }
                        JsonElement ret = GithubConnection.parseResponse(entity.getContent());
                        if (ret.isJsonNull()) {
                            ResponsePage responsePage5 = this.createResponse(response);
                            responsePage2 = responsePage5;
                            break block27;
                        }
                        String nextPage = null;
                        Header pageHeader = response.getFirstHeader("Link");
                        if (pageHeader != null) {
                            for (HeaderElement element : pageHeader.getElements()) {
                                NameValuePair rel = element.getParameterByName("rel");
                                if (rel == null || !"next".equals(rel.getValue())) continue;
                                String urlString = element.toString();
                                int begin = urlString.indexOf(60);
                                int end = urlString.lastIndexOf(62);
                                if (begin == -1 || end == -1) {
                                    LOG.error("Invalid 'Link' header", new String[]{"{" + pageHeader.toString() + "}"});
                                    break;
                                }
                                nextPage = urlString.substring(begin + 1, end);
                                break;
                            }
                        }
                        ResponsePage responsePage6 = this.createResponse(ret, nextPage, response);
                        responsePage = responsePage6;
                        break block28;
                    }
                    catch (SSLHandshakeException e) {
                        if (e.getCause() instanceof CertificateException) {
                            LOG.info("Host SSL certificate is not trusted", (Throwable)e);
                            throw new GithubOperationCanceledException("Host SSL certificate is not trusted", e);
                        }
                        throw e;
                    }
                    catch (IOException e) {
                        if (this.myAborted) {
                            throw new GithubOperationCanceledException("Operation canceled", e);
                        }
                        throw e;
                    }
                }
                if (responsePage3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "doRequest"));
                }
                return responsePage3;
            }
            if (responsePage2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "doRequest"));
            }
            return responsePage2;
        }
        if (responsePage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "doRequest"));
        }
        return responsePage;
        finally {
            this.myRequest = null;
            if (response != null) {
                response.close();
            }
            if (!this.myReusable) {
                this.myClient.close();
            }
        }
    }

    @NotNull
    private CloseableHttpResponse doREST(@NotNull String uri, @Nullable String requestBody, @NotNull Collection<Header> headers, @NotNull HttpVerb verb) throws IOException {
        HttpPost request;
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "org/jetbrains/plugins/github/api/GithubConnection", "doREST"));
        }
        if (headers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headers", "org/jetbrains/plugins/github/api/GithubConnection", "doREST"));
        }
        if (verb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "verb", "org/jetbrains/plugins/github/api/GithubConnection", "doREST"));
        }
        switch (verb) {
            case POST: {
                request = new HttpPost(uri);
                if (requestBody == null) break;
                request.setEntity((HttpEntity)new StringEntity(requestBody, ContentType.APPLICATION_JSON));
                break;
            }
            case PATCH: {
                request = new HttpPatch(uri);
                if (requestBody == null) break;
                ((HttpPatch)request).setEntity((HttpEntity)new StringEntity(requestBody, ContentType.APPLICATION_JSON));
                break;
            }
            case GET: {
                request = new HttpGet(uri);
                break;
            }
            case DELETE: {
                request = new HttpDelete(uri);
                break;
            }
            case HEAD: {
                request = new HttpHead(uri);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown HttpVerb: " + verb.toString());
            }
        }
        for (Header header : headers) {
            request.addHeader(header);
        }
        this.myRequest = request;
        CloseableHttpResponse closeableHttpResponse = this.myClient.execute((HttpUriRequest)request);
        if (closeableHttpResponse == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "doREST"));
        }
        return closeableHttpResponse;
    }

    private static void checkStatusCode(@NotNull CloseableHttpResponse response, @Nullable String body) throws IOException {
        if (response == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "org/jetbrains/plugins/github/api/GithubConnection", "checkStatusCode"));
        }
        int code = response.getStatusLine().getStatusCode();
        switch (code) {
            case 200: 
            case 201: 
            case 202: 
            case 204: {
                return;
            }
            case 401: 
            case 402: 
            case 403: {
                GithubStatusCodeException error = GithubConnection.getStatusCodeException(response);
                Header headerOTP = response.getFirstHeader("X-GitHub-OTP");
                if (headerOTP != null) {
                    for (HeaderElement element : headerOTP.getElements()) {
                        if (!"required".equals(element.getName())) continue;
                        throw new GithubTwoFactorAuthenticationException(error.getMessage());
                    }
                }
                if (error.getError() != null && error.getError().containsReasonMessage("API rate limit exceeded")) {
                    throw new GithubRateLimitExceededException(error.getMessage());
                }
                throw new GithubAuthenticationException("Request response: " + error.getMessage());
            }
            case 400: 
            case 422: {
                LOG.info("body message:" + body);
                throw GithubConnection.getStatusCodeException(response);
            }
        }
        throw GithubConnection.getStatusCodeException(response);
    }

    @NotNull
    private static GithubStatusCodeException getStatusCodeException(@NotNull CloseableHttpResponse response) {
        StatusLine statusLine;
        block4: {
            GithubStatusCodeException githubStatusCodeException;
            block5: {
                if (response == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "org/jetbrains/plugins/github/api/GithubConnection", "getStatusCodeException"));
                }
                statusLine = response.getStatusLine();
                try {
                    HttpEntity entity = response.getEntity();
                    if (entity == null) break block4;
                    GithubErrorMessage error = GithubApiUtil.fromJson(GithubConnection.parseResponse(entity.getContent()), GithubErrorMessage.class);
                    String message = statusLine.getReasonPhrase() + " - " + error.getMessage();
                    githubStatusCodeException = new GithubStatusCodeException(message, error, statusLine.getStatusCode());
                    if (githubStatusCodeException != null) break block5;
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "getStatusCodeException"));
            }
            return githubStatusCodeException;
        }
        GithubStatusCodeException githubStatusCodeException = new GithubStatusCodeException(statusLine.getReasonPhrase(), statusLine.getStatusCode());
        if (githubStatusCodeException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "getStatusCodeException"));
        }
        return githubStatusCodeException;
    }

    @NotNull
    private static JsonElement parseResponse(@NotNull InputStream githubResponse) throws IOException {
        JsonElement jsonElement;
        if (githubResponse == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "githubResponse", "org/jetbrains/plugins/github/api/GithubConnection", "parseResponse"));
        }
        try (InputStreamReader reader = new InputStreamReader(githubResponse, CharsetToolkit.UTF8_CHARSET);){
            JsonElement jsonElement2 = new JsonParser().parse((Reader)reader);
            jsonElement = jsonElement2;
        }
        if (jsonElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection", "parseResponse"));
        }
        return jsonElement;
    }

    private ResponsePage createResponse(@NotNull CloseableHttpResponse response) throws GithubOperationCanceledException {
        if (response == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "org/jetbrains/plugins/github/api/GithubConnection", "createResponse"));
        }
        if (this.myAborted) {
            throw new GithubOperationCanceledException();
        }
        return new ResponsePage(null, null, response.getAllHeaders());
    }

    private ResponsePage createResponse(@NotNull JsonElement ret, @Nullable String path, @NotNull CloseableHttpResponse response) throws GithubOperationCanceledException {
        if (ret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ret", "org/jetbrains/plugins/github/api/GithubConnection", "createResponse"));
        }
        if (response == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "org/jetbrains/plugins/github/api/GithubConnection", "createResponse"));
        }
        if (this.myAborted) {
            throw new GithubOperationCanceledException();
        }
        return new ResponsePage(ret, path, response.getAllHeaders());
    }

    public static interface PagedRequest<T> {
        @NotNull
        public List<T> next(@NotNull GithubConnection var1) throws IOException;

        public boolean hasNext();

        @NotNull
        default public List<T> getAll(@NotNull GithubConnection connection) throws IOException {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubConnection$PagedRequest", "getAll"));
            }
            ArrayList<T> result = new ArrayList<T>();
            while (this.hasNext()) {
                result.addAll(this.next(connection));
            }
            ArrayList<T> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection$PagedRequest", "getAll"));
            }
            return arrayList;
        }
    }

    private static class PreemptiveBasicAuthInterceptor
    implements HttpRequestInterceptor {
        @NotNull
        private final AuthScope myBasicAuthScope;

        public PreemptiveBasicAuthInterceptor(@NotNull AuthScope basicAuthScope) {
            if (basicAuthScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basicAuthScope", "org/jetbrains/plugins/github/api/GithubConnection$PreemptiveBasicAuthInterceptor", "<init>"));
            }
            this.myBasicAuthScope = basicAuthScope;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            CredentialsProvider provider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            Credentials credentials = provider.getCredentials(this.myBasicAuthScope);
            if (credentials != null) {
                request.addHeader(new BasicScheme(Consts.UTF_8).authenticate(credentials, request, context));
            }
        }
    }

    private static class ResponsePage {
        @Nullable
        private final JsonElement myResponse;
        @Nullable
        private final String myNextPage;
        @NotNull
        private final Header[] myHeaders;

        public ResponsePage(@Nullable JsonElement response, @Nullable String next, @NotNull Header[] headers) {
            if (headers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headers", "org/jetbrains/plugins/github/api/GithubConnection$ResponsePage", "<init>"));
            }
            this.myResponse = response;
            this.myNextPage = next;
            this.myHeaders = headers;
        }

        @Nullable
        public JsonElement getJsonElement() {
            return this.myResponse;
        }

        @Nullable
        public String getNextPage() {
            return this.myNextPage;
        }

        @NotNull
        public Header[] getHeaders() {
            if (this.myHeaders == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection$ResponsePage", "getHeaders"));
            }
            return this.myHeaders;
        }
    }

    public static class SingleValuePagedRequest<T>
    extends PagedRequestBase<T> {
        @NotNull
        private final Class<? extends T> myType;

        public SingleValuePagedRequest(@NotNull String path, @NotNull Class<? extends T> type, Header ... headers) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/github/api/GithubConnection$SingleValuePagedRequest", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/github/api/GithubConnection$SingleValuePagedRequest", "<init>"));
            }
            if (headers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headers", "org/jetbrains/plugins/github/api/GithubConnection$SingleValuePagedRequest", "<init>"));
            }
            super(path, headers);
            this.myType = type;
        }

        @Override
        protected List<T> parse(@NotNull JsonElement response) throws IOException {
            if (response == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "org/jetbrains/plugins/github/api/GithubConnection$SingleValuePagedRequest", "parse"));
            }
            T result = GithubApiUtil.fromJson(response, this.myType);
            return Collections.singletonList(result);
        }
    }

    public static class ArrayPagedRequest<T>
    extends PagedRequestBase<T> {
        @NotNull
        private final Class<? extends T[]> myTypeArray;

        public ArrayPagedRequest(@NotNull String path, @NotNull Class<? extends T[]> typeArray, Header ... headers) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/github/api/GithubConnection$ArrayPagedRequest", "<init>"));
            }
            if (typeArray == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArray", "org/jetbrains/plugins/github/api/GithubConnection$ArrayPagedRequest", "<init>"));
            }
            if (headers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headers", "org/jetbrains/plugins/github/api/GithubConnection$ArrayPagedRequest", "<init>"));
            }
            super(path, headers);
            this.myTypeArray = typeArray;
        }

        @Override
        protected List<T> parse(@NotNull JsonElement response) throws IOException {
            if (response == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "response", "org/jetbrains/plugins/github/api/GithubConnection$ArrayPagedRequest", "parse"));
            }
            if (!response.isJsonArray()) {
                throw new GithubJsonException("Wrong json type: expected JsonArray", new Exception(response.toString()));
            }
            T[] result = GithubApiUtil.fromJson((JsonElement)response.getAsJsonArray(), this.myTypeArray);
            return Arrays.asList(result);
        }
    }

    public static abstract class PagedRequestBase<T>
    implements PagedRequest<T> {
        @NotNull
        private String myPath;
        @NotNull
        private final Collection<Header> myHeaders;
        private boolean myFirstRequest;
        @Nullable
        private String myNextPage;

        public PagedRequestBase(@NotNull String path, Header ... headers) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/github/api/GithubConnection$PagedRequestBase", "<init>"));
            }
            if (headers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headers", "org/jetbrains/plugins/github/api/GithubConnection$PagedRequestBase", "<init>"));
            }
            this.myFirstRequest = true;
            this.myPath = path;
            this.myHeaders = Arrays.asList(headers);
        }

        @Override
        @NotNull
        public List<T> next(@NotNull GithubConnection connection) throws IOException {
            String url;
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/plugins/github/api/GithubConnection$PagedRequestBase", "next"));
            }
            if (this.myFirstRequest) {
                url = GithubConnection.getRequestUrl(connection.getHost(), this.myPath);
                this.myFirstRequest = false;
            } else {
                if (this.myNextPage == null) {
                    throw new NoSuchElementException();
                }
                url = this.myNextPage;
                this.myNextPage = null;
            }
            ResponsePage response = connection.doRequest(url, null, this.myHeaders, HttpVerb.GET);
            this.myNextPage = response.getNextPage();
            if (response.getJsonElement() == null) {
                throw new GithubConfusingException("Empty response");
            }
            List<T> list = this.parse(response.getJsonElement());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/api/GithubConnection$PagedRequestBase", "next"));
            }
            return list;
        }

        @Override
        public boolean hasNext() {
            return this.myFirstRequest || this.myNextPage != null;
        }

        protected abstract List<T> parse(@NotNull JsonElement var1) throws IOException;
    }

    private static enum HttpVerb {
        GET,
        POST,
        DELETE,
        HEAD,
        PATCH;

    }
}

