/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.util.GithubAuthData;

public interface AuthLevel {
    public static final AuthLevel ANY = new AuthLevelImpl(null, null);
    public static final AuthLevel TOKEN = new AuthLevelImpl(null, GithubAuthData.AuthType.TOKEN);
    public static final AuthLevel BASIC = new AuthLevelImpl(null, GithubAuthData.AuthType.BASIC);
    public static final AuthLevel LOGGED = new AuthLevel(){

        @Override
        public boolean accepts(@NotNull GithubAuthData auth) {
            if (auth == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/util/AuthLevel$1", "accepts"));
            }
            return auth.getAuthType() != GithubAuthData.AuthType.ANONYMOUS;
        }

        public String toString() {
            return "Not anonymous";
        }
    };

    public boolean accepts(@NotNull GithubAuthData var1);

    @Nullable
    default public String getHost() {
        return null;
    }

    @Nullable
    default public GithubAuthData.AuthType getAuthType() {
        return null;
    }

    default public boolean isOnetime() {
        return false;
    }

    @NotNull
    public static AuthLevel basicOnetime(@NotNull String host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/plugins/github/util/AuthLevel", "basicOnetime"));
        }
        AuthLevelImpl authLevelImpl = new AuthLevelImpl(host, GithubAuthData.AuthType.BASIC){

            @Override
            public boolean isOnetime() {
                return true;
            }
        };
        if (authLevelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/github/util/AuthLevel", "basicOnetime"));
        }
        return authLevelImpl;
    }

    public static class AuthLevelImpl
    implements AuthLevel {
        @Nullable
        private final String myHost;
        @Nullable
        private final GithubAuthData.AuthType myAuthType;

        public AuthLevelImpl(@Nullable String host, @Nullable GithubAuthData.AuthType authType) {
            this.myHost = host;
            this.myAuthType = authType;
        }

        @Override
        @Nullable
        public String getHost() {
            return this.myHost;
        }

        @Override
        @Nullable
        public GithubAuthData.AuthType getAuthType() {
            return this.myAuthType;
        }

        @Override
        public boolean accepts(@NotNull GithubAuthData auth) {
            if (auth == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "auth", "org/jetbrains/plugins/github/util/AuthLevel$AuthLevelImpl", "accepts"));
            }
            if (this.myHost != null && !this.myHost.equals(auth.getHost())) {
                return false;
            }
            return this.myAuthType == null || this.myAuthType.equals((Object)auth.getAuthType());
        }

        public String toString() {
            String s = "";
            if (this.myAuthType != null) {
                s = s + this.myAuthType.name();
            }
            if (this.myHost != null) {
                if (!s.isEmpty()) {
                    s = s + " ";
                }
                s = s + "for " + this.myHost;
            }
            return s;
        }
    }
}

