/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.configuration;

import com.intellij.openapi.util.PasswordUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;

@Tag(value="credentials")
public class Credentials {
    @NotNull
    private String myUserName;
    @NotNull
    private String myDomain;
    @Nullable
    private String myPassword;
    private boolean myStorePassword;
    private Type myType;

    public static Credentials createNative() {
        return new Credentials("", "", "", true, Type.NtlmNative);
    }

    public Credentials() {
        this("", "", null, false, Type.NtlmExplicit);
    }

    public Credentials(@NotNull String userName, @NotNull String domain, @Nullable String password, boolean storePassword, Type type) {
        if (userName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userName", "org/jetbrains/tfsIntegration/core/configuration/Credentials", "<init>"));
        }
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "org/jetbrains/tfsIntegration/core/configuration/Credentials", "<init>"));
        }
        this.myUserName = userName;
        this.myDomain = domain;
        this.myPassword = password;
        this.myStorePassword = storePassword;
        this.myType = type;
    }

    public Credentials(@NotNull String credentials, @Nullable String password, boolean storePassword, Type type) {
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "org/jetbrains/tfsIntegration/core/configuration/Credentials", "<init>"));
        }
        int i = credentials.indexOf(92);
        this.myDomain = i != -1 ? credentials.substring(0, i) : "";
        this.myUserName = i != -1 ? credentials.substring(i + 1) : credentials;
        this.myPassword = password;
        this.myStorePassword = storePassword;
        this.myType = type;
    }

    @Nullable
    public String getPassword() {
        return this.myPassword;
    }

    public void resetPassword() {
        this.myPassword = null;
        this.myStorePassword = false;
    }

    @Tag(value="password")
    @Nullable
    public String getEncodedPassword() {
        return this.myStorePassword && this.myPassword != null ? PasswordUtil.encodePassword((String)this.myPassword) : null;
    }

    public void setEncodedPassword(String encodedPassword) {
        this.myPassword = encodedPassword != null ? PasswordUtil.decodePassword((String)encodedPassword) : null;
        this.myStorePassword = true;
    }

    public boolean isStorePassword() {
        return this.myStorePassword;
    }

    @Tag(value="domain")
    @NotNull
    public String getDomain() {
        String string = this.myDomain;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/configuration/Credentials", "getDomain"));
        }
        return string;
    }

    public void setDomain(@NotNull String domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "org/jetbrains/tfsIntegration/core/configuration/Credentials", "setDomain"));
        }
        this.myDomain = domain;
    }

    @Tag(value="username")
    @NotNull
    public String getUserName() {
        String string = this.myUserName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/configuration/Credentials", "getUserName"));
        }
        return string;
    }

    public void setUserName(@NotNull String userName) {
        if (userName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userName", "org/jetbrains/tfsIntegration/core/configuration/Credentials", "setUserName"));
        }
        this.myUserName = userName;
    }

    public Type getType() {
        return this.myType;
    }

    @Attribute(value="nativeAuth")
    public String getUseNativeSerialized() {
        return null;
    }

    public void setUseNativeSerialized(String useNative) {
        if (UseNative.Yes.name().equals(useNative)) {
            this.myType = Type.NtlmNative;
            this.myPassword = "";
        } else if (UseNative.Reset.name().equals(useNative)) {
            this.myType = Type.NtlmNative;
            this.myPassword = null;
        } else {
            this.myType = Type.NtlmExplicit;
        }
    }

    @Attribute(value="type")
    public String getTypeSerialized() {
        return this.myType.name();
    }

    public void setTypeSerialized(String s) {
        try {
            this.myType = Type.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            this.myType = Type.NtlmExplicit;
        }
    }

    @NotNull
    public String getQualifiedUsername() {
        if (this.getDomain().length() > 0) {
            String string = TfsUtil.getQualifiedUsername(this.getDomain(), this.getUserName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/configuration/Credentials", "getQualifiedUsername"));
            }
            return string;
        }
        String string = this.getUserName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/configuration/Credentials", "getQualifiedUsername"));
        }
        return string;
    }

    @NonNls
    public String toString() {
        return this.myType.name() + ": " + this.getQualifiedUsername() + "," + (this.getPassword() != null ? this.getPassword().replaceAll(".", "x") : "(no password)");
    }

    public boolean shouldShowLoginDialog() {
        return this.myPassword == null;
    }

    public static enum Type {
        NtlmExplicit,
        NtlmNative,
        Alternate;


        public String getPresentableText() {
            return TFSBundle.message("credentials.type." + this.name(), new Object[0]);
        }
    }

    private static enum UseNative {
        Yes,
        No,
        Reset;

    }
}

