/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import java.text.MessageFormat;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.MergeNameForm;

public class MergeNameDialog
extends DialogWrapper {
    private MergeNameForm myMergeNameForm;
    private final WorkspaceInfo myWorkspace;
    private final String myLocalName;
    private final String myServerName;
    private final Project myProject;

    public MergeNameDialog(WorkspaceInfo workspace, String yourName, String theirsName, Project project) {
        super(project, false);
        this.myWorkspace = workspace;
        this.myLocalName = yourName;
        this.myServerName = theirsName;
        this.myProject = project;
        this.setTitle("Resolve Conflicting Names");
        this.setResizable(true);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myMergeNameForm = new MergeNameForm(this.myLocalName, this.myServerName);
        this.myMergeNameForm.addListener(new MergeNameForm.Listener(){

            @Override
            public void selectedPathChanged() {
                String errorMessage = MergeNameDialog.this.validate(MergeNameDialog.this.myMergeNameForm.getSelectedPath());
                MergeNameDialog.this.myMergeNameForm.setErrorText(errorMessage);
                MergeNameDialog.this.setOKActionEnabled(errorMessage == null);
            }
        });
        return this.myMergeNameForm.getPanel();
    }

    @NotNull
    public String getSelectedPath() {
        String string = this.myMergeNameForm.getSelectedPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/MergeNameDialog", "getSelectedPath"));
        }
        return string;
    }

    @Nullable
    private String validate(String path) {
        if (path == null || path.length() == 0) {
            return "Path is empty";
        }
        try {
            if (!this.myWorkspace.hasLocalPathForServerPath(path, this.myProject)) {
                return MessageFormat.format("No mapping found for ''{0}'' in workspace ''{1}''", path, this.myWorkspace.getName());
            }
        }
        catch (TfsException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)"Merge");
            this.close(1);
        }
        return null;
    }

    protected String getDimensionServiceKey() {
        return "TFS.MergeName";
    }
}

