/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources;

import java.util.Hashtable;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.SpaceEntry;
import org.w3c.tools.resources.event.AttributeChangedEvent;
import org.w3c.tools.resources.event.AttributeChangedListener;
import org.w3c.tools.resources.event.FrameEvent;
import org.w3c.tools.resources.event.FrameEventListener;
import org.w3c.tools.resources.event.ResourceEvent;
import org.w3c.tools.resources.event.ResourceEventMulticaster;

public class ResourceFrame
extends FramedResource
implements AttributeChangedListener {
    protected static Class filterClass = null;
    protected transient FrameEventListener frameListener = null;
    protected FramedResource resource = null;
    private ResourceReference self = null;

    protected boolean eventDisabled() {
        if (this.resource != null) {
            return this.event_disabled || this.resource.eventDisabled();
        }
        return this.event_disabled;
    }

    public String getURLPath() {
        return this.getString(ATTR_URL, this.getResource().getURLPath());
    }

    protected SpaceEntry getSpaceEntry() {
        return null;
    }

    public ResourceReference getFrameReference() {
        if (this.self == null && this.resource != null) {
            this.self = this.resource.getFrameReference(this);
        }
        return this.self;
    }

    public ResourceReference getResourceReference() {
        return this.getFrameReference();
    }

    protected void updateDefaultChildAttributes(Hashtable hashtable) {
    }

    public boolean checkRequest(RequestInterface requestInterface) {
        return true;
    }

    public ReplyInterface perform(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        return super.perform(requestInterface);
    }

    protected boolean lookupFilters(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        ResourceFilter[] resourceFilterArray = this.getFilters();
        if (resourceFilterArray != null) {
            lookupResult.addFilters(resourceFilterArray);
            for (int i = 0; i < resourceFilterArray.length; ++i) {
                if (resourceFilterArray[i] == null || !resourceFilterArray[i].lookup(lookupState, lookupResult)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean lookupFrames(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        ResourceFrame[] resourceFrameArray = this.getFrames();
        if (resourceFrameArray != null) {
            for (int i = 0; i < resourceFrameArray.length; ++i) {
                if (resourceFrameArray[i] == null || resourceFrameArray[i] instanceof ResourceFilter || !resourceFrameArray[i].lookup(lookupState, lookupResult)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean lookup(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        if (this.lookupFrames(lookupState, lookupResult)) {
            return true;
        }
        if (lookupState.hasMoreComponents()) {
            lookupResult.setTarget(null);
            return false;
        }
        lookupResult.setTarget(this.resource.getResourceReference());
        return true;
    }

    public void processEvent(ResourceEvent resourceEvent) {
        if (resourceEvent instanceof FrameEvent) {
            this.fireFrameEvent((FrameEvent)resourceEvent);
        } else if (resourceEvent instanceof AttributeChangedEvent) {
            this.fireAttributeChangeEvent((AttributeChangedEvent)resourceEvent);
        }
    }

    public void addFrameEventListener(FrameEventListener frameEventListener) {
        this.frameListener = ResourceEventMulticaster.add(this.frameListener, frameEventListener);
    }

    public void removeFrameEventListener(FrameEventListener frameEventListener) {
        this.frameListener = ResourceEventMulticaster.remove(this.frameListener, frameEventListener);
    }

    protected void postFrameEvent(int n) {
        if (this.frameListener != null) {
            FrameEvent frameEvent = new FrameEvent(this, n);
            this.postEvent(frameEvent);
        }
    }

    protected void fireFrameEvent(FrameEvent frameEvent) {
        if (this.frameListener != null) {
            int n = frameEvent.getID();
            switch (n) {
                case 2001: {
                    this.frameListener.frameAdded(frameEvent);
                    break;
                }
                case 2002: {
                    this.frameListener.frameModified(frameEvent);
                    break;
                }
                case 2003: {
                    this.frameListener.frameRemoved(frameEvent);
                }
            }
        }
    }

    public void attributeChanged(AttributeChangedEvent attributeChangedEvent) {
        if (!this.isUnloaded()) {
            this.setValue(ATTR_LAST_MODIFIED, (Object)new Long(System.currentTimeMillis()));
        }
    }

    public void frameModified(FrameEvent frameEvent) {
        if (!this.isUnloaded()) {
            this.markModified();
            this.postFrameEvent(frameEvent.getID());
        }
    }

    public synchronized void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n != ATTR_LAST_MODIFIED) {
            this.postFrameEvent(2002);
        }
    }

    public FramedResource getResource() {
        return this.resource;
    }

    public void registerResource(FramedResource framedResource) {
        this.resource = framedResource;
        this.postFrameEvent(2001);
        this.setValue(ATTR_CONTEXT, (Object)framedResource.getContext());
    }

    public void unregisterResource(Resource resource) {
        this.resource = null;
        this.postFrameEvent(2003);
    }

    public synchronized ResourceFilter[] getFilters() {
        ResourceFrame[] resourceFrameArray = this.collectFrames(filterClass);
        if (resourceFrameArray != null) {
            ResourceFilter[] resourceFilterArray = new ResourceFilter[resourceFrameArray.length];
            for (int i = 0; i < resourceFrameArray.length; ++i) {
                resourceFilterArray[i] = (ResourceFilter)resourceFrameArray[i];
            }
            return resourceFilterArray;
        }
        return null;
    }

    public synchronized ResourceFilter[] getFilters(Class clazz) {
        ResourceFrame[] resourceFrameArray = this.collectFrames(clazz);
        if (resourceFrameArray != null) {
            ResourceFilter[] resourceFilterArray = new ResourceFilter[resourceFrameArray.length];
            for (int i = 0; i < resourceFrameArray.length; ++i) {
                resourceFilterArray[i] = (ResourceFilter)resourceFrameArray[i];
            }
            return resourceFilterArray;
        }
        return null;
    }

    static {
        try {
            filterClass = Class.forName("org.w3c.tools.resources.ResourceFilter");
        }
        catch (Exception exception) {
            throw new RuntimeException("No ResourceFilter class found.");
        }
    }
}

