/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.indexer;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.ContainerInterface;
import org.w3c.tools.resources.ContainerResource;
import org.w3c.tools.resources.DummyResourceReference;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceContext;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.tools.resources.indexer.IndexerModule;
import org.w3c.tools.resources.indexer.ResourceIndexer;
import org.w3c.tools.resources.indexer.SampleIndexerEnumeration;
import org.w3c.tools.resources.indexer.TemplateContainer;

public class SampleResourceIndexer
extends Resource
implements ContainerInterface,
ResourceIndexer {
    private static final boolean debug = false;
    protected static final boolean extCaseSensitive = false;
    protected static final String defname = "*default*";
    private static final String[] harmfulNames = new String[]{"aux".intern(), "con".intern()};
    public static boolean isWinPlatform = File.pathSeparatorChar == ';';
    protected static int ATTR_SUPER_INDEXER = -1;
    protected static int ATTR_NOT_INDEXED = -1;
    protected ResourceReference directories = null;
    protected ResourceReference extensions = null;
    protected ResourceReference contentTypes = null;
    private static final String[] noextension;
    static /* synthetic */ Class class$org$w3c$tools$resources$indexer$SampleResourceIndexer;

    protected synchronized ResourceReference getDirectories() {
        if (this.directories == null) {
            String string = this.getIdentifier() + "-d";
            this.directories = new DummyResourceReference(new TemplateContainer(new ResourceContext(this.getContext()), string + ".db"));
        }
        return this.directories;
    }

    protected synchronized ResourceReference getExtensions() {
        if (this.extensions == null) {
            String string = this.getIdentifier() + "-e";
            this.extensions = new DummyResourceReference(new TemplateContainer(new ResourceContext(this.getContext()), string + ".db"));
        }
        return this.extensions;
    }

    public long lastModified() {
        return this.getLong(ATTR_LAST_MODIFIED, -1L);
    }

    public String getSuperIndexer() {
        return this.getString(ATTR_SUPER_INDEXER, null);
    }

    public Enumeration enumerateResourceIdentifiers(boolean bl) {
        return new SampleIndexerEnumeration();
    }

    public ResourceReference lookup(String string) {
        if (string.equals("directories")) {
            return this.getDirectories();
        }
        if (string.equals("extensions")) {
            return this.getExtensions();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete() throws MultipleLockException {
        Resource resource;
        DummyResourceReference dummyResourceReference = (DummyResourceReference)this.getExtensions();
        try {
            resource = dummyResourceReference.lock();
            resource.delete();
        }
        catch (InvalidResourceException invalidResourceException) {
        }
        finally {
            dummyResourceReference.invalidate();
            dummyResourceReference.unlock();
        }
        dummyResourceReference = (DummyResourceReference)this.getDirectories();
        try {
            resource = dummyResourceReference.lock();
            resource.delete();
        }
        catch (InvalidResourceException invalidResourceException) {
        }
        finally {
            dummyResourceReference.invalidate();
            dummyResourceReference.unlock();
        }
        super.delete();
    }

    public void delete(String string) {
        throw new RuntimeException("static container");
    }

    public void registerResource(String string, Resource resource, Hashtable hashtable) {
        throw new RuntimeException("static container");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResourceReference loadExtension(String string) {
        ResourceReference resourceReference = this.getExtensions();
        ResourceReference resourceReference2 = null;
        try {
            TemplateContainer templateContainer = (TemplateContainer)resourceReference.lock();
            resourceReference2 = templateContainer.lookup(string);
            if (resourceReference2 == null) {
                ResourceReference resourceReference3 = templateContainer.lookup(string.toLowerCase());
                return resourceReference3;
            }
            ResourceReference resourceReference4 = resourceReference2;
            return resourceReference4;
        }
        catch (InvalidResourceException invalidResourceException) {
            String string2 = "[resource indexer]: extensions \"" + string + "\" couldn't be restored (" + invalidResourceException.getMessage() + ")";
            this.getContext().getServer().errlog(string2);
            ResourceReference resourceReference5 = null;
            return resourceReference5;
        }
        finally {
            resourceReference.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceReference getTemplateFor(String string) {
        ResourceReference resourceReference = this.loadExtension(string);
        if (resourceReference != null) {
            Resource resource;
            try {
                Resource resource2 = resourceReference.lock();
                if (resource2 != null) {
                    resource = new Resource();
                    if (resource2.getClass() == resource.getClass()) {
                        ResourceReference resourceReference2 = null;
                        return resourceReference2;
                    }
                    ResourceReference resourceReference3 = resourceReference;
                    return resourceReference3;
                }
                ResourceReference resourceReference4 = null;
                return resourceReference4;
            }
            catch (InvalidResourceException invalidResourceException) {
                resource = null;
                return resource;
            }
            finally {
                resourceReference.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable mergeDefaultAttributes(Resource resource, String string, Hashtable hashtable) {
        Attribute[] attributeArray = resource.getAttributes();
        ResourceReference resourceReference = this.loadExtension(string);
        if (resourceReference != null) {
            try {
                Resource resource2 = resourceReference.lock();
                if (resource2 != null) {
                    for (int i = 0; i < attributeArray.length; ++i) {
                        Object object;
                        int n;
                        if (resource.definesAttribute(i) || (n = resource2.lookupAttribute(attributeArray[i].getName())) < 0 || (object = resource2.getValue(n, null)) == null) continue;
                        hashtable.put(attributeArray[i].getName(), object);
                    }
                }
                Hashtable hashtable2 = hashtable;
                return hashtable2;
            }
            catch (InvalidResourceException invalidResourceException) {
                Hashtable hashtable3 = null;
                return hashtable3;
            }
            finally {
                resourceReference.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeFrameAttributes(ResourceFrame resourceFrame, String string, ResourceReference resourceReference) {
        try {
            Resource resource = resourceReference.lock();
            Attribute[] attributeArray = resource.getAttributes();
            for (int i = 0; i < attributeArray.length; ++i) {
                String string2 = attributeArray[i].getName();
                try {
                    Double d;
                    Object object = resourceFrame.getValue(string2, null);
                    if (object == null) {
                        try {
                            resourceFrame.setValue(string2, resource.getValue(string2, null));
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (!string2.equals("quality") || (d = (Double)resource.getValue(string2, null)) == null) continue;
                    d = new Double(d * (Double)object);
                    resourceFrame.setValue(string2, (Object)d);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (InvalidResourceException invalidResourceException) {
            invalidResourceException.printStackTrace();
        }
        finally {
            resourceReference.unlock();
        }
    }

    protected String[] getFileExtensions(String string) {
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf(46);
        if (n > 0) {
            int n2 = n + 1;
            while ((n = string.indexOf(46, n2)) != -1) {
                if (n == n2 + 1) {
                    ++n2;
                    continue;
                }
                vector.addElement(string.substring(n2, n));
                n2 = n + 1;
            }
            if (n2 < string.length()) {
                vector.addElement(string.substring(n2));
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return noextension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource createFileResource(File file, RequestInterface requestInterface, String string, Hashtable hashtable) {
        ResourceFrame[] resourceFrameArray;
        ResourceReference resourceReference = null;
        FramedResource framedResource = null;
        FramedResource framedResource2 = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.tools.resources.ProtocolFrame");
        }
        catch (Exception exception) {
            return null;
        }
        String[] stringArray = this.getFileExtensions(string);
        if (stringArray == null) {
            return null;
        }
        for (int i = stringArray.length - 1; i >= 0 && (resourceReference = this.getTemplateFor(stringArray[i])) == null; --i) {
        }
        if (resourceReference == null && (resourceReference = this.loadExtension(defname)) == null) {
            return null;
        }
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object>(5);
        }
        String string2 = "directory".intern();
        String string3 = "identifier".intern();
        String string4 = "filename".intern();
        String string5 = "context".intern();
        if (hashtable.get(string2) == null) {
            hashtable.put(string2, file);
        }
        if (hashtable.get(string3) == null) {
            hashtable.put(string3, this.getIndexedFileName(string));
        } else {
            hashtable.put(string3, this.getIndexedFileName((String)hashtable.get(string3)));
        }
        if (hashtable.get(string4) == null) {
            hashtable.put(string4, string);
        }
        if (hashtable.get(string5) == null) {
            hashtable.put(string5, this.getContext());
        }
        try {
            framedResource = (FramedResource)resourceReference.lock();
            if (stringArray != null) {
                int n = stringArray.length;
                while (--n >= 0) {
                    this.mergeDefaultAttributes(framedResource, stringArray[n], hashtable);
                }
            }
            try {
                framedResource2 = (FramedResource)framedResource.getClone(hashtable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Resource resource = null;
                resourceReference.unlock();
                return resource;
            }
        }
        catch (InvalidResourceException invalidResourceException) {
            invalidResourceException.printStackTrace();
            Resource resource = null;
            return resource;
        }
        finally {
            resourceReference.unlock();
        }
        if (stringArray != null && (resourceFrameArray = framedResource2.collectFrames(clazz)) != null) {
            for (int i = 0; i < resourceFrameArray.length; ++i) {
                for (int j = stringArray.length - 1; j >= 0; --j) {
                    resourceReference = this.getTemplateFor(stringArray[j]);
                    if (resourceReference == null) continue;
                    FramedResource framedResource3 = null;
                    try {
                        framedResource3 = (FramedResource)resourceReference.lock();
                        ResourceReference resourceReference2 = null;
                        resourceReference2 = framedResource3.getFrameReference(clazz);
                        if (resourceReference2 == null) continue;
                        this.mergeFrameAttributes(resourceFrameArray[i], stringArray[j], resourceReference2);
                        continue;
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        invalidResourceException.printStackTrace();
                        Resource resource = null;
                        return resource;
                    }
                    finally {
                        resourceReference.unlock();
                    }
                }
            }
        }
        return framedResource2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResourceReference loadDirectory(String string) {
        ResourceReference resourceReference = this.getDirectories();
        try {
            TemplateContainer templateContainer = (TemplateContainer)resourceReference.lock();
            ResourceReference resourceReference2 = templateContainer.lookup(string);
            return resourceReference2;
        }
        catch (InvalidResourceException invalidResourceException) {
            String string2 = "[resource indexer]: directory template \"" + string + "\" couldn't be restored. It has " + "been removed.";
            this.getContext().getServer().errlog(string2);
            ResourceReference resourceReference3 = null;
            return resourceReference3;
        }
        finally {
            resourceReference.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource createDirectoryResource(File file, RequestInterface requestInterface, String string, Hashtable hashtable) {
        File file2 = new File(file, string);
        Resource resource = null;
        ResourceReference resourceReference = null;
        resourceReference = this.loadDirectory(string);
        if (resourceReference == null && (resourceReference = this.loadDirectory(defname)) == null) {
            return null;
        }
        try {
            resource = resourceReference.lock();
            if (hashtable == null) {
                hashtable = new Hashtable<String, Object>(3);
            }
            String string2 = "directory".intern();
            String string3 = "identifier".intern();
            if (hashtable.get(string2) == null) {
                hashtable.put(string2, file);
            }
            if (hashtable.get(string3) == null) {
                hashtable.put(string3, this.getIndexedDirName(string));
            } else {
                hashtable.put(string3, this.getIndexedDirName((String)hashtable.get(string3)));
            }
            try {
                Resource resource2 = (Resource)resource.getClone(hashtable);
                return resource2;
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                    Resource resource3 = null;
                    resourceReference.unlock();
                    return resource3;
                }
                catch (InvalidResourceException invalidResourceException) {
                    invalidResourceException.printStackTrace();
                    string3 = null;
                    return string3;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            resourceReference.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Resource createVirtualResource(File file, RequestInterface requestInterface, String string, Hashtable hashtable) {
        ResourceReference resourceReference = null;
        Resource resource = null;
        resourceReference = this.loadDirectory(string);
        if (resourceReference != null) {
            try {
                Object object;
                Object object2;
                resource = resourceReference.lock();
                String string2 = resource.getClass().getName().intern();
                String string3 = "org.w3c.jigsaw.resources.DirectoryResource".intern();
                if (string2 == string3) {
                    object2 = new File(file, string);
                    if (!((File)object2).exists()) {
                        Resource resource2 = null;
                        return resource2;
                    }
                    if (!((File)object2).isDirectory()) {
                        Resource resource3 = null;
                        return resource3;
                    }
                }
                if (string2 == (object2 = "org.w3c.tools.resources.FileResource".intern())) {
                    object = new File(file, string);
                    if (!((File)object).exists()) {
                        Resource resource4 = null;
                        return resource4;
                    }
                    if (((File)object).isDirectory()) {
                        Resource resource5 = null;
                        return resource5;
                    }
                }
                if (hashtable == null) {
                    hashtable = new Hashtable<Object, Object>(4);
                }
                object = "directory".intern();
                String string4 = "identifier".intern();
                String string5 = "context".intern();
                if (hashtable.get(object) == null) {
                    hashtable.put(object, file);
                }
                if (hashtable.get(string4) == null) {
                    hashtable.put(string4, string);
                }
                if (hashtable.get(string5) == null) {
                    hashtable.put(string5, this.getContext());
                }
                try {
                    Resource resource6 = (Resource)resource.getClone(hashtable);
                    return resource6;
                }
                catch (Exception exception) {
                    try {
                        exception.printStackTrace();
                        Resource resource7 = null;
                        resourceReference.unlock();
                        return resource7;
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        invalidResourceException.printStackTrace();
                        string3 = null;
                        return string3;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                resourceReference.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource createResource(ContainerResource containerResource, RequestInterface requestInterface, File file, String string, Hashtable hashtable) {
        String[] stringArray;
        if (isWinPlatform) {
            for (int i = 0; i < harmfulNames.length; ++i) {
                if (!string.equalsIgnoreCase(harmfulNames[i])) continue;
                return null;
            }
        }
        if ((stringArray = (String[])this.getValue(ATTR_NOT_INDEXED, null)) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                return null;
            }
        }
        File file2 = new File(file, string);
        Resource resource = null;
        resource = this.createVirtualResource(file, requestInterface, string, hashtable);
        if (resource != null) {
            return resource;
        }
        if (!file2.exists()) {
            return null;
        }
        if (file2.isDirectory()) {
            resource = this.createDirectoryResource(file, requestInterface, string, hashtable);
        } else if (file2.isFile()) {
            resource = this.createFileResource(file, requestInterface, string, hashtable);
        } else {
            return null;
        }
        if (resource != null) {
            return resource;
        }
        String string2 = this.getSuperIndexer();
        if (string2 == null) {
            return null;
        }
        IndexerModule indexerModule = null;
        indexerModule = (IndexerModule)this.getContext().getModule(IndexerModule.NAME);
        ResourceReference resourceReference = indexerModule.getIndexer(string2);
        if (resourceReference == null) {
            return null;
        }
        try {
            ResourceIndexer resourceIndexer = (ResourceIndexer)((Object)resourceReference.lock());
            Resource resource2 = resourceIndexer != null ? resourceIndexer.createResource(containerResource, requestInterface, file, string, hashtable) : null;
            return resource2;
        }
        catch (InvalidResourceException invalidResourceException) {
            Resource resource3 = null;
            return resource3;
        }
        finally {
            resourceReference.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIndexedName(File file, String string) {
        File file2;
        if (isWinPlatform) {
            for (int i = 0; i < harmfulNames.length; ++i) {
                if (!string.equalsIgnoreCase(harmfulNames[i])) continue;
                return null;
            }
        }
        if (!(file2 = new File(file, string)).exists()) {
            return null;
        }
        if (file2.isDirectory()) {
            return this.getIndexedDirName(string);
        }
        String[] stringArray = this.getFileExtensions(string);
        ResourceReference resourceReference = null;
        if (stringArray == null) {
            return null;
        }
        for (int i = stringArray.length - 1; i >= 0 && (resourceReference = this.getTemplateFor(stringArray[i])) == null; --i) {
        }
        if (resourceReference != null) {
            return this.getIndexedFileName(string);
        }
        String string2 = this.getSuperIndexer();
        if (string2 == null) {
            return null;
        }
        IndexerModule indexerModule = null;
        indexerModule = (IndexerModule)this.getContext().getModule(IndexerModule.NAME);
        ResourceReference resourceReference2 = indexerModule.getIndexer(string2);
        if (resourceReference2 == null) {
            return null;
        }
        try {
            ResourceIndexer resourceIndexer = (ResourceIndexer)((Object)resourceReference2.lock());
            String string3 = resourceIndexer != null ? resourceIndexer.getIndexedName(file, string) : null;
            return string3;
        }
        catch (InvalidResourceException invalidResourceException) {
            String string4 = null;
            return string4;
        }
        finally {
            resourceReference2.unlock();
        }
    }

    protected String getIndexedFileName(String string) {
        return string;
    }

    protected String getIndexedDirName(String string) {
        return string;
    }

    public SampleResourceIndexer(ResourceContext resourceContext) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(3);
        String string = "identifier".intern();
        String string2 = "context".intern();
        hashtable.put(string2, resourceContext);
        hashtable.put(string, "default");
        this.initialize(hashtable);
    }

    public SampleResourceIndexer() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Attribute attribute = null;
        Class clazz = class$org$w3c$tools$resources$indexer$SampleResourceIndexer == null ? (class$org$w3c$tools$resources$indexer$SampleResourceIndexer = SampleResourceIndexer.class$("org.w3c.tools.resources.indexer.SampleResourceIndexer")) : class$org$w3c$tools$resources$indexer$SampleResourceIndexer;
        attribute = new StringAttribute("super-indexer", null, 2);
        ATTR_SUPER_INDEXER = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringArrayAttribute("not-indexed-names", null, 2);
        ATTR_NOT_INDEXED = AttributeRegistry.registerAttribute(clazz, attribute);
        noextension = new String[]{"*noextension*"};
    }
}

