/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import org.w3c.util.ArrayDictionary;
import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.ParseState;

public class HttpChallenge
extends BasicValue {
    String scheme = null;
    ArrayDictionary params = null;
    ArrayDictionary unqparams = null;

    public HttpChallenge getClone() {
        try {
            return (HttpChallenge)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void parse() throws HttpParserException {
        ParseState parseState = new ParseState(this.roff, this.rlen);
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.error("Invalid challenge: no scheme.");
        }
        this.scheme = parseState.toString(this.raw);
        ParseState parseState2 = new ParseState();
        parseState2.separator = (byte)61;
        parseState.separator = (byte)44;
        parseState.prepare();
        while (HttpParser.nextItem(this.raw, parseState) >= 0) {
            parseState2.prepare(parseState);
            if (HttpParser.nextItem(this.raw, parseState2) < 0) {
                this.error("Invalid challenge: no param name.");
            }
            String string = parseState2.toString(this.raw, true);
            parseState2.prepare();
            if (HttpParser.nextItem(this.raw, parseState2) < 0) {
                this.error("Invalid challenge: no param value.");
            }
            parseState2.ioff = parseState2.start;
            int n = HttpParser.skipSpaces(this.raw, parseState2);
            if (n < this.raw.length && this.raw[n] == 34) {
                HttpParser.unquote(this.raw, parseState2);
                if (this.params == null) {
                    this.params = new ArrayDictionary(5, 5);
                }
                this.params.put(string, parseState2.toString(this.raw));
            } else {
                if (this.unqparams == null) {
                    this.unqparams = new ArrayDictionary(5, 5);
                }
                this.unqparams.put(string, parseState2.toString(this.raw));
            }
            parseState.prepare();
        }
    }

    protected void updateByteValue() {
        String string;
        int n;
        int n2;
        HttpBuffer httpBuffer = new HttpBuffer();
        httpBuffer.append(this.scheme);
        httpBuffer.append(' ');
        int n3 = 0;
        if (this.params != null) {
            n3 = this.params.size();
        }
        if (this.unqparams != null) {
            n3 += this.unqparams.size();
        }
        if (this.params != null) {
            n2 = this.params.size();
            for (n = 0; n < n2; ++n) {
                string = (String)this.params.keyAt(n);
                if (string == null) continue;
                httpBuffer.appendQuoted(string, (byte)61, (String)this.params.elementAt(n));
                if (--n3 <= 0) continue;
                httpBuffer.append((byte)44);
                httpBuffer.append((byte)32);
            }
        }
        if (this.unqparams != null) {
            n2 = this.unqparams.size();
            for (n = 0; n < n2; ++n) {
                string = (String)this.unqparams.keyAt(n);
                if (string == null) continue;
                httpBuffer.append(string, (byte)61, (String)this.unqparams.elementAt(n));
                if (--n3 <= 0) continue;
                httpBuffer.append((byte)44);
                httpBuffer.append((byte)32);
            }
        }
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }

    public Object getValue() {
        this.validate();
        return this;
    }

    public String getScheme() {
        this.validate();
        return this.scheme;
    }

    public String getAuthParameter(String string) {
        this.validate();
        String string2 = null;
        if (this.params != null) {
            string2 = (String)this.params.get(string);
        }
        if (string2 == null && this.unqparams != null) {
            string2 = (String)this.unqparams.get(string);
        }
        return string2;
    }

    public void setAuthParameter(String string, String string2, boolean bl) {
        this.invalidateByteValue();
        if (bl) {
            if (this.params == null) {
                this.params = new ArrayDictionary(4, 4);
            }
            this.params.put(string, string2);
        } else {
            if (this.unqparams == null) {
                this.unqparams = new ArrayDictionary(4, 4);
            }
            this.unqparams.put(string, string2);
        }
    }

    public void setAuthParameter(String string, String string2) {
        this.setAuthParameter(string, string2, true);
    }

    HttpChallenge(boolean bl) {
        this.isValid = bl;
    }

    HttpChallenge(boolean bl, String string) {
        this.isValid = bl;
        this.scheme = string;
    }

    public HttpChallenge() {
    }
}

