/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.Icon;

class IconCache {
    private final Map<Pair<Icon, Integer>, Image> myCache = new HashMap();

    IconCache() {
    }

    public Image getIcon(Icon originalIcon, int size) {
        Pair key = new Pair((Object)originalIcon, (Object)size);
        Image image = this.myCache.get(key);
        if (image != null) {
            return image;
        }
        image = IconCache.renderIcon(originalIcon, size);
        this.myCache.put((Pair<Icon, Integer>)key, image);
        return image;
    }

    private static Image renderIcon(Icon originalIcon, int size) {
        BufferedImage image = UIUtil.createImage((int)size, (int)size, (int)2);
        Graphics2D gg = image.createGraphics();
        double isize = Math.max(originalIcon.getIconHeight(), originalIcon.getIconWidth());
        if (isize > (double)size) {
            gg.setTransform(AffineTransform.getScaleInstance((double)size / isize, (double)size / isize));
        }
        originalIcon.paintIcon(null, gg, 0, 0);
        return image;
    }
}

