/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.Cache;
import com.intellij.dsm.ui.DsmTableConstants;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.NodeVisitor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

class MaxWidthVisitor<N>
implements NodeVisitor<N> {
    int myMaxWidth = 0;
    public List<DsmTreeStructure.TreeNode<N>> myRows = new ArrayList<DsmTreeStructure.TreeNode<N>>();
    private final DsmTableImpl myDsmTable;
    private final Cache myCache;

    public MaxWidthVisitor(DsmTableImpl dsmTable, Cache cache) {
        this.myDsmTable = dsmTable;
        this.myCache = cache;
    }

    @Override
    public void visitLeaf(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean isLast) {
        int w;
        this.myRows.add(node);
        boolean superSmall = this.myCache.isSuperSmall;
        if (!superSmall) {
            Icon icon = node.getIcon();
            int iconWidth = icon != null ? icon.getIconWidth() : 0;
            w = this.myDsmTable.getFontMetrics(this.myDsmTable.getFont()).stringWidth(node.getShortName()) + 10 + DsmTableConstants.SZ_TREE_ICON + iconWidth;
        } else {
            w = this.myDsmTable.myBoxSize * 10;
        }
        this.myMaxWidth = Math.max(this.myMaxWidth, x + w);
    }

    @Override
    public void visitAfterExpanded(DsmTreeStructure.TreeNode node, int x, int y, int height, boolean isLast) {
        this.myMaxWidth = Math.max(this.myMaxWidth, x + this.myDsmTable.myBoxSize);
    }

    @Override
    public void visitBeforeExpanded(DsmTreeStructure.TreeNode node, int x, int y, int height, boolean isLast) {
    }

    @Override
    public void visitCollapsed(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean last) {
        boolean superSmall;
        this.myRows.add(node);
        int width = x + this.myDsmTable.getFontMetrics(this.myDsmTable.getFont()).stringWidth(node.getShortName()) + 10 + DsmTableConstants.SZ_TREE_ICON;
        if (node.getIcon() != null) {
            width += height + 2;
        }
        if (superSmall = this.myCache.isSuperSmall) {
            width = this.myDsmTable.myBoxSize * 10;
        }
        this.myMaxWidth = Math.max(this.myMaxWidth, width);
    }
}

