/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.DsmTableUtil;
import com.intellij.dsm.ui.SelectionVisitor;
import com.intellij.ui.JBColor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;

class PaintSelection1Visitor<N>
implements SelectionVisitor<N> {
    protected Graphics2D g;
    protected DsmTableImpl<N> myDsmTable;

    public PaintSelection1Visitor(DsmTableImpl<N> dsmTable, Graphics2D g) {
        this.myDsmTable = dsmTable;
        this.g = g;
    }

    @Override
    public final void visitRowSelection(DsmSelection<N> selection) {
        int y2 = -1;
        int y1 = Integer.MAX_VALUE;
        for (DsmTreeStructure.TreeNode node : selection.node1) {
            Rectangle r = this.myDsmTable.myCache.rowHeaderBounds.get(this.myDsmTable.getVisibleNodeAncestor(node));
            assert (r != null);
            y1 = Math.min(y1, r.y);
            y2 = Math.max(y2, r.y + r.height);
        }
        assert (y2 >= 0);
        assert (y1 < Integer.MAX_VALUE);
        this.g.setPaint((Paint)JBColor.BLACK);
        DsmTableUtil.drawRectangle(this.g, new Rectangle(y1, y1, y2 - y1, y2 - y1));
    }

    @Override
    public void visitCellSelection(DsmSelection<N> selection) {
        int y11 = Integer.MAX_VALUE;
        int y12 = -1;
        int y21 = Integer.MAX_VALUE;
        int y22 = -1;
        for (DsmTreeStructure.TreeNode node1 : selection.node1) {
            for (DsmTreeStructure.TreeNode node2 : selection.node2) {
                Rectangle r1 = this.myDsmTable.myCache.rowHeaderBounds.get(this.myDsmTable.getVisibleNodeAncestor(node1));
                Rectangle r2 = this.myDsmTable.myCache.rowHeaderBounds.get(this.myDsmTable.getVisibleNodeAncestor(node2));
                assert (r1 != null);
                assert (r2 != null);
                y11 = Math.min(y11, r1.y);
                y12 = Math.max(y12, r1.y + r1.height);
                y21 = Math.min(y21, r2.y);
                y22 = Math.max(y22, r2.y + r2.height);
            }
        }
        assert (y12 >= 0);
        assert (y11 < Integer.MAX_VALUE);
        assert (y22 >= 0);
        assert (y21 < Integer.MAX_VALUE);
        this.g.setPaint((Paint)JBColor.BLACK);
        DsmTableUtil.drawRectangle(this.g, new Rectangle(y11, y11, y12 - y11, y12 - y11));
        DsmTableUtil.drawRectangle(this.g, new Rectangle(y21, y21, y22 - y21, y22 - y21));
        DsmTableUtil.drawRectangle(this.g, new Rectangle(y21, y11, y22 - y21, y12 - y11));
        DsmTableUtil.drawRectangle(this.g, new Rectangle(y11, y21, y12 - y11, y22 - y21));
    }
}

