/*
 * Decompiled with CFR 0.152.
 */
package org.gga.graph;

import com.intellij.openapi.util.Couple;
import com.intellij.util.BooleanFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gga.graph.Edge;
import org.gga.graph.Graph;
import org.gga.graph.impl.DataGraphImpl;
import org.gga.graph.impl.SparseGraphImpl;
import org.gga.graph.maps.DataGraph;
import org.gga.graph.util.Function;
import org.gga.graph.util.IntIntFunction;

public class Morph {
    public static Graph morphGraph(Graph g, IntIntFunction map) {
        int[] vertexMap = new int[g.V()];
        int newSize = -1;
        for (int v = 0; v < g.V(); ++v) {
            int t;
            vertexMap[v] = t = map.fun(v);
            newSize = Math.max(newSize, t);
        }
        assert (++newSize > 0);
        HashSet<Couple> edges = new HashSet<Couple>();
        SparseGraphImpl result = new SparseGraphImpl(newSize, g.isDirected());
        for (int v = 0; v < g.V(); ++v) {
            Iterator<Edge> i = g.getEdges(v);
            while (i.hasNext()) {
                Edge e = i.next();
                int w = e.w();
                int v1 = vertexMap[v];
                int w1 = vertexMap[w];
                Couple p = new Couple((Object)v1, (Object)w1);
                if (edges.contains(p)) continue;
                result.insert(v1, w1);
                edges.add(p);
            }
        }
        return result;
    }

    public static <N, E> DataGraph<N, E> isomorph(DataGraph<N, E> g, IntIntFunction map) {
        int v;
        int[] vertexMap = new int[g.V()];
        int newSize = -1;
        for (int v2 = 0; v2 < g.V(); ++v2) {
            int t;
            vertexMap[v2] = t = map.fun(v2);
            newSize = Math.max(newSize, t);
        }
        assert (++newSize > 0 && newSize == g.V());
        DataGraphImpl<N, E> result = new DataGraphImpl<N, E>(newSize, g.isDirected());
        for (v = 0; v < g.V(); ++v) {
            result.setNode(vertexMap[v], g.getNode(v));
        }
        for (v = 0; v < g.V(); ++v) {
            Iterator<Edge> i = g.getIntGraph().getEdges(v);
            while (i.hasNext()) {
                Edge e = i.next();
                int w = e.w();
                int v1 = vertexMap[v];
                int w1 = vertexMap[w];
                result.insert(g.getNode(v1), g.getNode(w1), g.edge(g.getNode(v), g.getNode(w)));
            }
        }
        return result;
    }

    public static <N, E, N1, E1> DataGraph<N1, E1> morph(DataGraph<N, E> g, Function<N, N1> nodeMap, Function<List<E>, E1> verticesMap) {
        return Morph.morph(g, nodeMap, verticesMap, null);
    }

    public static <N, E, N1, E1> DataGraph<N1, E1> morph(DataGraph<N, E> g, Function<N, N1> nodeMap, Function<List<E>, E1> verticesMap, BooleanFunction<N> memberFunction, N1[] newNodes) {
        Object[] nodesDataMap = new Object[g.V()];
        for (int v = 0; v < g.V(); ++v) {
            N n = g.getNode(v);
            if (memberFunction != null && !memberFunction.fun(n)) continue;
            N1 n1 = nodeMap.fun(n);
            nodesDataMap[v] = n1;
        }
        return Morph.morph(g, verticesMap, memberFunction, nodesDataMap, newNodes);
    }

    public static <N, E, N1, E1> DataGraph<N1, E1> morph(DataGraph<N, E> g, Function<N, N1> nodeMap, Function<List<E>, E1> verticesMap, BooleanFunction<N> memberFunction) {
        Object[] nodesDataMap = new Object[g.V()];
        for (int v = 0; v < g.V(); ++v) {
            N n = g.getNode(v);
            if (memberFunction != null && !memberFunction.fun(n)) continue;
            N1 N1 = nodeMap.fun(n);
            nodesDataMap[v] = N1;
        }
        HashSet<Object> newNodesSet = new HashSet<Object>();
        ArrayList<Object> newNodesList = new ArrayList<Object>();
        for (Object object : nodesDataMap) {
            if (newNodesSet.contains(object)) continue;
            newNodesList.add(object);
            newNodesSet.add(object);
        }
        Object[] objectArray = newNodesList.toArray();
        return Morph.morph(g, verticesMap, memberFunction, nodesDataMap, objectArray);
    }

    private static <N, E, N1, E1> DataGraph<N1, E1> morph(DataGraph<N, E> g, Function<List<E>, E1> verticesMap, BooleanFunction<N> memberFunction, N1[] nodesDataMap, N1[] newNodes) {
        LinkedHashMap newEdges = new LinkedHashMap();
        for (int v = 0; v < g.V(); ++v) {
            N n = g.getNode(v);
            if (memberFunction != null && !memberFunction.fun(n)) continue;
            N1 n1 = nodesDataMap[v];
            HashMap<N1, ArrayList<E>> edges = (HashMap<N1, ArrayList<E>>)newEdges.get(n1);
            if (edges == null) {
                edges = new HashMap<N1, ArrayList<E>>();
                newEdges.put(n1, edges);
            }
            Iterator<Edge> i = g.getIntGraph().getEdges(v);
            while (i.hasNext()) {
                Edge e = i.next();
                int w = e.w();
                if (memberFunction != null && !memberFunction.fun(g.getNode(w))) continue;
                N1 n2 = nodesDataMap[w];
                ArrayList<E> list = (ArrayList<E>)edges.get(n2);
                if (list == null) {
                    list = new ArrayList<E>();
                    edges.put(n2, list);
                }
                list.add(g.getEdge(e));
            }
        }
        int newSize = newEdges.size();
        DataGraphImpl<Object, E1> result = new DataGraphImpl<Object, E1>(newSize, g.isDirected());
        for (int v = 0; v < newSize; ++v) {
            result.setNode(v, newNodes[v]);
        }
        for (Object n1 : newEdges.keySet()) {
            Map edges = (Map)newEdges.get(n1);
            for (Object n2 : edges.keySet()) {
                List oldEdges = (List)edges.get(n2);
                E1 newEdge = verticesMap.fun(oldEdges);
                result.insert(n1, n2, newEdge);
            }
        }
        return result;
    }
}

