/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud.module;

import com.intellij.javaee.openshift.agent.cloud.OSDomainConfiguration;
import com.intellij.javaee.openshift.cloud.OSCloudConfiguration;
import com.intellij.javaee.openshift.cloud.OSDeploymentConfiguration;
import com.intellij.javaee.openshift.cloud.OSEmbeddableCartridgeEditor;
import com.intellij.javaee.openshift.cloud.OSServerRuntimeInstance;
import com.intellij.javaee.openshift.cloud.module.OSApplicationConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.remoteServer.impl.module.CloudSourceApplicationConfigurable;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class OSApplicationConfigurable
extends CloudSourceApplicationConfigurable<OSCloudConfiguration, OSDeploymentConfiguration, OSServerRuntimeInstance, OSApplicationConfiguration> {
    private JPanel myMainPanel;
    private JBRadioButton myExistingRadioButton;
    private ComboBox myExistingComboBox;
    private JBRadioButton myDefaultRadioButton;
    private JCheckBox myEnableScalingCheckBox;
    private JPanel myEmbeddableCartridgePanel;
    private ComboBox myGearSizesComboBox;
    private ComboBox myStandaloneCartridgeComboBox;
    private JPanel myNewApplicationSettingsPlaceHolder;
    private JPanel myNewApplicationSettingsPanel;
    private OSEmbeddableCartridgeEditor myEmbeddableCartridgeEditor;
    private final HideableDecorator myNewAppSettingsDecorator;

    public OSApplicationConfigurable(Project project, Disposable parentDisposable) {
        super(project, parentDisposable);
        this.$$$setupUI$$$();
        ActionListener updateApplicationListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSApplicationConfigurable.this.updateApplicationUI();
            }
        };
        this.myDefaultRadioButton.addActionListener(updateApplicationListener);
        this.myExistingRadioButton.addActionListener(updateApplicationListener);
        this.myExistingComboBox.addActionListener(updateApplicationListener);
        this.myStandaloneCartridgeComboBox.addActionListener(updateApplicationListener);
        this.myExistingRadioButton.setSelected(true);
        this.myNewAppSettingsDecorator = new HideableDecorator(this.myNewApplicationSettingsPlaceHolder, "New Application Settings", false);
        this.myNewAppSettingsDecorator.setContentComponent((JComponent)this.myNewApplicationSettingsPanel);
        this.myNewAppSettingsDecorator.setOn(false);
    }

    protected JComboBox getExistingComboBox() {
        return this.myExistingComboBox;
    }

    public void clearCloudData() {
        this.myStandaloneCartridgeComboBox.removeAllItems();
        this.myGearSizesComboBox.removeAllItems();
        this.myEmbeddableCartridgeEditor.setEmbeddableCartridges(ArrayUtil.EMPTY_STRING_ARRAY);
        super.clearCloudData();
    }

    protected void loadCloudData() {
        super.loadCloudData();
        this.reloadCartridges();
    }

    private void reloadCartridges() {
        new CloudSourceApplicationConfigurable.ConnectionTask<OSDomainConfiguration>("Loading application configuration"){

            protected OSDomainConfiguration run(OSServerRuntimeInstance serverRuntime) throws ServerRuntimeException {
                return serverRuntime.getConfigurationDomain();
            }

            protected void postPerform(OSDomainConfiguration domainConfiguration) {
                OSApplicationConfigurable.this.myStandaloneCartridgeComboBox.removeAllItems();
                for (String sCartridge : domainConfiguration.getStandaloneCartridges()) {
                    OSApplicationConfigurable.this.myStandaloneCartridgeComboBox.addItem((Object)sCartridge);
                }
                OSApplicationConfigurable.this.myGearSizesComboBox.removeAllItems();
                for (String gearSize : domainConfiguration.getGearSizes()) {
                    OSApplicationConfigurable.this.myGearSizesComboBox.addItem((Object)gearSize);
                }
                OSApplicationConfigurable.this.myEmbeddableCartridgeEditor.setEmbeddableCartridges(domainConfiguration.getEmbeddableCartridges());
            }
        }.performAsync();
    }

    protected void updateApplicationUI() {
        boolean isExisting = this.myExistingRadioButton.isSelected();
        boolean isDefault = this.myDefaultRadioButton.isSelected();
        this.myExistingComboBox.setEnabled(isExisting);
        this.myGearSizesComboBox.setEnabled(isDefault);
        this.myStandaloneCartridgeComboBox.setEnabled(isDefault);
        this.myEmbeddableCartridgeEditor.setEnabledPanel(isDefault);
        this.myEnableScalingCheckBox.setEnabled(isDefault);
        this.myNewAppSettingsDecorator.setEnabled(isDefault);
        if (!isDefault) {
            this.myNewAppSettingsDecorator.setOn(false);
        }
    }

    public JComponent getMainPanel() {
        return this.myMainPanel;
    }

    public OSApplicationConfiguration createConfiguration() {
        return new OSApplicationConfiguration(this.myDefaultRadioButton.isSelected(), (String)this.myStandaloneCartridgeComboBox.getSelectedItem(), this.myEmbeddableCartridgeEditor.getEmbeddableCartridges(), this.myEnableScalingCheckBox.isSelected(), (String)this.myGearSizesComboBox.getSelectedItem(), this.myExistingRadioButton.isSelected(), (String)this.myExistingComboBox.getSelectedItem());
    }

    public void validate() throws ConfigurationException {
        if (this.myExistingRadioButton.isSelected() && this.myExistingComboBox.getSelectedItem() == null) {
            throw new ConfigurationException("Existing application should be chosen");
        }
        if (this.myDefaultRadioButton.isSelected() && this.myStandaloneCartridgeComboBox.getSelectedItem() == null) {
            throw new ConfigurationException("Standalone cartridge should be chosen");
        }
    }

    private void createUIComponents() {
        this.myEmbeddableCartridgeEditor = new OSEmbeddableCartridgeEditor();
        this.myEmbeddableCartridgePanel = this.myEmbeddableCartridgeEditor.getMainPanel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        ComboBox comboBox2;
        JCheckBox jCheckBox;
        ComboBox comboBox3;
        JPanel jPanel;
        JPanel jPanel2;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myExistingRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setSelected(true);
        jBRadioButton2.setText("Existing:");
        jPanel3.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDefaultRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setSelected(false);
        jBRadioButton.setEnabled(true);
        jBRadioButton.setText("New:");
        jBRadioButton.setHideActionText(false);
        jPanel3.add((Component)jBRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(70, 20), null));
        this.myNewApplicationSettingsPlaceHolder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myNewApplicationSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "Center");
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Gear size:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGearSizesComboBox = comboBox3 = new ComboBox();
        jPanel.add((Component)comboBox3, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, new Dimension(315, 24), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Scaling:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myEnableScalingCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("");
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Embeddable Cartridges:");
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel4 = this.myEmbeddableCartridgePanel;
        jPanel.add((Component)jPanel4, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 200), null));
        this.myExistingComboBox = comboBox2 = new ComboBox();
        jPanel3.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Standalone Cartridge:");
        jPanel3.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStandaloneCartridgeComboBox = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

