/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references.libraries.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class DoubleReferenceProvider
extends PsiReferenceProvider {
    public static final String NAME = "double";
    private static DoubleReferenceProvider myInstance = null;

    public static DoubleReferenceProvider getInstance() {
        if (myInstance == null) {
            myInstance = new DoubleReferenceProvider();
        }
        return myInstance;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/references/libraries/providers/DoubleReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jsf/references/libraries/providers/DoubleReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof XmlElement) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new DoublePsiReference((XmlElement)element)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/libraries/providers/DoubleReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/libraries/providers/DoubleReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static class DoublePsiReference
    extends PsiReferenceBase<XmlElement>
    implements EmptyResolveMessageProvider {
        public DoublePsiReference(XmlElement element) {
            super((PsiElement)element);
        }

        public PsiElement resolve() {
            String value = this.getValue();
            if (!StringUtil.isEmptyOrSpaces((String)value)) {
                try {
                    Double.valueOf(value);
                    return this.getElement();
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }

        @NotNull
        public Object[] getVariants() {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/libraries/providers/DoubleReferenceProvider$DoublePsiReference", "getVariants"));
            }
            return EMPTY_ARRAY;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = FacesBundle.message("value.format.exception.for.class", this.getValue(), Double.class.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/libraries/providers/DoubleReferenceProvider$DoublePsiReference", "getUnresolvedMessagePattern"));
            }
            return string;
        }
    }
}

