/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.intellij.javaee.openshift.agent.cloud.ApiTask;
import com.intellij.javaee.openshift.agent.cloud.OS3ProjectImpl;
import com.intellij.javaee.openshift.agent.cloud.OSCloudAgentConfig;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3CloudAgent;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Project;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.openshift.restclient.ClientFactory;
import com.openshift.restclient.IClient;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.NoopSSLCertificateCallback;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.authorization.AuthorizationClientFactory;
import com.openshift.restclient.authorization.BasicAuthorizationStrategy;
import com.openshift.restclient.authorization.IAuthorizationClient;
import com.openshift.restclient.authorization.IAuthorizationContext;
import com.openshift.restclient.authorization.IAuthorizationStrategy;
import com.openshift.restclient.authorization.TokenAuthorizationStrategy;
import com.openshift.restclient.model.IProject;
import java.util.ArrayList;
import java.util.List;

public class OS3CloudAgentImpl
implements OS3CloudAgent {
    private IClient myClient;
    private CloudAgentErrorHandler myErrorHandler;

    public void connect(final OSCloudAgentConfig config, CloudAgentErrorHandler errorHandler, CloudAgentLogger logger) {
        this.myErrorHandler = errorHandler;
        new ApiTask(this.myErrorHandler){

            protected Object doPerform() throws OpenShiftException {
                OS3CloudAgentImpl.this.myClient = new ClientFactory().create(config.getLibraServer(), (ISSLCertificateCallback)new NoopSSLCertificateCallback());
                OS3CloudAgentImpl.this.myClient.setAuthorizationStrategy((IAuthorizationStrategy)new BasicAuthorizationStrategy(config.getEmail(), config.getPassword(), ""));
                IAuthorizationClient authClient = new AuthorizationClientFactory().create(OS3CloudAgentImpl.this.myClient);
                IAuthorizationContext context = authClient.getContext(OS3CloudAgentImpl.this.myClient.getBaseURL().toString());
                OS3CloudAgentImpl.this.myClient.setAuthorizationStrategy((IAuthorizationStrategy)new TokenAuthorizationStrategy(context.getToken()));
                OS3CloudAgentImpl.this.myClient.getOpenShiftAPIVersion();
                return null;
            }
        }.perform();
    }

    public OS3Project[] getApplications() {
        return (OS3Project[])new ApiTask<OS3Project[]>(this.myErrorHandler){

            @Override
            protected OS3Project[] doPerform() throws OpenShiftException {
                List projects = OS3CloudAgentImpl.this.myClient.list("Project");
                ArrayList<OS3ProjectImpl> result = new ArrayList<OS3ProjectImpl>();
                for (IProject project : projects) {
                    result.add(new OS3ProjectImpl(project));
                }
                return result.toArray(new OS3Project[result.size()]);
            }
        }.perform();
    }
}

