/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.intellij.javaee.openshift.agent.cloud.OS3ServiceImpl;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Project;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Service;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IService;
import java.util.ArrayList;
import java.util.List;

public class OS3ProjectImpl
implements OS3Project {
    private String myDisplayName;
    private String myDescription;
    private OS3Service[] myServices;
    private String myName;

    public OS3ProjectImpl(IProject project) {
        this.myDisplayName = project.getDisplayName();
        this.myDescription = project.getDescription();
        this.myServices = OS3ProjectImpl.wrapServices(project.getResources("Service"));
        this.myName = project.getName();
    }

    private static OS3Service[] wrapServices(List<IService> services) {
        ArrayList<OS3ServiceImpl> result = new ArrayList<OS3ServiceImpl>();
        for (IService iService : services) {
            result.add(new OS3ServiceImpl(iService));
        }
        return result.toArray(new OS3Service[result.size()]);
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public OS3Service[] getServices() {
        return this.myServices;
    }

    public String getName() {
        return this.myName;
    }

    public String getWebUrl() {
        return null;
    }
}

