/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.intellij.javaee.openshift.agent.cloud.OS3PodImpl;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Pod;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Service;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3ServicePort;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.IServicePort;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OS3ServiceImpl
implements OS3Service {
    private String myServiceName;
    private int myPort;
    private String myPortalIp;
    private OS3Pod[] myPods;
    private OS3ServicePort[] myServicePorts;
    private Map<String, String> mySelector;

    public OS3ServiceImpl(IService service) {
        this.myServiceName = service.getName();
        this.myPort = service.getPort();
        this.myPortalIp = service.getPortalIP();
        this.myPods = OS3ServiceImpl.wrapPods(service.getPods());
        this.myServicePorts = OS3ServiceImpl.wrapServicePorts(service.getPorts());
        this.mySelector = service.getSelector();
    }

    private static OS3ServicePort[] wrapServicePorts(List<IServicePort> ports) {
        ArrayList<1> result = new ArrayList<1>();
        for (final IServicePort servicePort : ports) {
            result.add(new OS3ServicePort(){

                public String getName() {
                    return servicePort.getName();
                }

                public int getPort() {
                    return servicePort.getPort();
                }

                public int getTargetPort() {
                    return servicePort.getTargetPort();
                }

                public String getProtocol() {
                    return servicePort.getProtocol();
                }
            });
        }
        return result.toArray(new OS3ServicePort[result.size()]);
    }

    private static OS3Pod[] wrapPods(List<IPod> pods) {
        ArrayList<OS3PodImpl> result = new ArrayList<OS3PodImpl>();
        for (IPod pod : pods) {
            result.add(new OS3PodImpl(pod));
        }
        return result.toArray(new OS3Pod[result.size()]);
    }

    public String getServiceName() {
        return this.myServiceName;
    }

    public OS3Pod[] getPods() {
        return this.myPods;
    }

    public int getPort() {
        return this.myPort;
    }

    public String getPortalIp() {
        return this.myPortalIp;
    }

    public OS3ServicePort[] getServicePorts() {
        return this.myServicePorts;
    }

    public Map<String, String> getSelector() {
        return this.mySelector;
    }
}

