/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.FormHighlightingPass;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.editor.MyEditorState;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class UIFormEditor
extends UserDataHolderBase
implements FileEditor {
    private final VirtualFile myFile;
    private final GuiEditor myEditor;
    private MyBackgroundEditorHighlighter myBackgroundEditorHighlighter;

    public UIFormEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/uiDesigner/editor/UIFormEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/uiDesigner/editor/UIFormEditor", "<init>"));
        }
        VirtualFile vf = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getOriginalFile() : file;
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vf, (Project)project);
        if (module == null) {
            throw new IllegalArgumentException("No module for file " + file + " in project " + project);
        }
        this.myFile = file;
        this.myEditor = new GuiEditor(this, project, module, file);
    }

    @NotNull
    public JComponent getComponent() {
        GuiEditor guiEditor = this.myEditor;
        if (guiEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/editor/UIFormEditor", "getComponent"));
        }
        return guiEditor;
    }

    public void dispose() {
        this.myEditor.dispose();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        String string = UIDesignerBundle.message("title.gui.designer", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/editor/UIFormEditor", "getName"));
        }
        return string;
    }

    public GuiEditor getEditor() {
        return this.myEditor;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return FileDocumentManager.getInstance().getDocument(this.myFile) != null && this.myFile.getFileType() == StdFileTypes.GUI_DESIGNER_FORM;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/uiDesigner/editor/UIFormEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/uiDesigner/editor/UIFormEditor", "removePropertyChangeListener"));
        }
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        if (this.myBackgroundEditorHighlighter == null) {
            this.myBackgroundEditorHighlighter = new MyBackgroundEditorHighlighter(this.myEditor);
        }
        return this.myBackgroundEditorHighlighter;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel ignored) {
        if (ignored == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignored", "com/intellij/uiDesigner/editor/UIFormEditor", "getState"));
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(this.myFile);
        long modificationStamp = document != null ? document.getModificationStamp() : this.myFile.getModificationStamp();
        ArrayList<RadComponent> selection = FormEditingUtil.getSelectedComponents(this.myEditor);
        String[] ids = new String[selection.size()];
        for (int i = ids.length - 1; i >= 0; --i) {
            ids[i] = selection.get(i).getId();
        }
        MyEditorState myEditorState = new MyEditorState(modificationStamp, ids);
        if (myEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/editor/UIFormEditor", "getState"));
        }
        return myEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        String[] ids;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/uiDesigner/editor/UIFormEditor", "setState"));
        }
        FormEditingUtil.clearSelection(this.myEditor.getRootContainer());
        for (String id : ids = ((MyEditorState)state).getSelectedComponentIds()) {
            RadComponent component = (RadComponent)FormEditingUtil.findComponent(this.myEditor.getRootContainer(), id);
            if (component == null) continue;
            component.setSelected(true);
        }
    }

    public void selectComponent(@NotNull String binding) {
        if (binding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binding", "com/intellij/uiDesigner/editor/UIFormEditor", "selectComponent"));
        }
        RadComponent component = (RadComponent)FormEditingUtil.findComponentWithBinding(this.myEditor.getRootContainer(), binding);
        if (component != null) {
            FormEditingUtil.selectSingleComponent(this.getEditor(), component);
        }
    }

    public void selectComponentById(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/uiDesigner/editor/UIFormEditor", "selectComponentById"));
        }
        RadComponent component = (RadComponent)FormEditingUtil.findComponent(this.myEditor.getRootContainer(), id);
        if (component != null) {
            FormEditingUtil.selectSingleComponent(this.getEditor(), component);
        }
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    private static class MyBackgroundEditorHighlighter
    implements BackgroundEditorHighlighter {
        private final HighlightingPass[] myPasses;

        public MyBackgroundEditorHighlighter(GuiEditor editor) {
            this.myPasses = new HighlightingPass[]{new FormHighlightingPass(editor)};
        }

        @NotNull
        public HighlightingPass[] createPassesForEditor() {
            if (this.myPasses == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/editor/UIFormEditor$MyBackgroundEditorHighlighter", "createPassesForEditor"));
            }
            return this.myPasses;
        }

        @NotNull
        public HighlightingPass[] createPassesForVisibleArea() {
            if (HighlightingPass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/editor/UIFormEditor$MyBackgroundEditorHighlighter", "createPassesForVisibleArea"));
            }
            return HighlightingPass.EMPTY_ARRAY;
        }
    }
}

