/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.cmdline.BuildRunner;
import org.jetbrains.jps.cmdline.JpsModelLoader;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.incremental.artifacts.JpsBuilderArtifactService;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.ExplodedDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.serialization.JpsSerializationManager;

public class WebSphereLooseApplicationProcessor {
    private static final Logger LOG = Logger.getInstance((String)("#" + WebSphereLooseApplicationProcessor.class.getName()));
    private static final String ARCHIVE_ELEMENT_NAME = "archive";
    private static final String DIR_ELEMENT_NAME = "dir";
    private static final String FILE_ELEMENT_NAME = "file";
    private static final String SRC_ATTRIBUTE_NAME = "sourceOnDisk";
    private static final String TARGET_ATTRIBUTE_NAME = "targetInArchive";
    private ProjectDescriptor myProjectDescriptor;
    private Collection<JpsArtifact> myArtifacts;
    private JpsModel myJpsModel;
    private JpsModelLoader myModelLoader;

    public Document getLooseApplication(File source, Project project) throws IOException {
        String path = project.getBasePath();
        LOG.assertTrue(path != null);
        this.myJpsModel = JpsSerializationManager.getInstance().loadModel(path, null);
        this.myModelLoader = () -> this.myJpsModel;
        this.myArtifacts = JpsBuilderArtifactService.getInstance().getArtifacts(this.myJpsModel, true);
        JpsArtifact artifact = this.getArtifact(source.getAbsolutePath());
        this.createProjectDescriptor();
        if (artifact == null) {
            throw new IOException("Loose application has not been created");
        }
        Element root = new Element(ARCHIVE_ELEMENT_NAME);
        Document document = new Document(root);
        document.setRootElement(root);
        this.buildLooseApplication(source, artifact, root);
        return document;
    }

    private void buildLooseApplication(File source, JpsArtifact artifact, Element root) throws IOException {
        HashSet jars = new HashSet();
        for (ArtifactRootDescriptor descriptor : this.myProjectDescriptor.getBuildRootIndex().getTargetRoots((BuildTarget)new ArtifactBuildTarget(artifact), null)) {
            DestinationInfo destination = descriptor.getDestinationInfo();
            if (destination instanceof ExplodedDestinationInfo) {
                this.processArtifactDescriptor(descriptor, source, root);
                continue;
            }
            jars.add(((JarDestinationInfo)destination).getJarInfo());
        }
        this.buildArchives((Set<JarInfo>)jars, root, source);
    }

    private void buildArchives(Set<JarInfo> jars, Element root, File source) throws IOException {
        Object jarsToBuild = new HashSet();
        if (jars.size() > 1) {
            for (JarInfo jarInfo : jars) {
                DestinationInfo destination = jarInfo.getDestination();
                if (!StringUtil.equals((CharSequence)destination.getOutputPath(), (CharSequence)destination.getOutputFilePath())) continue;
                jarsToBuild.add(jarInfo);
            }
        } else {
            jarsToBuild = jars;
        }
        Iterator<Object> iterator = jarsToBuild.iterator();
        while (iterator.hasNext()) {
            JarInfo jar = (JarInfo)iterator.next();
            String target = WebSphereLooseApplicationProcessor.createTargetPath(jar.getDestination(), source);
            Element nestedRoot = WebSphereLooseApplicationProcessor.addArchiveElement(root, target);
            for (Pair pair : jar.getContent()) {
                if (pair.getSecond() instanceof ArtifactRootDescriptor) {
                    ArtifactRootDescriptor descriptor = (ArtifactRootDescriptor)pair.getSecond();
                    this.processArtifactDescriptor(descriptor, source, nestedRoot);
                    continue;
                }
                JarInfo nestedJar = (JarInfo)pair.getSecond();
                this.buildArchives(Collections.singleton(nestedJar), nestedRoot, new File(nestedJar.getDestination().getOutputFilePath()));
            }
        }
    }

    private void processArtifactDescriptor(ArtifactRootDescriptor descriptor, File source, Element root) throws IOException {
        File rootFile = descriptor.getRootFile();
        String rootFilePath = rootFile.getAbsolutePath();
        String target = WebSphereLooseApplicationProcessor.createTargetPath(descriptor.getDestinationInfo(), source);
        JpsArtifact nestedArtifact = this.getArtifact(rootFilePath);
        if (nestedArtifact != null) {
            Element nestedRoot = WebSphereLooseApplicationProcessor.addArchiveElement(root, target);
            this.buildLooseApplication(rootFile, nestedArtifact, nestedRoot);
        } else if (rootFile.exists()) {
            WebSphereLooseApplicationProcessor.addContentElement(root, rootFile, rootFilePath, target);
        }
    }

    private static String createTargetPath(DestinationInfo destination, File source) {
        String outputFilePath = StringUtil.trimStart((String)FileUtil.toSystemIndependentName((String)destination.getOutputFilePath()), (String)FileUtil.toSystemIndependentName((String)source.getAbsolutePath()));
        return destination instanceof JarDestinationInfo ? ((JarDestinationInfo)destination).getPathInJar() : (outputFilePath.isEmpty() ? "/" : outputFilePath);
    }

    private static Element addArchiveElement(Element root, String target) {
        Element nestedRoot = root;
        if (target.length() > 1) {
            nestedRoot = new Element(ARCHIVE_ELEMENT_NAME);
            nestedRoot.setAttribute(TARGET_ATTRIBUTE_NAME, target);
            root.addContent(nestedRoot);
        }
        return nestedRoot;
    }

    private static void addContentElement(Element root, File source, String sourcePath, String target) {
        Element content = new Element(source.isDirectory() ? DIR_ELEMENT_NAME : FILE_ELEMENT_NAME);
        content.setAttribute(SRC_ATTRIBUTE_NAME, sourcePath);
        content.setAttribute(TARGET_ATTRIBUTE_NAME, target.isEmpty() ? "/" : target);
        root.addContent(content);
    }

    private JpsArtifact getArtifact(String outputPath) throws IOException {
        for (JpsArtifact artifact : this.myArtifacts) {
            String artifactOutput = artifact.getOutputFilePath();
            if (artifactOutput == null || !FileUtil.normalize((String)outputPath).equals(FileUtil.normalize((String)artifactOutput))) continue;
            return artifact;
        }
        return null;
    }

    private void createProjectDescriptor() throws IOException {
        File dataStorageRoot = FileUtil.createTempDirectory((String)("websphere-loose-app-" + this.myJpsModel.getProject().getName()), null);
        this.myProjectDescriptor = new BuildRunner(this.myModelLoader).load(msg -> LOG.debug(msg.getMessageText()), dataStorageRoot, new BuildFSState(true));
    }
}

