/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.runDebug.configuration;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.j2ee.webSphere.admin.WebSphereAdminServerImpl;
import com.intellij.j2ee.webSphere.admin.WebSphereAdminServerParameters;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersion;
import com.intellij.j2ee.webSphere.deploymentSource.LooseApplicationDeploymentSource;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereModel;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereProfileHandler;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereRemoteModel;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.admin.JavaeeAdmin;
import com.intellij.javaee.oss.agent.ProcessAgentProxyFactory;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.ui.packaging.WebApplicationArtifactType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.util.Consumer;

public abstract class WebSphereFullHandler
implements WebSphereProfileHandler {
    private final WebSphereModel myServerModel;
    private final WebSphereVersion myVersion;

    public WebSphereFullHandler(WebSphereModel serverModel, WebSphereVersion version) {
        this.myServerModel = serverModel;
        this.myVersion = version;
    }

    protected final WebSphereModel getServerModel() {
        return this.myServerModel;
    }

    protected final WebSphereVersion getVersion() {
        return this.myVersion;
    }

    @Override
    public boolean isDetectableServerPort() {
        return true;
    }

    @Override
    public JavaeeAdmin createServerAdmin(JavaeeServerInstance serverInstance) throws Exception {
        ProcessAgentProxyFactory agentProxyFactory = new ProcessAgentProxyFactory(serverInstance){

            protected Sdk getJdk() {
                return JavaSdk.getInstance().createJdk("WebSphere IBM JDK", WebSphereFullHandler.this.myServerModel.getPathUnderHome("java").getAbsolutePath(), false);
            }

            protected void customizeParameters(JavaParameters javaParameters) {
                if (JdkUtil.useDynamicClasspath((Project)WebSphereFullHandler.this.myServerModel.getCommonModel().getProject())) {
                    javaParameters.getVMParametersList().addProperty("idea.do.not.escape.classpath.url", Boolean.TRUE.toString());
                }
            }
        };
        Consumer profileConsumer = profile -> {
            if (this.myServerModel instanceof WebSphereRemoteModel) {
                ((WebSphereRemoteModel)this.myServerModel).parseProfile((String)profile);
            }
        };
        return new WebSphereAdminServerImpl(agentProxyFactory, this.myServerModel.getLibraries(), this.myVersion, this.getAdminServerParameters(), this.isDeploymentSupported(), (Consumer<String>)profileConsumer);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        for (DeploymentModel deploymentModel : this.myServerModel.getCommonModel().getDeploymentModels()) {
            this.checkDeploymentSource(deploymentModel);
            Artifact artifact = deploymentModel.getArtifact();
            if (artifact == null) continue;
            this.checkArtifactType(artifact.getArtifactType());
        }
    }

    protected void checkArtifactType(ArtifactType type) throws RuntimeConfigurationException {
        if (type instanceof WebApplicationArtifactType) {
            throw new RuntimeConfigurationError("WebSphere Full profile doesn't support deployment of WARs");
        }
    }

    protected void checkDeploymentSource(DeploymentModel model) throws RuntimeConfigurationException {
        if (model.getDeploymentSource() instanceof LooseApplicationDeploymentSource) {
            throw new RuntimeConfigurationError("WebSphere Full profile doesn't support deployment of Loose applications");
        }
    }

    @Override
    public String getDebugEnvVarName() {
        return "DEBUG";
    }

    protected abstract WebSphereAdminServerParameters getAdminServerParameters() throws RuntimeConfigurationException;

    protected abstract boolean isDeploymentSupported();
}

