/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.runDebug.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.j2ee.webSphere.WebSphereBundle;
import com.intellij.j2ee.webSphere.configuration.WebSphereProfile;
import com.intellij.j2ee.webSphere.configuration.WebSphereServerConfiguration;
import com.intellij.javaee.run.localRun.ColoredCommandLineExecutableObject;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.javaee.run.localRun.ScriptUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.ArrayUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class WebSphereStartupExecutable
implements ExecutableObject {
    @NonNls
    public static final String DEBUG_ENV_VARIABLE = "DEBUG";
    private static final Logger LOG = Logger.getInstance((String)("#" + WebSphereStartupExecutable.class.getName()));
    @NonNls
    private static final String GENERATED_WEBSPHERE_SERVER_START_SCRIPT_NAME = "generated_websphere_server_start_script";
    @NonNls
    private static final String GENERATE_SCRIPT_ARG = "-script";
    @NonNls
    private static final String FROM_WIN_SERVICE_ARG = "-fromWinService";
    @NonNls
    private static final String SET_DEBUG_MODE_PORPERTY = "-Dwas.debug.mode=true";
    private final WebSphereServerConfiguration myConfiguration;
    private final WebSphereProfile myProfile;

    public WebSphereStartupExecutable(WebSphereServerConfiguration configuration) {
        this.myConfiguration = configuration;
        this.myProfile = this.myConfiguration.getProfile();
    }

    public String getDisplayString() {
        return WebSphereBundle.message("generated.server.startup.script.disaplay.text", new Object[0]);
    }

    public OSProcessHandler createProcessHandler(String workingDirectory, Map<String, String> envVariables) throws ExecutionException {
        try {
            File scriptDir = this.myProfile.getStartupScriptFile().getParentFile();
            final File scriptFile = new File(scriptDir, "generated_websphere_server_start_script." + ScriptUtil.getScriptExtension());
            scriptFile.delete();
            GeneralCommandLine commandLine = ScriptUtil.createCommandLine((String[])this.getScriptGenerationCommandLine(scriptFile));
            commandLine.setWorkDirectory(scriptDir);
            LOG.debug("generation script is about to start");
            OSProcessHandler generationProcessHandler = new OSProcessHandler(commandLine);
            Process process = generationProcessHandler.getProcess();
            generationProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    LOG.debug("text: " + event.getText());
                }
            });
            generationProcessHandler.startNotify();
            generationProcessHandler.waitFor();
            if (!scriptFile.exists()) {
                String message = WebSphereStartupExecutable.readLine(process.getErrorStream());
                if (message == null) {
                    message = WebSphereStartupExecutable.readLine(process.getInputStream());
                }
                throw new IOException(message);
            }
            ScriptUtil.makeExecutable((File)scriptFile);
            scriptFile.deleteOnExit();
            WebSphereStartupExecutable.patchDebugEnvVar(envVariables, DEBUG_ENV_VARIABLE);
            ColoredCommandLineExecutableObject executableObject = new ColoredCommandLineExecutableObject(new String[]{scriptFile.getAbsolutePath()}, "");
            OSProcessHandler processHandler = executableObject.createProcessHandler(this.myProfile.getStartupScriptFile().getParent(), envVariables);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    scriptFile.delete();
                }
            });
            return processHandler;
        }
        catch (IOException e) {
            throw new ExecutionException(WebSphereBundle.message("error.while.creating.server.start.script.file.text", e.getLocalizedMessage()));
        }
    }

    public static void patchDebugEnvVar(Map<String, String> envVariables, String debugEnvVar) {
        String debug = envVariables.get(debugEnvVar);
        if (debug != null) {
            envVariables.put(debugEnvVar, debug + " " + SET_DEBUG_MODE_PORPERTY);
        }
    }

    private static String readLine(InputStream errorStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(errorStream));
        return bufferedReader.readLine();
    }

    private String[] getScriptGenerationCommandLine(File scriptFile) {
        String[] base = new String[]{this.myProfile.getStartupScriptFile().getAbsolutePath(), this.myConfiguration.getServerName(), GENERATE_SCRIPT_ARG, scriptFile.getName()};
        if (!this.myProfile.getVersion().isStartingAsServiceImplemented()) {
            return base;
        }
        return ArrayUtil.mergeArrays((String[])base, (String[])new String[]{FROM_WIN_SERVICE_ARG, scriptFile.getParentFile().getAbsolutePath()});
    }
}

