/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.actions;

import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiNameHelper;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.actions.ArtefactData;
import org.jetbrains.plugins.grails.actions.GrailsActionUtilKt;
import org.jetbrains.plugins.grails.artefact.api.GrailsArtefactHandler;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutorUtil;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public abstract class NewGrailsXXXAction
extends AnAction
implements DumbAware {
    @NotNull
    private final String myPopupTextKey;

    protected NewGrailsXXXAction(@NotNull @PropertyKey(resourceBundle="org.jetbrains.plugins.grails.GrailsBundle") String projectViewTextKey) {
        if (projectViewTextKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectViewTextKey", "org/jetbrains/plugins/grails/actions/NewGrailsXXXAction", "<init>"));
        }
        this.myPopupTextKey = projectViewTextKey;
    }

    protected static String canonicalize(String name) {
        if (name == null || name.length() == 0) {
            return "";
        }
        int i = name.lastIndexOf(".");
        if (i > 0 && i < name.length() - 1) {
            String tail = name.substring(i + 1);
            String head = name.substring(0, i);
            return (head + "/" + StringUtil.capitalize((String)tail)).replace('.', '/');
        }
        name = name.replace('.', '/');
        return StringUtil.capitalize((String)name);
    }

    public void actionPerformed(AnActionEvent e) {
        Object aPackage;
        PsiDirectory dir;
        GrailsApplication application = GrailsActionUtilKt.getGrailsApplication(e.getDataContext());
        if (application == null) {
            return;
        }
        Project project = application.getProject();
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        String name = this.getArtefactName(e, project);
        if (name == null) {
            return;
        }
        String packageName = "";
        PsiDirectory[] dirs = view.getDirectories();
        PsiDirectory psiDirectory = dir = dirs.length == 1 ? dirs[0] : null;
        if (dir != null) {
            aPackage = JavaDirectoryService.getInstance().getPackage(dir);
            if (aPackage != null) {
                packageName = aPackage.getQualifiedName();
            } else {
                VirtualFile vDir;
                VirtualFile confDirectory = GrailsUtils.findConfDirectory(application);
                if (confDirectory != null && VfsUtilCore.isAncestor((VirtualFile)confDirectory, (VirtualFile)(vDir = dir.getVirtualFile()), (boolean)true)) {
                    packageName = VfsUtilCore.getRelativePath((VirtualFile)vDir, (VirtualFile)confDirectory, (char)'.');
                }
            }
        } else {
            aPackage = GrailsActionUtilKt.getArtefactPackage(e.getDataContext());
            if (aPackage != null) {
                packageName = aPackage;
            }
        }
        String artefactFqn = StringUtil.getQualifiedName((String)packageName, (String)name);
        if (this.checkExisting(application, artefactFqn)) {
            return;
        }
        this.doAction(application, artefactFqn);
    }

    protected String getArtefactName(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/grails/actions/NewGrailsXXXAction", "getArtefactName"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/actions/NewGrailsXXXAction", "getArtefactName"));
        }
        if (NewGrailsXXXAction.shouldAskArtefactName(e.getPlace())) {
            String inputTitle = "New " + e.getPresentation().getText();
            return Messages.showInputDialog((Project)project, (String)"Name:", (String)inputTitle, (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new MyInputValidator(project, inputTitle));
        }
        ArtefactData artefactData = GrailsActionUtilKt.getArtefactData(e.getDataContext());
        return artefactData == null ? null : artefactData.getArtefactName();
    }

    protected void doAction(@NotNull GrailsApplication application, @NotNull String name) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/actions/NewGrailsXXXAction", "doAction"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/grails/actions/NewGrailsXXXAction", "doAction"));
        }
        MvcCommand mvcCommand = new MvcCommand(this.getCommand(application), new String[]{name});
        GrailsCommandExecutorUtil.execute(application, mvcCommand, () -> {
            if (application == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/actions/NewGrailsXXXAction", "lambda$doAction$1"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/grails/actions/NewGrailsXXXAction", "lambda$doAction$1"));
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (application == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/actions/NewGrailsXXXAction", "lambda$null$0"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/grails/actions/NewGrailsXXXAction", "lambda$null$0"));
                }
                VirtualFile targetDirectory = this.getTargetDirectory(application);
                if (targetDirectory != null) {
                    LocalFileSystem.getInstance().refreshFiles((Iterable)ContainerUtil.list((Object[])new VirtualFile[]{targetDirectory}), false, true, null);
                    List<VirtualFile> files = this.findExistingGeneratedFiles(application, name);
                    if (files.size() > 0) {
                        FileEditorManager.getInstance((Project)application.getProject()).openFile(files.get(0), true);
                    }
                }
            });
        }, true, new String[0]);
    }

    protected boolean isEnabled(AnActionEvent e) {
        GrailsApplication application = GrailsActionUtilKt.getGrailsApplication(e.getDataContext());
        if (application == null) {
            return false;
        }
        if (e.getData(LangDataKeys.IDE_VIEW) == null) {
            return false;
        }
        VirtualFile targetDirectory = this.getTargetDirectory(application);
        if (targetDirectory == null) {
            return false;
        }
        if (NewGrailsXXXAction.shouldAskArtefactName(e.getPlace())) {
            GrailsArtefactHandler expectedHandler = this.getArtefactHandler();
            if (expectedHandler == null || GrailsActionUtilKt.getArtefactHandler(e.getDataContext()) != expectedHandler) {
                VirtualFile vfile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
                if (vfile == null) {
                    return false;
                }
                if (!vfile.isDirectory() && (vfile = vfile.getParent()) == null) {
                    return false;
                }
                if (!VfsUtilCore.isAncestor((VirtualFile)targetDirectory, (VirtualFile)vfile, (boolean)false) && !VfsUtilCore.isAncestor((VirtualFile)vfile, (VirtualFile)targetDirectory, (boolean)false)) {
                    return false;
                }
            }
        } else if (GrailsActionUtilKt.getArtefactData(e.getDataContext()) == null) {
            return false;
        }
        return this.isEnabled(application);
    }

    public void update(AnActionEvent e) {
        boolean enabled = this.isEnabled(e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(enabled);
        if (enabled && NewGrailsXXXAction.shouldAskArtefactName(e.getPlace())) {
            presentation.setText(GrailsBundle.message(this.myPopupTextKey, new Object[0]));
        }
        presentation.setWeight(42.0);
    }

    @Nullable
    protected String isValidIdentifier(String inputString, Project project) {
        if (PsiNameHelper.getInstance((Project)project).isQualifiedName(inputString)) {
            return null;
        }
        return "Please enter a valid class name.";
    }

    protected boolean checkExisting(@NotNull GrailsApplication application, @NotNull String name) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/actions/NewGrailsXXXAction", "checkExisting"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/grails/actions/NewGrailsXXXAction", "checkExisting"));
        }
        List<VirtualFile> existing = this.findExistingGeneratedFiles(application, name);
        if (existing.isEmpty()) {
            return false;
        }
        StringBuilder message = new StringBuilder();
        message.append(GrailsBundle.message("generate.dlg.exist", new Object[0])).append("\n");
        for (VirtualFile file : existing) {
            message.append("   ").append(file.getPath()).append("\n");
        }
        message.append(GrailsBundle.message("generate.dlg.overwrite", new Object[0]));
        return Messages.showYesNoDialog((Project)application.getProject(), (String)message.toString(), (String)"Conflict", (Icon)Messages.getQuestionIcon()) != 0;
    }

    protected List<VirtualFile> findExistingGeneratedFiles(GrailsApplication application, String name) {
        if (name.indexOf(46) == -1 && application.getGrailsVersion().isAtLeast("1.2.2")) {
            name = application.getRoot().getName().replace('-', '.').toLowerCase() + '.' + name;
        }
        List<String> list = this.getGeneratedFileNames(name);
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        VirtualFile dir = application.getRoot();
        for (String fileName : list) {
            VirtualFile file = dir.findFileByRelativePath(fileName);
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    private List<String> getGeneratedFileNames(String name) {
        ArrayList<String> names = new ArrayList<String>();
        this.fillGeneratedNamesList(name, names);
        return names;
    }

    protected boolean isEnabled(@NotNull GrailsApplication application) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/grails/actions/NewGrailsXXXAction", "isEnabled"));
        }
        return true;
    }

    @NotNull
    protected abstract String getCommand(@NotNull GrailsApplication var1);

    @Nullable
    protected abstract VirtualFile getTargetDirectory(@NotNull GrailsApplication var1);

    protected abstract void fillGeneratedNamesList(@NotNull String var1, @NotNull List<String> var2);

    @Nullable
    protected GrailsArtefactHandler getArtefactHandler() {
        return null;
    }

    private static boolean shouldAskArtefactName(String place) {
        return !ActionPlaces.isToolbarPlace((String)place);
    }

    private class MyInputValidator
    implements InputValidator {
        private final Project myProject;
        private final String myInputTitle;

        private MyInputValidator(Project project, String inputTitle) {
            this.myProject = project;
            this.myInputTitle = inputTitle;
        }

        public boolean canClose(String inputString) {
            if (!this.checkInput(inputString)) {
                return false;
            }
            String errorMessage = NewGrailsXXXAction.this.isValidIdentifier(inputString, this.myProject);
            if (errorMessage != null) {
                Messages.showErrorDialog((Project)this.myProject, (String)errorMessage, (String)this.myInputTitle);
                return false;
            }
            return true;
        }

        public boolean checkInput(String inputString) {
            return inputString.length() != 0;
        }
    }
}

