/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.util.ExecUtil;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import icons.GroovyMvcIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.config.GrailsLibraryPresentationProvider;
import org.jetbrains.plugins.grails.config.GrailsModuleStructureUtil;
import org.jetbrains.plugins.grails.config.GrailsSettingSynchronizer;
import org.jetbrains.plugins.grails.config.GrailsSettingsService;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;
import org.jetbrains.plugins.grails.util.GrailsFacetProvider;
import org.jetbrains.plugins.grails.util.GrailsNameUtils;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;
import org.jetbrains.plugins.groovy.mvc.MvcPathMacros;
import org.jetbrains.plugins.groovy.mvc.MvcProjectStructure;

public class GrailsFramework
extends MvcFramework {
    private static final Logger LOG = Logger.getInstance(GrailsFramework.class);
    public static final Key<Boolean> UPDATE_IN_PROGRESS = Key.create((String)"grails.updateInProgress");
    public static final MultiMap<JpsModuleSourceRootType<?>, String> GRAILS_SOURCE_FOLDERS = new MultiMap();
    private static final String PLUGINS_MODULE_SUFFIX = "-grailsPlugins";
    private static final String GLOBAL_PLUGINS_MODULE_NAME = "GrailsGlobalPlugins";

    private GrailsFramework() {
    }

    public boolean hasSupport(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "hasSupport"));
        }
        return !this.isAuxModule(module) && GrailsApplicationManager.findApplication(module) != null;
    }

    @NotNull
    public String getApplicationDirectoryName() {
        if ("grails-app" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsFramework", "getApplicationDirectoryName"));
        }
        return "grails-app";
    }

    public List<Module> reorderModulesForMvcView(List<Module> modules) {
        ArrayList<Module> res = new ArrayList<Module>();
        for (Module module : modules) {
            if (GrailsModuleStructureUtil.isInplacePluginModuleName(module.getName())) continue;
            res.add(module);
        }
        for (Module module : modules) {
            if (!GrailsModuleStructureUtil.isInplacePluginModuleName(module.getName())) continue;
            res.add(module);
        }
        return res;
    }

    public boolean isToReformatOnCreation(VirtualFile file) {
        FileType fileType = file.getFileType();
        return fileType == GroovyFileType.GROOVY_FILE_TYPE || fileType == GspFileType.GSP_FILE_TYPE;
    }

    public void syncSdkAndLibrariesInPluginsModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "syncSdkAndLibrariesInPluginsModule"));
        }
        super.syncSdkAndLibrariesInPluginsModule(module);
        for (Module auxModule : GrailsModuleStructureUtil.getAllCustomPluginModules(module)) {
            MvcModuleStructureUtil.syncAuxModuleSdk((Module)module, (Module)auxModule, (MvcFramework)this);
        }
    }

    public void upgradeFramework(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "upgradeFramework"));
        }
        if (this.findAppRoot(module) != null && !GrailsModuleStructureUtil.isIdeaGeneratedCustomPluginModule(module)) {
            GrailsModuleStructureUtil.upgradeGrails(module, false);
        }
    }

    @Nullable
    public File getCommonPluginsDir(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "getCommonPluginsDir"));
        }
        return this.toAbsoluteFile(module, GrailsSettingsService.getProjectPluginsDir(module));
    }

    public static void forceSynchronizationSetting(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "forceSynchronizationSetting"));
        }
        new GrailsSettingSynchronizer(module){

            @Override
            protected void onDone(boolean isSettingChanged, boolean isExtractingSettingsRan) {
                super.onDone(isSettingChanged, isExtractingSettingsRan);
                GrailsFramework.getInstance().updateProjectStructure(module);
            }
        }.syncGrailsSettings(true);
    }

    private void syncModules(final Project project) {
        ArrayList<Module> grailsModules = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!this.hasSupport(module)) continue;
            grailsModules.add(module);
            boolean f = new GrailsSettingSynchronizer(module){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void onDone(boolean isSettingChanged, boolean isExtractingSettingsRan) {
                    super.onDone(isSettingChanged, isExtractingSettingsRan);
                    boolean stillGrailsModule = GrailsFramework.getInstance().hasSupport(this.myModule);
                    assert (isExtractingSettingsRan || stillGrailsModule);
                    if (isSettingChanged && stillGrailsModule && MvcModuleStructureUtil.isEnabledStructureUpdate()) {
                        AccessToken token = WriteAction.start();
                        try {
                            VirtualFile root = GrailsFramework.this.findAppRoot(this.myModule);
                            assert (root != null);
                            project.putUserData(UPDATE_IN_PROGRESS, (Object)true);
                            MvcModuleStructureUtil.updateModuleStructure((Module)this.myModule, (MvcProjectStructure)GrailsFramework.this.createProjectStructure(this.myModule, false), (VirtualFile)root);
                            project.putUserData(UPDATE_IN_PROGRESS, null);
                        }
                        finally {
                            token.finish();
                        }
                    }
                    if (isExtractingSettingsRan) {
                        GrailsFramework.this.syncModules(project);
                    }
                }
            }.syncGrailsSettings(false);
            if (f) continue;
            return;
        }
        if (MvcModuleStructureUtil.isEnabledStructureUpdate()) {
            project.putUserData(UPDATE_IN_PROGRESS, (Object)true);
            this.configureAuxModules(grailsModules);
            project.putUserData(UPDATE_IN_PROGRESS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureAuxModules(ArrayList<Module> grailsModules) {
        if (grailsModules.isEmpty()) {
            return;
        }
        Project project = grailsModules.get(0).getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        AccessToken token = WriteAction.start();
        try {
            MultiMap backInplacePluginDependencies = new MultiMap();
            MultiMap inplacePluginDependencies = new MultiMap();
            for (Module module : grailsModules.toArray(new Module[grailsModules.size()])) {
                Map<String, VirtualFile> locations = GrailsFramework.getCustomPluginLocations(module, true);
                for (Map.Entry<String, VirtualFile> entry : locations.entrySet()) {
                    VirtualFile pluginRoot = entry.getValue();
                    Module pluginModule = fileIndex.getModuleForFile(pluginRoot);
                    if (pluginModule != null && Comparing.equal((Object)fileIndex.getContentRootForFile(pluginRoot), (Object)pluginRoot)) {
                        if (pluginModule == module || this.isAuxModule(pluginModule)) {
                            continue;
                        }
                    } else {
                        String pluginModuleName = GrailsModuleStructureUtil.generateInplacePluginModuleName(GrailsNameUtils.toPluginName(entry.getKey()));
                        pluginModule = MvcModuleStructureUtil.createAuxiliaryModule((Module)module, (String)pluginModuleName, (MvcFramework)this);
                        MvcModuleStructureUtil.updateModuleStructure((Module)pluginModule, (MvcProjectStructure)this.createProjectStructure(pluginModule, false), (VirtualFile)pluginRoot);
                        grailsModules.add(pluginModule);
                    }
                    inplacePluginDependencies.putValue((Object)module, (Object)pluginModule);
                    backInplacePluginDependencies.putValue((Object)pluginModule, (Object)module);
                }
            }
            ArrayList<Module> correctCommonPluginModules = new ArrayList<Module>();
            for (Module module : grailsModules) {
                Module commonPluginModule;
                assert (!this.isAuxModule(module));
                assert (!module.isDisposed());
                if (backInplacePluginDependencies.get((Object)module).isEmpty() && (commonPluginModule = MvcModuleStructureUtil.updateAuxiliaryPluginsModuleRoots((Module)module, (MvcFramework)this)) != null) {
                    Set<Module> dependenciesTransitive = GrailsModuleStructureUtil.getAllCustomPluginModules(module);
                    for (Module m : grailsModules) {
                        if (m == module) continue;
                        if (dependenciesTransitive.contains(m)) {
                            MvcModuleStructureUtil.ensureDependency((Module)m, (Module)commonPluginModule, (boolean)false);
                            continue;
                        }
                        MvcModuleStructureUtil.removeDependency((Module)m, (Module)commonPluginModule);
                    }
                    correctCommonPluginModules.add(commonPluginModule);
                    VirtualFile[] pluginSourcesRoots = ModuleRootManager.getInstance((Module)commonPluginModule).getSourceRoots();
                    ModuleRootModificationUtil.updateModel((Module)module, modifiableModel -> {
                        ArrayList actions = ContainerUtil.newArrayList();
                        SmartList sourceRoots = new SmartList((Object[])modifiableModel.getSourceRoots());
                        for (VirtualFile virtualFile : pluginSourcesRoots) {
                            MvcModuleStructureUtil.removeSrcFolderFromRoots((VirtualFile)virtualFile, (List)actions, (Collection)sourceRoots);
                        }
                        for (VirtualFile virtualFile : modifiableModel.getContentEntries()) {
                            for (Consumer action : actions) {
                                action.consume((Object)virtualFile);
                            }
                        }
                    });
                }
                for (Module m : grailsModules) {
                    if (m == module) continue;
                    if (inplacePluginDependencies.get((Object)module).contains(m)) {
                        MvcModuleStructureUtil.ensureDependency((Module)module, (Module)m, (boolean)true);
                        continue;
                    }
                    if (!GrailsUtils.isGrailsPluginModule(m)) continue;
                    MvcModuleStructureUtil.removeDependency((Module)module, (Module)m);
                }
            }
            MvcModuleStructureUtil.updateGlobalPluginModule((Project)project, (MvcFramework)GrailsFramework.getInstance());
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                if (!this.isCommonPluginsModule(module) || correctCommonPluginModules.contains(module)) continue;
                MvcModuleStructureUtil.removeAuxiliaryModule((Module)module);
            }
        }
        finally {
            token.finish();
        }
        ChangeListManager.getInstance((Project)project).addFilesToIgnore(new IgnoredFileBean[]{IgnoredBeanFactory.ignoreUnderDirectory((String)GrailsFramework.getUserHomeGrails(), (Project)project)});
    }

    public boolean updatesWholeProject() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProjectStructure(@NotNull Module someModule) {
        if (someModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "someModule", "org/jetbrains/plugins/grails/config/GrailsFramework", "updateProjectStructure"));
        }
        if (GrailsSettingSynchronizer.isUpdateSettingRunning(someModule)) {
            return;
        }
        if (MvcModuleStructureUtil.isEnabledStructureUpdate()) {
            Module[] modules = ModuleManager.getInstance((Project)someModule.getProject()).getModules();
            AccessToken token = WriteAction.start();
            try {
                for (Module module : modules) {
                    VirtualFile root;
                    if (!this.hasSupport(module) || (root = this.findAppRoot(module)) == null) continue;
                    someModule.getProject().putUserData(UPDATE_IN_PROGRESS, (Object)true);
                    MvcModuleStructureUtil.updateModuleStructure((Module)module, (MvcProjectStructure)this.createProjectStructure(module, false), (VirtualFile)root);
                    someModule.getProject().putUserData(UPDATE_IN_PROGRESS, null);
                }
            }
            finally {
                token.finish();
            }
        }
        this.syncModules(someModule.getProject());
    }

    protected boolean isCoreJar(@NotNull VirtualFile localFile) {
        if (localFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "org/jetbrains/plugins/grails/config/GrailsFramework", "isCoreJar"));
        }
        return GrailsConfigUtils.isGrailsCoreJar(localFile.getName());
    }

    public VirtualFile getSdkRoot(@Nullable Module module) {
        return GrailsConfigUtils.getSDKInstallPath(module);
    }

    public String getUserLibraryName() {
        return "Grails User Library";
    }

    protected List<File> getImplicitClasspathRoots(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "getImplicitClasspathRoots"));
        }
        List toExclude = super.getImplicitClasspathRoots(module);
        ContainerUtil.addIfNotNull((Collection)toExclude, (Object)GrailsFramework.getInstance().getSdkWorkDir(module));
        for (Module customPluginModule : GrailsModuleStructureUtil.getAllCustomPluginModules(module)) {
            VirtualFile libDir;
            VirtualFile appRoot;
            VirtualFile compilerOutputTestPath;
            CompilerModuleExtension extension = (CompilerModuleExtension)ModuleRootManager.getInstance((Module)customPluginModule).getModuleExtension(CompilerModuleExtension.class);
            VirtualFile compilerOutputPath = extension.getCompilerOutputPath();
            if (compilerOutputPath != null) {
                toExclude.add(VfsUtilCore.virtualToIoFile((VirtualFile)compilerOutputPath));
            }
            if ((compilerOutputTestPath = extension.getCompilerOutputPath()) != null) {
                toExclude.add(VfsUtilCore.virtualToIoFile((VirtualFile)compilerOutputTestPath));
            }
            if ((appRoot = this.findAppRoot(customPluginModule)) == null || (libDir = appRoot.findChild("lib")) == null) continue;
            toExclude.add(VfsUtilCore.virtualToIoFile((VirtualFile)libDir));
        }
        return toExclude;
    }

    public JavaParameters createJavaParameters(@NotNull Module module, boolean forCreation, boolean forTests, boolean classpathFromDependencies, @NotNull MvcCommand command) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "createJavaParameters"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/plugins/grails/config/GrailsFramework", "createJavaParameters"));
        }
        throw new IllegalStateException("Should not get here");
    }

    @NotNull
    public String getFrameworkName() {
        if ("Grails" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsFramework", "getFrameworkName"));
        }
        return "Grails";
    }

    public Icon getIcon() {
        return GroovyMvcIcons.Grails;
    }

    public Icon getToolWindowIcon() {
        return GroovyMvcIcons.Grails_13;
    }

    public String getSdkHomePropertyName() {
        return "GRAILS_HOME";
    }

    protected String getCommonPluginSuffix() {
        return PLUGINS_MODULE_SUFFIX;
    }

    public String getGlobalPluginsModuleName() {
        return GLOBAL_PLUGINS_MODULE_NAME;
    }

    public boolean isSDKLibrary(Library library) {
        return GrailsConfigUtils.getInstance().isSDKLibrary(library);
    }

    public MvcProjectStructure createProjectStructure(@NotNull Module module, boolean auxModule) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "createProjectStructure"));
        }
        return new GrailsProjectStructure(module, auxModule);
    }

    public LibraryKind getLibraryKind() {
        return GrailsLibraryPresentationProvider.GRAILS_KIND;
    }

    public String getSomeFrameworkClass() {
        return "grails.util.GrailsUtil";
    }

    public static GrailsFramework getInstance() {
        return (GrailsFramework)((Object)EP_NAME.findExtension(GrailsFramework.class));
    }

    public static Map<String, VirtualFile> getCustomPluginLocations(@NotNull Module module, boolean refresh) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "getCustomPluginLocations"));
        }
        Map<String, String> customPluginLocations = GrailsSettingsService.getGrailsSettings((Module)module).customPluginLocations;
        if (customPluginLocations.isEmpty()) {
            return Collections.emptyMap();
        }
        VirtualFile root = GrailsUtils.findGrailsAppRoot(module);
        assert (root != null);
        HashMap<String, VirtualFile> res = new HashMap<String, VirtualFile>();
        for (Map.Entry<String, String> entry : customPluginLocations.entrySet()) {
            VirtualFile pluginRoot;
            if (FileUtil.isAbsolute((String)entry.getValue())) {
                if (refresh) {
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    pluginRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(entry.getValue());
                } else {
                    pluginRoot = LocalFileSystem.getInstance().findFileByPath(entry.getValue());
                }
            } else {
                pluginRoot = VfsUtilCore.findRelativeFile((String)entry.getValue(), (VirtualFile)root);
            }
            if (pluginRoot == null) continue;
            res.put(GrailsNameUtils.toPluginName(entry.getKey()), pluginRoot);
        }
        return res;
    }

    private static boolean equalsIgnoreFirstCase(@NotNull String s1, @Nullable String s2) {
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "org/jetbrains/plugins/grails/config/GrailsFramework", "equalsIgnoreFirstCase"));
        }
        if (s2 == null) {
            return false;
        }
        int length = s1.length();
        if (length != s2.length()) {
            return false;
        }
        if (length <= 1) {
            return s1.equalsIgnoreCase(s2);
        }
        return Character.toUpperCase(s1.charAt(0)) == Character.toUpperCase(s2.charAt(0)) && s1.substring(1).equals(s2.substring(1));
    }

    @Nullable
    public VirtualFile findPluginRoot(@NotNull Module module, String pluginName2, boolean canHasVersion) {
        int idx;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "findPluginRoot"));
        }
        String withoutVersion = GrailsNameUtils.toPluginName(pluginName2);
        String withVersion = null;
        if (canHasVersion && (idx = pluginName2.lastIndexOf(45)) != -1) {
            withVersion = GrailsNameUtils.toPluginName(pluginName2.substring(0, idx));
        }
        for (VirtualFile root : this.getAllPluginRoots(module, false)) {
            String name = GrailsUtils.extractGrailsPluginName(root);
            if (name == null || !GrailsFramework.equalsIgnoreFirstCase(name, withoutVersion) && !GrailsFramework.equalsIgnoreFirstCase(name, withVersion)) continue;
            return root;
        }
        return null;
    }

    public Collection<VirtualFile> getAllPluginRoots(@NotNull Module module, boolean refresh) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "getAllPluginRoots"));
        }
        HashMap map2 = new HashMap();
        this.collectCommonPluginRoots(map2, module, refresh);
        ArrayList<VirtualFile> res = new ArrayList<VirtualFile>();
        res.addAll(map2.values());
        res.addAll(GrailsFramework.getCustomPluginLocations(module, refresh).values());
        return res;
    }

    public File getGlobalPluginsDir(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "getGlobalPluginsDir"));
        }
        return this.toAbsoluteFile(module, GrailsSettingsService.getGlobalPluginsDir(module));
    }

    @Nullable
    public File getSdkWorkDir(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "getSdkWorkDir"));
        }
        return this.toAbsoluteFile(module, GrailsSettingsService.getGrailsWorkDir(module));
    }

    @Nullable
    private File toAbsoluteFile(@NotNull Module module, @Nullable String path) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "toAbsoluteFile"));
        }
        if (path == null) {
            return null;
        }
        File res = new File(path);
        if (res.isAbsolute()) {
            return res;
        }
        VirtualFile root = this.findAppRoot(module);
        if (root == null) {
            return null;
        }
        return new File(VfsUtilCore.virtualToIoFile((VirtualFile)root), path);
    }

    public File getDefaultSdkWorkDir(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "getDefaultSdkWorkDir"));
        }
        String version = GrailsConfigUtils.getGrailsVersion(module);
        if (version == null) {
            return null;
        }
        return new File(GrailsFramework.getUserHomeGrails(), version);
    }

    public static String getUserHomeGrails() {
        return MvcPathMacros.getSdkWorkDirParent((String)"grails");
    }

    public boolean isInteractiveConsoleSupported(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "isInteractiveConsoleSupported"));
        }
        return ExecUtil.hasTerminalApp() && this.getSdkRoot(module) != null;
    }

    public void runInteractiveConsole(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "runInteractiveConsole"));
        }
        VirtualFile root = this.findAppRoot(module);
        assert (root != null) : module;
        VirtualFile sdkInstallPath = this.getSdkRoot(module);
        assert (sdkInstallPath != null) : module;
        try {
            String console = FileUtil.join((String[])new String[]{sdkInstallPath.getPath(), "bin", "grails"});
            GeneralCommandLine commandLine = new GeneralCommandLine(ExecUtil.getTerminalCommand((String)"Grails Console", (String)console));
            commandLine.setWorkDirectory(VfsUtilCore.virtualToIoFile((VirtualFile)root));
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk != null) {
                commandLine.getEnvironment().put("JAVA_HOME", sdk.getHomePath());
            }
            commandLine.createProcess();
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean hasFrameworkJar(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "hasFrameworkJar"));
        }
        throw new IllegalStateException("Should not get here");
    }

    public boolean isUpgradeActionSupported(Module module) {
        return false;
    }

    public boolean hasFrameworkStructure(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsFramework", "hasFrameworkStructure"));
        }
        return false;
    }

    public boolean showActionGroup() {
        return false;
    }

    @Nullable
    public VirtualFile findAppDirectory(@Nullable Module module) {
        VirtualFile[] contentRoots;
        VirtualFile[] ancestors;
        if (module == null || this.isCommonPluginsModule(module)) {
            return null;
        }
        OldGrailsApplication oldApplication = GrailsApplicationManager.findApplication(module);
        if (oldApplication != null) {
            return oldApplication.getAppRoot();
        }
        if (ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module) && (ancestors = VfsUtil.getCommonAncestors((VirtualFile[])(contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()))).length == 1) {
            return ancestors[0].findChild(this.getApplicationDirectoryName());
        }
        return super.findAppDirectory(module);
    }

    static {
        GRAILS_SOURCE_FOLDERS.put((Object)JavaSourceRootType.SOURCE, Arrays.asList("src/java", "src/gwt", "src/scala", "grails-app/utils", "src/groovy", "grails-app/jobs", "grails-app/i18n", "grails-app/realms", "grails-app/controllers", "grails-app/domain", "grails-app/services", "grails-app/taglib"));
        GRAILS_SOURCE_FOLDERS.put((Object)JavaSourceRootType.TEST_SOURCE, Arrays.asList("test/unit", "test/integration", "test/functional"));
        GRAILS_SOURCE_FOLDERS.put((Object)JavaResourceRootType.RESOURCE, Collections.singleton("grails-app/resources"));
    }

    static class GrailsProjectStructure
    extends MvcProjectStructure {
        GrailsProjectStructure(Module module, boolean auxModule) {
            super(module, auxModule, GrailsFramework.getUserHomeGrails(), GrailsFramework.getInstance().getSdkWorkDir(module));
        }

        @NotNull
        public String getUserLibraryName() {
            if ("Grails User Library" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsFramework$GrailsProjectStructure", "getUserLibraryName"));
            }
            return "Grails User Library";
        }

        public MultiMap<JpsModuleSourceRootType<?>, String> getSourceFolders() {
            return GRAILS_SOURCE_FOLDERS;
        }

        public String[] getInvalidSourceFolders() {
            return new String[]{"src", "."};
        }

        public String[] getExcludedFolders() {
            return new String[]{"web-app/plugins", "target/classes", "target/test-classes"};
        }

        public List<VirtualFile> getExcludedFolders(@NotNull VirtualFile root) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/plugins/grails/config/GrailsFramework$GrailsProjectStructure", "getExcludedFolders"));
            }
            ArrayList<VirtualFile> res = super.getExcludedFolders(root);
            VirtualFile workDir = VfsUtil.findRelativeFile((VirtualFile)root, (String[])new String[]{"target", "work"});
            if (workDir != null) {
                res = new ArrayList<VirtualFile>(res);
                for (VirtualFile dir : workDir.getChildren()) {
                    if (!dir.isDirectory() || "plugins".equals(dir.getName())) continue;
                    res.add(dir);
                }
            }
            return res;
        }

        public void setupFacets(Collection<Consumer<ModifiableFacetModel>> actions, Collection<VirtualFile> roots) {
            for (GrailsFacetProvider provider : (GrailsFacetProvider[])GrailsFacetProvider.EP_NAME.getExtensions()) {
                provider.addFacets(actions, this.myModule, roots);
            }
        }
    }
}

