/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineBuilder;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import icons.GroovyMvcIcons;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleModuleBuilder;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.grails.config.GrailsOptionsWizardStep;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsConsole;
import org.jetbrains.plugins.grails.runner.GrailsInstallationExecutor;
import org.jetbrains.plugins.grails.sdk.GrailsSDK;
import org.jetbrains.plugins.grails.sdk.GrailsSDKManager;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class GrailsModuleBuilder
extends ModuleBuilder {
    private static final Logger LOG = Logger.getInstance(GrailsModuleBuilder.class);
    private ProjectData myParentProject;
    private GrailsSDK myGrailsSDK;
    @NotNull
    private String myCreationChoice = "create-app";
    @Nullable
    private String myOptions;
    private boolean isCreatingNewProject;

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        if (this.myJdk != null) {
            modifiableRootModel.setSdk(this.myJdk);
        } else {
            modifiableRootModel.inheritSdk();
        }
        if (this.doAddContentEntry(modifiableRootModel) == null) {
            throw new ConfigurationException("Cannot setup root path");
        }
    }

    protected void setupModule(Module module) throws ConfigurationException {
        super.setupModule(module);
        Project project = module.getProject();
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            try {
                GrailsConsole.getInstance(project);
                this.doSetupModule(module);
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                GrailsConsole.NOTIFICATION_GROUP.createNotification("Failed to create Grails app structure", String.valueOf(e.getMessage()), NotificationType.WARNING, null).notify(project);
            }
        });
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        return new GrailsOptionsWizardStep(context, this);
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPresentableName() {
        return "Grails";
    }

    public String getDescription() {
        return "Grails application module builder";
    }

    public Icon getNodeIcon() {
        return GroovyMvcIcons.Grails;
    }

    public String getParentGroup() {
        return "Groovy";
    }

    public GrailsModuleBuilder setParentProject(ProjectData parentProject) {
        this.myParentProject = parentProject;
        return this;
    }

    public GrailsModuleBuilder setGrailsSDKHome(GrailsSDK grailsSDK) {
        this.myGrailsSDK = grailsSDK;
        return this;
    }

    public GrailsModuleBuilder setCreateChoice(@NotNull String creationChoice) {
        if (creationChoice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creationChoice", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "setCreateChoice"));
        }
        this.myCreationChoice = creationChoice;
        return this;
    }

    public GrailsModuleBuilder setOptions(@Nullable String options) {
        this.myOptions = StringUtil.isEmptyOrSpaces((String)options) ? null : options;
        return this;
    }

    public GrailsModuleBuilder setCreatingNewProject(boolean creatingNewProject) {
        this.isCreatingNewProject = creatingNewProject;
        return this;
    }

    private void doSetupModule(@NotNull Module module) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "doSetupModule"));
        }
        Project project = module.getProject();
        VirtualFile rootModuleContent = GrailsModuleBuilder.getModuleRoot(module);
        GrailsSDKManager.getInstance(project).setGrailsSDK(rootModuleContent.getPath(), this.myGrailsSDK.getPath());
        GeneralCommandLine parameters = this.getCreationCommandLine(module);
        Runnable linker = this.getLinker(module);
        GrailsConsole.executeProcess(project, parameters, linker, false, new String[0]);
    }

    @NotNull
    private GeneralCommandLine getCreationCommandLine(@NotNull Module module) throws ExecutionException {
        Sdk sdk;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "getCreationCommandLine"));
        }
        Project project = module.getProject();
        VirtualFile root = GrailsModuleBuilder.getModuleRoot(module);
        MvcCommand command = new MvcCommand(this.myCreationChoice, new String[]{root.getName(), "--inplace"});
        if (this.myOptions != null) {
            ContainerUtil.addAll((Collection)command.getArgs(), (Object[])this.myOptions.split(" "));
        }
        Sdk sdk2 = sdk = this.getModuleJdk() == null ? ProjectRootManager.getInstance((Project)project).getProjectSdk() : this.getModuleJdk();
        if (sdk == null) {
            throw new ExecutionException("SDK is not defined");
        }
        JavaParameters params = this.getExecutor().createJavaParameters(sdk, this.myGrailsSDK, command);
        params.setWorkingDirectory(root.getPath());
        params.setDefaultCharset(project);
        GeneralCommandLine parameters = CommandLineBuilder.createFromJavaParameters((SimpleJavaParameters)params);
        LOG.debug(parameters.getCommandLineString());
        GeneralCommandLine generalCommandLine = parameters;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "getCreationCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    private static VirtualFile getModuleRoot(@NotNull Module module) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "getModuleRoot"));
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length == 1) {
            VirtualFile virtualFile = roots[0];
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "getModuleRoot"));
            }
            return virtualFile;
        }
        throw new ExecutionException("There is no module root");
    }

    @NotNull
    private GrailsInstallationExecutor getExecutor() throws ExecutionException {
        for (GrailsCommandExecutor executor : (GrailsCommandExecutor[])GrailsCommandExecutor.EP_NAME.getExtensions()) {
            GrailsInstallationExecutor installationExecutor;
            if (!(executor instanceof GrailsInstallationExecutor) || !(installationExecutor = (GrailsInstallationExecutor)((Object)executor)).isApplicable(this.myGrailsSDK)) continue;
            GrailsInstallationExecutor grailsInstallationExecutor = installationExecutor;
            if (grailsInstallationExecutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "getExecutor"));
            }
            return grailsInstallationExecutor;
        }
        throw new ExecutionException("Cannot create application with Grails SDK: " + this.myGrailsSDK.getPath());
    }

    @Nullable
    private Runnable getLinker(@NotNull Module module) throws ExecutionException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "getLinker"));
        }
        Project project = module.getProject();
        VirtualFile root = GrailsModuleBuilder.getModuleRoot(module);
        boolean linkToGradle = this.myGrailsSDK.getVersion().isAtLeast(Version.GRAILS_3_0) || this.myParentProject != null;
        return !linkToGradle ? null : () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "lambda$getLinker$2"));
            }
            LOG.debug("Grails application structure created for module: " + module);
            String rootProjectPath = this.getGradleProjectRootPath(module, root);
            boolean fresh = this.isCreatingNewProject || this.myParentProject == null;
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "lambda$null$1"));
                }
                try {
                    GradleModuleBuilder.setupGradleSettingsFile((String)rootProjectPath, (VirtualFile)root, (String)project.getName(), (String)module.getName(), (boolean)fresh);
                    LOG.debug("'settings.gradle' file set up for module: " + module);
                }
                catch (ConfigurationException e) {
                    LOG.debug((Throwable)e);
                    GrailsConsole.NOTIFICATION_GROUP.createNotification("Failed to create settings.gradle", e.getMessage(), NotificationType.WARNING, null).notify(project);
                }
            });
            this.linkProject(fresh, rootProjectPath, project);
        };
    }

    @NotNull
    private String getGradleProjectRootPath(Module module, VirtualFile rootModuleContent) {
        String result = this.myParentProject == null ? FileUtil.toCanonicalPath((String)(this.isCreatingNewProject ? module.getProject().getBasePath() : rootModuleContent.getPath())) : this.myParentProject.getLinkedExternalProjectPath();
        assert (result != null);
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsModuleBuilder", "getGradleProjectRootPath"));
        }
        return string;
    }

    private void linkProject(boolean fresh, String rootProjectPath, Project project) {
        if (this.isCreatingNewProject) {
            project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)Boolean.TRUE);
        }
        if (fresh) {
            GradleProjectSettings gradleSettings = new GradleProjectSettings();
            gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
            gradleSettings.setUseAutoImport(true);
            gradleSettings.setExternalProjectPath(rootProjectPath);
            ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)gradleSettings);
            LOG.debug("Project '" + project + "' linked with " + gradleSettings);
        }
        if (!this.isCreatingNewProject) {
            FileDocumentManager.getInstance().saveAllDocuments();
            LOG.debug("Starting refreshing the project: " + rootProjectPath);
        }
        ExternalSystemUtil.refreshProject((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)rootProjectPath, (boolean)false, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }
}

