/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsPropertiesFileCache;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureSynchronizer;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginUtil;

public class GrailsStructure {
    private final Module myModule;
    private final VirtualFile myAppRoot;
    private final VirtualFile myAppDirectory;
    private final String myGrailsVersion;
    private final PsiManager myManager;
    private GrailsPropertiesFileCache myGrailsPropertiesFileCache;
    private volatile Map<String, VirtualFile> myInstalledPlugins;

    private GrailsStructure(Module module, @NotNull VirtualFile appDirectory, @Nullable String grailsVersion2) {
        if (appDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appDirectory", "org/jetbrains/plugins/grails/config/GrailsStructure", "<init>"));
        }
        this.myModule = module;
        this.myManager = PsiManager.getInstance((Project)module.getProject());
        this.myAppDirectory = appDirectory;
        this.myAppRoot = this.myAppDirectory.getParent();
        this.myGrailsVersion = grailsVersion2;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsStructure", "getModule"));
        }
        return module;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public Map<String, VirtualFile> getInstalledCommonPlugins() {
        Map<String, VirtualFile> res = this.myInstalledPlugins;
        if (res == null) {
            res = new HashMap<String, VirtualFile>();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                VirtualFile applicationProperties = this.myAppRoot.findChild("application.properties");
                if (applicationProperties != null) {
                    PropertiesFile file = (PropertiesFile)this.myManager.findFile(applicationProperties);
                    assert (file != null);
                    for (Map.Entry<String, String> entry : MvcPluginUtil.getInstalledPluginVersions(file).entrySet()) {
                        res.put(entry.getKey(), null);
                    }
                }
            } else {
                GrailsFramework.getInstance().collectCommonPluginRoots(res, this.myModule, false);
            }
            this.myInstalledPlugins = res;
        }
        return res;
    }

    public boolean isPluginInstalled(String pluginName2) {
        return this.getInstalledCommonPlugins().containsKey(pluginName2);
    }

    @NotNull
    public VirtualFile getAppRoot() {
        VirtualFile virtualFile = this.myAppRoot;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsStructure", "getAppRoot"));
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getAppDirectory() {
        VirtualFile virtualFile = this.myAppDirectory;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsStructure", "getAppDirectory"));
        }
        return virtualFile;
    }

    @Nullable(value="Grails version can be unknown, because it's got from name of grails-core.jar")
    public String getGrailsVersion() {
        return this.myGrailsVersion;
    }

    public boolean isAtLeastGrails(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/plugins/grails/config/GrailsStructure", "isAtLeastGrails"));
        }
        return this.myGrailsVersion != null && VersionComparatorUtil.compare((String)this.myGrailsVersion, (String)version) >= 0;
    }

    public boolean isVersionLessThan(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/plugins/grails/config/GrailsStructure", "isVersionLessThan"));
        }
        return this.myGrailsVersion != null && VersionComparatorUtil.compare((String)this.myGrailsVersion, (String)version) < 0;
    }

    public static boolean isVersionAtLeast(@NotNull String grailsVersion2, @Nullable Module module) {
        if (grailsVersion2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsVersion", "org/jetbrains/plugins/grails/config/GrailsStructure", "isVersionAtLeast"));
        }
        GrailsStructure structure = GrailsStructure.getInstance(module);
        return structure != null && structure.isAtLeastGrails(grailsVersion2);
    }

    public static boolean isVersionLessThan(@NotNull String grailsVersion2, @NotNull Module module) {
        if (grailsVersion2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsVersion", "org/jetbrains/plugins/grails/config/GrailsStructure", "isVersionLessThan"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsStructure", "isVersionLessThan"));
        }
        GrailsStructure grailsStructure = GrailsStructure.getInstance(module);
        return grailsStructure != null && grailsStructure.isVersionLessThan(grailsVersion2);
    }

    public static boolean isVersionLessThan(@NotNull String grailsVersion2, @NotNull PsiElement element) {
        if (grailsVersion2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsVersion", "org/jetbrains/plugins/grails/config/GrailsStructure", "isVersionLessThan"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/config/GrailsStructure", "isVersionLessThan"));
        }
        GrailsStructure instance = GrailsStructure.getInstance(element);
        return instance != null && instance.isVersionLessThan(grailsVersion2);
    }

    public boolean isAtLeastGrails1_4() {
        return this.isAtLeastGrails("1.4");
    }

    @NotNull
    public String getAppName() {
        String res = this.getGrailsPropertiesFileCache().getAppName();
        String string = res == null ? this.myAppRoot.getName() : res;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/config/GrailsStructure", "getAppName"));
        }
        return string;
    }

    GrailsPropertiesFileCache getGrailsPropertiesFileCache() {
        GrailsPropertiesFileCache res = this.myGrailsPropertiesFileCache;
        if (res == null || res.isOutdated()) {
            this.myGrailsPropertiesFileCache = res = new GrailsPropertiesFileCache(this);
        }
        return res;
    }

    @Nullable
    public static GrailsStructure getInstance(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/config/GrailsStructure", "getInstance"));
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        return GrailsStructure.getInstance(module);
    }

    public static boolean isAtLeastGrails1_4(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/config/GrailsStructure", "isAtLeastGrails1_4"));
        }
        GrailsStructure structure = GrailsStructure.getInstance(element);
        if (structure == null) {
            return true;
        }
        return structure.isAtLeastGrails1_4();
    }

    public static boolean isAtLeastGrails1_4(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/config/GrailsStructure", "isAtLeastGrails1_4"));
        }
        GrailsStructure structure = GrailsStructure.getInstance(module);
        if (structure == null) {
            return true;
        }
        return structure.isAtLeastGrails1_4();
    }

    @Nullable
    public static GrailsStructure getInstance(final @Nullable Module module) {
        if (module == null) {
            return null;
        }
        final Project project = module.getProject();
        return (GrailsStructure)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<GrailsStructure>(){

            @Nullable
            public CachedValueProvider.Result<GrailsStructure> compute() {
                return CachedValueProvider.Result.create((Object)this.doCompute(), (Object[])new Object[]{MvcModuleStructureSynchronizer.getInstance((Project)project).getFileAndRootsModificationTracker(), ProjectRootManager.getInstance((Project)project)});
            }

            private GrailsStructure doCompute() {
                VirtualFile appDirectory = GrailsFramework.getInstance().findAppDirectory(module);
                if (appDirectory != null) {
                    String grailsVersion2 = GrailsConfigUtils.getGrailsVersion(module);
                    return new GrailsStructure(module, appDirectory, grailsVersion2);
                }
                return null;
            }
        });
    }
}

