/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlTagRuleProvider;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspGrailsTag;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.gtag.GspTagRuleProvider;

public class GspTagInspection
extends LocalInspectionTool {
    private GspTagRuleProvider ruleProvider = new GspTagRuleProvider();

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("GSP" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/GspTagInspection", "getGroupDisplayName"));
        }
        return "GSP";
    }

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = new String[]{"Groovy", "Grails", this.getGroupDisplayName()};
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/GspTagInspection", "getGroupPath"));
        }
        return stringArray;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("GSP attribute consistency inspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/GspTagInspection", "getDisplayName"));
        }
        return "GSP attribute consistency inspection";
    }

    @NotNull
    public String getShortName() {
        if ("GspInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/GspTagInspection", "getShortName"));
        }
        return "GspInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/grails/lang/gsp/GspTagInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof GspGrailsTag) {
                    GspGrailsTag tag = (GspGrailsTag)element;
                    for (XmlTagRuleProvider.Rule rule : GspTagInspection.this.ruleProvider.getTagRule(tag)) {
                        rule.annotate((XmlTag)tag, holder);
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/GspTagInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }
}

