/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.formatter.settings;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.lang.gsp.GspLanguage;

public class GspLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings defaultSettings = new CommonCodeStyleSettings((Language)GspLanguage.INSTANCE);
        defaultSettings.initIndentOptions();
        return defaultSettings;
    }

    @NotNull
    public Language getLanguage() {
        GspLanguage gspLanguage = GspLanguage.INSTANCE;
        if (gspLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/settings/GspLanguageCodeStyleSettingsProvider", "getLanguage"));
        }
        return gspLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "org/jetbrains/plugins/grails/lang/gsp/formatter/settings/GspLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        return "<html>\n<head>\n    <title>Welcome to Grails</title>\n</head>\n<body>\n<g:each var=\"c\" in=\"${grailsApplication.controllerClasses}\">\n    <li class=\"controller\"/>\n</g:each>\n</body>\n</html>";
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }
}

