/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineBuilder;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.FindClassUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.grails.rt.GrailsRtMarker;
import org.jetbrains.plugins.grails.service.GrailsExecutorHolder;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.grails.util.SerializableStringMultiMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;

@State(name="TraitInjectorService", storages={@Storage(value="$WORKSPACE_FILE$")})
public class TraitInjectorService
implements PersistentStateComponent<PersistentState> {
    private static final Logger LOG = Logger.getInstance(TraitInjectorService.class);
    private static final String TRAIT_INJECTOR_FQN = "grails.compiler.traits.TraitInjector";
    private static final String MARKER = "--------------------------------------";
    private static final Map<GrailsArtifact, String> ARTEFACT_TO_NAME = ContainerUtil.newHashMap((Pair)Pair.create((Object)((Object)GrailsArtifact.DOMAIN), (Object)"Domain"), (Pair[])new Pair[]{Pair.create((Object)((Object)GrailsArtifact.CONTROLLER), (Object)"Controller"), Pair.create((Object)((Object)GrailsArtifact.SERVICE), (Object)"Service"), Pair.create((Object)((Object)GrailsArtifact.INTERCEPTOR), (Object)"Interceptor"), Pair.create((Object)((Object)GrailsArtifact.TAGLIB), (Object)"TagLibrary")});
    private final AtomicReference<Map<String, StateHolder>> myMapRef = new AtomicReference<HashMap>(ContainerUtil.newHashMap());
    private final Project myProject;
    private final DumbService myDumbService;
    private volatile ProgressIndicator myIndicator;

    public TraitInjectorService(Project project, DumbService service) {
        this.myProject = project;
        this.myDumbService = service;
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                TraitInjectorService.this.cancelIndicator();
            }
        });
        project.getMessageBus().connect().subscribe(ProjectTopics.MODULES, (Object)new ModuleAdapter(){

            public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                HashMap newMap;
                Map existingMap;
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/references/TraitInjectorService$2", "modulesRenamed"));
                }
                if (modules == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/plugins/grails/references/TraitInjectorService$2", "modulesRenamed"));
                }
                if (oldNameProvider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNameProvider", "org/jetbrains/plugins/grails/references/TraitInjectorService$2", "modulesRenamed"));
                }
                TraitInjectorService.this.cancelIndicator();
                do {
                    existingMap = (Map)TraitInjectorService.this.myMapRef.get();
                    newMap = ContainerUtil.newHashMap((Map)existingMap);
                    for (Module module : modules) {
                        String oldName = (String)oldNameProvider.fun((Object)module);
                        StateHolder state = (StateHolder)newMap.remove(oldName);
                        if (state == null) continue;
                        newMap.put(module.getName(), state);
                    }
                } while (!TraitInjectorService.this.myMapRef.compareAndSet(existingMap, Collections.unmodifiableMap(newMap)));
            }
        });
    }

    @NotNull
    public static TraitInjectorService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/references/TraitInjectorService", "getInstance"));
        }
        TraitInjectorService traitInjectorService = (TraitInjectorService)ObjectUtils.notNull((Object)ServiceManager.getService((Project)project, TraitInjectorService.class));
        if (traitInjectorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/TraitInjectorService", "getInstance"));
        }
        return traitInjectorService;
    }

    @NotNull
    public static Collection<String> getInjectedTraits(@NotNull GrTypeDefinition clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/grails/references/TraitInjectorService", "getInjectedTraits"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)clazz);
        if (module == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/TraitInjectorService", "getInjectedTraits"));
            }
            return list;
        }
        StateHolder state = TraitInjectorService.getInstance((Project)clazz.getProject()).myMapRef.get().get(module.getName());
        if (state == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/TraitInjectorService", "getInjectedTraits"));
            }
            return list;
        }
        Collection collection = state.traits.get(ARTEFACT_TO_NAME.get((Object)GrailsUtils.calculateArtifactType((PsiClass)clazz)));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/TraitInjectorService", "getInjectedTraits"));
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getInjectedTraits(@NotNull PsiElement context, @NotNull String artefactType) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/TraitInjectorService", "getInjectedTraits"));
        }
        if (artefactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artefactType", "org/jetbrains/plugins/grails/references/TraitInjectorService", "getInjectedTraits"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/TraitInjectorService", "getInjectedTraits"));
            }
            return list;
        }
        StateHolder state = TraitInjectorService.getInstance((Project)context.getProject()).myMapRef.get().get(module.getName());
        if (state == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/TraitInjectorService", "getInjectedTraits"));
            }
            return list;
        }
        Collection collection = state.traits.get(artefactType);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/TraitInjectorService", "getInjectedTraits"));
        }
        return collection;
    }

    public static void queueUpdate(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/references/TraitInjectorService", "queueUpdate"));
        }
        TraitInjectorService.getInstance(project).queueUpdate();
    }

    public void queueUpdate() {
        if (this.myProject.isDisposed()) {
            return;
        }
        LOG.trace(this.myProject + ": Update requested");
        if (this.myDumbService.isDumb()) {
            LOG.debug(this.myProject + ": Update not queued, project is dumb");
            this.myDumbService.runWhenSmart(this::queueUpdate);
            return;
        }
        this.cancelIndicator();
        ProgressIndicatorUtils.scheduleWithWriteActionPriority((Executor)GrailsExecutorHolder.ourExecutorService, (ReadTask)new ReadTask(){

            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/grails/references/TraitInjectorService$3", "onCanceled"));
                }
                LOG.debug(TraitInjectorService.this.myProject + ": Update canceled");
                TraitInjectorService.this.queueUpdate();
            }

            public ReadTask.Continuation runBackgroundProcess(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/grails/references/TraitInjectorService$3", "runBackgroundProcess"));
                }
                RunDataHolder dataHolder = (RunDataHolder)TraitInjectorService.this.myDumbService.runReadActionInSmartMode(() -> TraitInjectorService.this.createRunData());
                if (dataHolder != null && !dataHolder.dataList.isEmpty()) {
                    indicator.checkCanceled();
                    TraitInjectorService.this.scheduleRunData(dataHolder);
                }
                return null;
            }
        });
        LOG.debug(this.myProject + ": Update queued");
    }

    private void cancelIndicator() {
        ProgressIndicator indicator = this.myIndicator;
        if (indicator != null) {
            indicator.cancel();
            this.myIndicator = null;
            LOG.debug(this.myProject + ": Indicator cancelled");
        }
    }

    @Nullable
    protected RunDataHolder createRunData() {
        LOG.debug(this.myProject + ": Checking modules and creating run data");
        Collection modules = FindClassUtil.findModulesWithClass((Project)this.myProject, (String)TRAIT_INJECTOR_FQN);
        if (modules.isEmpty()) {
            LOG.debug(this.myProject + ": No modules with TraitInjector");
            return null;
        }
        Map<String, StateHolder> oldMap = this.myMapRef.get();
        HashMap newMap = ContainerUtil.newHashMap();
        ArrayList dataList = ContainerUtil.newArrayList();
        for (Module module : modules) {
            String key;
            StateHolder oldState;
            RunData data = (RunData)TraitInjectorService.runAndHandleException(module, () -> this.lambda$createRunData$0(oldState = oldMap.get(key = module.getName()), module));
            if (data == null) {
                if (oldState == null) continue;
                newMap.put(key, oldMap.get(key));
                continue;
            }
            dataList.add(data);
        }
        return new RunDataHolder(dataList, oldMap, newMap);
    }

    @Nullable
    private RunData checkIfModuleNeedsUpdate(@Nullable StateHolder oldState, @NotNull Module module) throws CantRunException {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/references/TraitInjectorService", "checkIfModuleNeedsUpdate"));
        }
        LOG.debug(module + ": Checking module");
        GlobalSearchScope scope2 = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        Collection factories = FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)"grails.factories", (GlobalSearchScope)scope2);
        List<String> factoriesPaths = factories.stream().map(VirtualFile::getPath).collect(Collectors.toList());
        if (oldState != null && oldState.knownFactories.equals(factoriesPaths)) {
            LOG.debug(module + ": Factories not changed");
            return null;
        }
        JavaParameters params = GroovyScriptRunConfiguration.createJavaParametersWithSdk((Module)module);
        DefaultGroovyScriptRunner.configureGenericGroovyRunner((JavaParameters)params, (Module)module, (String)"groovy.ui.GroovyMain", (boolean)false, (boolean)true);
        params.getClassPath().add(PathUtil.getJarPathForClass(GrailsRtMarker.class));
        params.setDefaultCharset(this.myProject);
        params.getProgramParametersList().add(GrailsRtMarker.class.getResource("/idea-injected-traits.groovy").toString());
        params.setUseClasspathJar(true);
        params.setPassProgramParametersViaClasspathJar(true);
        GeneralCommandLine commandLine = CommandLineBuilder.createFromJavaParameters((SimpleJavaParameters)params, (Project)this.myProject, (boolean)true);
        LOG.debug(module + ": Command line created");
        LOG.trace(module + ": " + commandLine.getCommandLineString());
        return new RunData(module.getName(), module, factoriesPaths, commandLine);
    }

    private void scheduleRunData(@NotNull RunDataHolder dataHolder) {
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "org/jetbrains/plugins/grails/references/TraitInjectorService", "scheduleRunData"));
        }
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        this.myIndicator = indicator;
        LOG.debug(this.myProject + ": Scheduling run data");
        GrailsExecutorHolder.ourExecutorService.submit(() -> this.lambda$scheduleRunData$2(dataHolder, (ProgressIndicator)indicator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runData(@NotNull RunDataHolder dataHolder, @NotNull ProgressIndicator indicator) {
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "org/jetbrains/plugins/grails/references/TraitInjectorService", "runData"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/grails/references/TraitInjectorService", "runData"));
        }
        boolean needToRestartHighlighting = false;
        try {
            for (RunData data : dataHolder.dataList) {
                MultiMap traits = (MultiMap)TraitInjectorService.runAndHandleException(data.module, () -> {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/grails/references/TraitInjectorService", "lambda$runData$3"));
                    }
                    return TraitInjectorService.runData(data, indicator);
                });
                if (traits == null) continue;
                dataHolder.newMap.put(data.key, new StateHolder(data.knownFactories, (MultiMap<String, String>)traits));
                StateHolder oldState = dataHolder.oldMap.get(data.key);
                needToRestartHighlighting |= oldState == null || !traits.equals((Object)oldState.traits);
            }
            indicator.checkCanceled();
            Map<String, StateHolder> newMap = Collections.unmodifiableMap(dataHolder.newMap);
            if (!this.myMapRef.compareAndSet(dataHolder.oldMap, newMap)) {
                LOG.warn(this.myProject + ": State changed, updating anyway");
                this.myMapRef.set(newMap);
            } else {
                LOG.debug(this.myProject + ": State updated");
            }
        }
        finally {
            this.myIndicator = null;
            if (needToRestartHighlighting) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    PsiManager.getInstance((Project)this.myProject).dropResolveCaches();
                    GroovyPsiManager.getInstance((Project)this.myProject).dropTypesCache();
                    DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
                    LOG.debug(this.myProject + ": Highlighting restarted");
                }, this.myProject.getDisposed());
            }
        }
    }

    @Nullable
    private static MultiMap<String, String> runData(@NotNull RunData data, @NotNull ProgressIndicator indicator) throws ExecutionException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/plugins/grails/references/TraitInjectorService", "runData"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/grails/references/TraitInjectorService", "runData"));
        }
        indicator.checkCanceled();
        Module module = data.module;
        GeneralCommandLine commandLine = data.commandLine;
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
        ProcessOutput output = handler.runProcessWithProgressIndicator(indicator, 60000);
        if (output.getExitCode() != 0) {
            LOG.debug(module + ": Script exited with " + output.getExitCode() + ". Stderr: '" + output.getStderr() + "'");
            return null;
        }
        String stdout = output.getStdout();
        LOG.debug(module + ": Script output: " + stdout);
        try {
            return TraitInjectorService.doParseOutput(stdout);
        }
        catch (Throwable e) {
            LOG.info(module + ": Error parsing output", e);
            return null;
        }
    }

    @NotNull
    private static MultiMap<String, String> doParseOutput(@NotNull String output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "org/jetbrains/plugins/grails/references/TraitInjectorService", "doParseOutput"));
        }
        MultiMap result = MultiMap.create();
        LinkedList lines = ContainerUtil.newLinkedList((Object[])output.split("\n"));
        while (!((String)lines.pop()).equals(MARKER)) {
        }
        while (lines.size() > 1) {
            String traitName = (String)lines.pop();
            int artifactCount = Integer.parseInt((String)lines.pop());
            while (artifactCount-- > 0) {
                String artifactName = (String)lines.pop();
                result.putValue((Object)artifactName, (Object)traitName);
            }
        }
        assert (((String)lines.pop()).equals(MARKER));
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/TraitInjectorService", "doParseOutput"));
        }
        return multiMap;
    }

    @Nullable
    public PersistentState getState() {
        Map<String, StateHolder> map2 = this.myMapRef.get();
        return map2.isEmpty() ? null : new PersistentState(map2);
    }

    public void loadState(PersistentState persistentState) {
        this.myMapRef.set(Collections.unmodifiableMap(persistentState.state));
    }

    @Nullable
    private static <T> T runAndHandleException(@NotNull Module context, @NotNull ThrowableComputable<T, ? extends ExecutionException> runnable) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/TraitInjectorService", "runAndHandleException"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/plugins/grails/references/TraitInjectorService", "runAndHandleException"));
        }
        try {
            return (T)runnable.compute();
        }
        catch (ExecutionException e) {
            ExecutionUtil.handleExecutionError((Project)context.getProject(), (String)ToolWindowId.RUN, (String)"Collecting Injected Traits", (ExecutionException)e);
            LOG.info(context + ": Error executing script", (Throwable)e);
            return null;
        }
    }

    private /* synthetic */ void lambda$scheduleRunData$2(@NotNull RunDataHolder dataHolder, ProgressIndicator indicator) {
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "org/jetbrains/plugins/grails/references/TraitInjectorService", "lambda$scheduleRunData$2"));
        }
        ProgressManager.getInstance().runProcess(() -> {
            if (dataHolder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "org/jetbrains/plugins/grails/references/TraitInjectorService", "lambda$null$1"));
            }
            this.runData(dataHolder, indicator);
        }, indicator);
    }

    private /* synthetic */ RunData lambda$createRunData$0(StateHolder oldState, Module module) throws ExecutionException {
        return this.checkIfModuleNeedsUpdate(oldState, module);
    }

    public static class PersistentState {
        public HashMap<String, StateHolder> state = new HashMap();

        public PersistentState(Map<String, StateHolder> map2) {
            this.state.putAll(map2);
        }

        public PersistentState() {
        }
    }

    public static class StateHolder {
        @NotNull
        public Collection<String> knownFactories;
        @NotNull
        public SerializableStringMultiMap traits;

        public StateHolder(@NotNull Collection<String> knownFactories, @NotNull MultiMap<String, String> traits) {
            if (knownFactories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "knownFactories", "org/jetbrains/plugins/grails/references/TraitInjectorService$StateHolder", "<init>"));
            }
            if (traits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traits", "org/jetbrains/plugins/grails/references/TraitInjectorService$StateHolder", "<init>"));
            }
            this.knownFactories = new ArrayList<String>();
            this.traits = new SerializableStringMultiMap();
            this.knownFactories.addAll(knownFactories);
            this.traits.putAllValues(traits);
        }

        public StateHolder() {
            this.knownFactories = new ArrayList<String>();
            this.traits = new SerializableStringMultiMap();
        }
    }

    private static class RunData {
        @NotNull
        final String key;
        @NotNull
        final Module module;
        @NotNull
        final List<String> knownFactories;
        @NotNull
        final GeneralCommandLine commandLine;

        RunData(@NotNull String key, @NotNull Module module, @NotNull List<String> factories, @NotNull GeneralCommandLine line) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/plugins/grails/references/TraitInjectorService$RunData", "<init>"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/grails/references/TraitInjectorService$RunData", "<init>"));
            }
            if (factories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factories", "org/jetbrains/plugins/grails/references/TraitInjectorService$RunData", "<init>"));
            }
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/plugins/grails/references/TraitInjectorService$RunData", "<init>"));
            }
            this.key = key;
            this.module = module;
            this.knownFactories = factories;
            this.commandLine = line;
        }
    }

    private static class RunDataHolder {
        @NotNull
        final List<RunData> dataList;
        @NotNull
        final Map<String, StateHolder> oldMap;
        @NotNull
        final Map<String, StateHolder> newMap;

        RunDataHolder(@NotNull List<RunData> dataList, @NotNull Map<String, StateHolder> oldMap, @NotNull Map<String, StateHolder> newMap) {
            if (dataList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataList", "org/jetbrains/plugins/grails/references/TraitInjectorService$RunDataHolder", "<init>"));
            }
            if (oldMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldMap", "org/jetbrains/plugins/grails/references/TraitInjectorService$RunDataHolder", "<init>"));
            }
            if (newMap == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newMap", "org/jetbrains/plugins/grails/references/TraitInjectorService$RunDataHolder", "<init>"));
            }
            this.dataList = dataList;
            this.oldMap = oldMap;
            this.newMap = newMap;
        }
    }
}

