/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.controller;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.Function;
import icons.JetgroovyIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.util.GrailsUtils;

public class ActionReference
extends PsiReferenceBase<PsiElement>
implements Function<PsiElement, Map<String, PsiMethod>> {
    private final Function<PsiElement, Map<String, PsiMethod>> myControllerResolver;
    private final String myControllerName;
    private Map<String, PsiMethod> myActions;

    public ActionReference(PsiElement element, TextRange range, boolean soft, Function<PsiElement, Map<String, PsiMethod>> controllerResolver) {
        super(element, range, soft);
        TextRange textRange = this.trimExtension(range);
        this.setRangeInElement(textRange);
        this.myControllerResolver = controllerResolver;
        this.myControllerName = null;
    }

    public ActionReference(PsiElement element, boolean soft, Function<PsiElement, Map<String, PsiMethod>> controllerResolver) {
        super(element, soft);
        this.myControllerResolver = controllerResolver;
        this.myControllerName = null;
    }

    public ActionReference(PsiElement element, boolean soft, @NotNull String controllerName) {
        if (controllerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controllerName", "org/jetbrains/plugins/grails/references/controller/ActionReference", "<init>"));
        }
        super(element, soft);
        this.myControllerResolver = this;
        this.myControllerName = controllerName;
    }

    private TextRange trimExtension(TextRange defaultRange) {
        String elementText = this.getElement().getText();
        String value = defaultRange.substring(elementText);
        int dotIndex = value.lastIndexOf(46);
        if (dotIndex >= 0) {
            return TextRange.from((int)defaultRange.getStartOffset(), (int)dotIndex);
        }
        return defaultRange;
    }

    protected TextRange calculateDefaultRangeInElement() {
        TextRange defaultRange = super.calculateDefaultRangeInElement();
        defaultRange = this.trimExtension(defaultRange);
        return defaultRange;
    }

    public PsiElement resolve() {
        String value = this.getValue();
        if (value.isEmpty()) {
            return null;
        }
        return GrailsUtils.toField(this.getActions().get(value));
    }

    public static LookupElementBuilder[] createLookupItems(Collection<String> actionNames) {
        LookupElementBuilder[] res = new LookupElementBuilder[actionNames.size()];
        int i = 0;
        for (String actionName : actionNames) {
            res[i++] = LookupElementBuilder.create((String)actionName).withIcon(JetgroovyIcons.Mvc.Action_method);
        }
        return res;
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = ActionReference.createLookupItems(this.getActions().keySet());
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/controller/ActionReference", "getVariants"));
        }
        return objectArray;
    }

    private Map<String, PsiMethod> getActions() {
        Map res = this.myActions;
        if (res == null) {
            this.myActions = res = (Map)this.myControllerResolver.fun((Object)this.getElement());
        }
        return res;
    }

    @Nullable
    public String getControllerName() {
        return this.myControllerName;
    }

    public Map<String, PsiMethod> fun(PsiElement psiElement) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            return Collections.emptyMap();
        }
        return GrailsUtils.getControllerActions(this.myControllerName, module);
    }
}

