/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.tagSupport;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.references.common.GspTagWrapper;
import org.jetbrains.plugins.grails.references.tagSupport.TagAttributeReferenceProvider;
import org.jetbrains.plugins.grails.util.SafeReference;
import org.jetbrains.plugins.groovy.lang.completion.CompleteReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class GspFieldValueTagSupport
extends TagAttributeReferenceProvider {
    private static final LightCacheKey<PsiReference[]> KEY = LightCacheKey.create();

    public GspFieldValueTagSupport() {
        super("field", "g", new String[]{"fieldValue", "fieldError", "hasErrors", "eachError"});
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull String text, int offset, @NotNull GspTagWrapper gspTagWrapper) {
        PsiClass aClass;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/tagSupport/GspFieldValueTagSupport", "getReferencesByElement"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/grails/references/tagSupport/GspFieldValueTagSupport", "getReferencesByElement"));
        }
        if (gspTagWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gspTagWrapper", "org/jetbrains/plugins/grails/references/tagSupport/GspFieldValueTagSupport", "getReferencesByElement"));
        }
        PsiType beanType = gspTagWrapper.getAttributeValueType("bean");
        if (beanType == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspFieldValueTagSupport", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] cachedValue = (PsiReference[])KEY.getCachedValue(element);
        if (cachedValue != null) {
            if (cachedValue == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspFieldValueTagSupport", "getReferencesByElement"));
            }
            return cachedValue;
        }
        PsiType type = beanType;
        ArrayList<FieldReference> res = new ArrayList<FieldReference>();
        int i = 0;
        while ((aClass = PsiTypesUtil.getPsiClass((PsiType)type)) != null) {
            int i2 = text.indexOf(46, i);
            if (i2 == -1) {
                i2 = text.length();
            }
            String fieldName = text.substring(i, i2);
            PsiMethod getter = GroovyPropertyUtils.findPropertyGetter((PsiClass)aClass, (String)fieldName, null, (boolean)true);
            FieldReference fieldRef = new FieldReference(element, TextRange.from((int)(offset + i), (int)(i2 - i)), aClass, getter);
            res.add(fieldRef);
            if (getter instanceof GrMethod) {
                type = ((GrMethod)getter).getInferredReturnType();
            } else {
                if (getter == null) break;
                type = getter.getReturnType();
            }
            if (i2 == text.length()) break;
            i = i2 + 1;
        }
        PsiReference[] resArray = res.toArray(new PsiReference[res.size()]);
        SafeReference.makeReferencesSafe(resArray);
        resArray = (PsiReference[])KEY.putCachedValue(element, (Object)resArray);
        if (resArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspFieldValueTagSupport", "getReferencesByElement"));
        }
        return resArray;
    }

    private static class FieldReference
    extends PsiReferenceBase<PsiElement> {
        private PsiClass myBeanClass;
        private PsiMethod myGetter;

        protected FieldReference(PsiElement element, TextRange range, @NotNull PsiClass beanClass, @Nullable PsiMethod getter) {
            if (beanClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanClass", "org/jetbrains/plugins/grails/references/tagSupport/GspFieldValueTagSupport$FieldReference", "<init>"));
            }
            super(element, range, true);
            this.myBeanClass = beanClass;
            this.myGetter = getter;
        }

        public PsiElement resolve() {
            return this.myGetter;
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            if (!(this.myGetter instanceof GrAccessorMethod)) {
                String s2 = GroovyPropertyUtils.getPropertyNameByGetterName((String)newElementName, (boolean)PsiType.BOOLEAN.equals((Object)this.myGetter.getReturnType()));
                if (s2 == null) {
                    return this.getElement();
                }
                newElementName = s2;
            }
            TextRange rangeBefore = this.getRangeInElement();
            PsiElement result = super.handleElementRename(newElementName);
            this.setRangeInElement(TextRange.from((int)rangeBefore.getStartOffset(), (int)newElementName.length()));
            return result;
        }

        @NotNull
        public Object[] getVariants() {
            Map propertyGetters = PropertyUtil.getAllProperties((PsiClass)this.myBeanClass, (boolean)false, (boolean)true);
            Object[] res = new Object[propertyGetters.size()];
            int i = 0;
            for (Map.Entry entry : propertyGetters.entrySet()) {
                PsiMethod getter = (PsiMethod)entry.getValue();
                res[i++] = CompleteReferenceExpression.createPropertyLookupElement((PsiMethod)getter, null, null);
            }
            if (res == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/tagSupport/GspFieldValueTagSupport$FieldReference", "getVariants"));
            }
            return res;
        }
    }
}

